/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.InetAddress;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NetworkBasicView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            NetworkBasicView.this.refreshViewKvpNode();
            NetworkBasicView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    GridContentPanel manualContent;
    KvpField ipAssignDhcpKvpField;
    KvpField ipAddressKvpField;
    KvpField subnetMaskKvpField;
    KvpField gatewayKvpField;
    KvpField nameServerKvpField;
    KvpField domainKvpField;
    KvpField hostNameKvpField;
    JRadioButton ipAssignDhcp_UIC;
    JRadioButton ipAssignManual_UIC;
    JTextField ipAddress_UIC;
    JTextField subnetMask_UIC;
    JTextField gateway_UIC;
    JTextField nameServer_UIC;
    JTextField domain_UIC;
    JTextField hostName_UIC;

    public NetworkBasicView() throws Exception {
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == NetworkBasicView.this.ipAssignDhcp_UIC || object == NetworkBasicView.this.ipAssignManual_UIC) {
                    NetworkBasicView.this.ipAssignDhcpKvpField.setStringValue(RciProtocol.toString((boolean)NetworkBasicView.this.ipAssignDhcp_UIC.isSelected()));
                    NetworkBasicView.this.manualContent.setContainerEnabled(!NetworkBasicView.this.ipAssignDhcp_UIC.isSelected());
                } else if (object == NetworkBasicView.this.ipAddress_UIC) {
                    NetworkBasicView.this.ipAddressKvpField.setStringValue(NetworkBasicView.this.ipAddress_UIC.getText());
                } else if (object == NetworkBasicView.this.subnetMask_UIC) {
                    NetworkBasicView.this.subnetMaskKvpField.setStringValue(NetworkBasicView.this.subnetMask_UIC.getText());
                } else if (object == NetworkBasicView.this.gateway_UIC) {
                    NetworkBasicView.this.gatewayKvpField.setStringValue(NetworkBasicView.this.gateway_UIC.getText());
                } else if (object == NetworkBasicView.this.nameServer_UIC) {
                    NetworkBasicView.this.nameServerKvpField.setStringValue(NetworkBasicView.this.nameServer_UIC.getText());
                } else if (object == NetworkBasicView.this.domain_UIC) {
                    NetworkBasicView.this.domainKvpField.setStringValue(NetworkBasicView.this.domain_UIC.getText());
                } else if (object == NetworkBasicView.this.hostName_UIC) {
                    NetworkBasicView.this.hostNameKvpField.setStringValue(NetworkBasicView.this.hostName_UIC.getText());
                }
            }
        };
        this.content.addTextLine("IPAssignMethod");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ipAssignDhcp_UIC = this.content.addJRadioButton("IPAssignDhcp", (ActionListener)controlChangeAdapter);
        buttonGroup.add(this.ipAssignDhcp_UIC);
        this.ipAssignManual_UIC = this.content.addJRadioButton("IPAssignManual", (ActionListener)controlChangeAdapter);
        buttonGroup.add(this.ipAssignManual_UIC);
        this.manualContent = new GridContentPanel(1);
        this.ipAddress_UIC = this.manualContent.addJTextField("IPAddress", "IPAddressDesc", 100, (FocusListener)controlChangeAdapter);
        this.subnetMask_UIC = this.manualContent.addJTextField("SubnetMask", "SubnetMaskDesc", 100, (FocusListener)controlChangeAdapter);
        this.gateway_UIC = this.manualContent.addJTextField("Gateway", "GatewayDesc", 100, (FocusListener)controlChangeAdapter);
        this.ipAddress_UIC.setDocument(this.createNetworkAddressDocument());
        this.subnetMask_UIC.setDocument(this.createNetworkAddressDocument());
        this.gateway_UIC.setDocument(this.createNetworkAddressDocument());
        this.content.addSubPanel((JComponent)this.manualContent);
        this.content.addTextLine("IPAssignManualCaveat");
        this.content.addVGlue();
    }

    public String getName() {
        return "NetworkBasicView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.ipAssignDhcpKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "dhcp");
        this.ipAddressKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "ip");
        this.subnetMaskKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "subnet");
        this.gatewayKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "gateway");
        this.nameServerKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "dns");
        this.domainKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "network", "domain");
        this.hostNameKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "network", "hostname");
    }

    private void refreshViewControls() {
        this.ipAddress_UIC.setEnabled(this.ipAddressKvpField != null);
        if (this.ipAddressKvpField != null) {
            this.ipAddress_UIC.setText(this.ipAddressKvpField.getStringValue());
        }
        this.subnetMask_UIC.setEnabled(this.subnetMaskKvpField != null);
        if (this.subnetMaskKvpField != null) {
            this.subnetMask_UIC.setText(this.subnetMaskKvpField.getStringValue());
        }
        this.gateway_UIC.setEnabled(this.gatewayKvpField != null);
        if (this.gatewayKvpField != null) {
            this.gateway_UIC.setText(this.gatewayKvpField.getStringValue());
        }
        this.ipAssignDhcp_UIC.setEnabled(this.ipAssignDhcpKvpField != null);
        this.ipAssignManual_UIC.setEnabled(this.ipAssignDhcpKvpField != null);
        if (this.ipAssignDhcpKvpField != null) {
            boolean bl = RciProtocol.booleanValue((String)this.ipAssignDhcpKvpField.getStringValue());
            this.ipAssignDhcp_UIC.setSelected(bl);
            this.ipAssignManual_UIC.setSelected(!bl);
            this.manualContent.setContainerEnabled(!bl);
        }
        if (this.ipAddressKvpField == null) {
            this.content.setContainerEnabled(false);
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        try {
            if (this.ipAssignDhcp_UIC.isSelected()) {
                return;
            }
            if (this.ipAssignManual_UIC.isSelected()) {
                if (!ValidationHelper.isValidIPAddress((String)this.ipAddress_UIC.getText()) || InetAddress.getByName(this.ipAddress_UIC.getText()).equals(InetAddress.getByName("0.0.0.0"))) {
                    collection.add(new ValidationError("IpAddressValidationError"));
                }
                if (!ValidationHelper.isValidNetworkAddress((String)this.subnetMask_UIC.getText()) || InetAddress.getByName(this.subnetMask_UIC.getText()).equals(InetAddress.getByName("0.0.0.0")) || InetAddress.getByName(this.subnetMask_UIC.getText()).equals(InetAddress.getByName("255.255.255.255"))) {
                    collection.add(new ValidationError("SubnetMaskValidationError"));
                }
                if (!ValidationHelper.isValidIPAddress((String)this.gateway_UIC.getText())) {
                    collection.add(new ValidationError("GatewayValidationError"));
                }
            } else {
                collection.add(new ValidationError("NetworkAssignValidationError"));
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in NetworkBasicView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

