/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.core.VersionManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1769686275538599176L;
    private transient HashMap mappedElements = new HashMap();
    private transient ArrayList orderedElements = new ArrayList();

    public ArrayMap() {
    }

    public ArrayMap(Map map) {
        this();
        this.putAll(map);
    }

    public ArrayMap(ArrayMap arrayMap) {
        this();
        this.mappedElements.putAll(arrayMap.mappedElements);
        this.orderedElements.addAll(arrayMap.orderedElements);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        objectInputStream.defaultReadObject();
        this.mappedElements = (HashMap)objectInputStream.readObject();
        this.orderedElements = (ArrayList)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = VersionManager.getTargetVersion();
        objectOutputStream.writeInt(n);
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.mappedElements);
        objectOutputStream.writeObject(this.orderedElements);
    }

    public int size() {
        return this.mappedElements.size();
    }

    public boolean isEmpty() {
        return this.mappedElements.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.mappedElements.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mappedElements.containsValue(object);
    }

    public Object get(Object object) {
        return this.mappedElements.get(object);
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.get(object);
        if (object3 == null) {
            this.orderedElements.add(object2);
        } else {
            int n = this.orderedElements.indexOf(object3);
            this.orderedElements.set(n, object2);
        }
        return this.mappedElements.put(object, object2);
    }

    public Object putAt(Object object, int n, Object object2) {
        Object object3 = this.get(object);
        this.remove(object);
        this.orderedElements.add(n, object2);
        return this.mappedElements.put(object, object2);
    }

    public Object remove(Object object) {
        Object v = this.mappedElements.remove(object);
        if (v != null) {
            this.orderedElements.remove(v);
        }
        return v;
    }

    public void putAll(Map map) {
        if (map instanceof ArrayMap) {
            Iterator iterator = ((ArrayMap)map).orderedElements.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Iterator iterator2 = ((ArrayMap)map).mappedElements.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    if (entry.getValue() != e) continue;
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void clear() {
        this.orderedElements.clear();
        this.mappedElements.clear();
    }

    public Set keySet() {
        return this.mappedElements.keySet();
    }

    public Collection values() {
        return this.orderedElements;
    }

    public Set entrySet() {
        return this.mappedElements.entrySet();
    }

    public boolean equals(Object object) {
        return this.mappedElements.equals(object);
    }

    public int hashCode() {
        return this.mappedElements.hashCode();
    }

    public List valuesList() {
        return this.orderedElements;
    }

    public ArrayMap copy() {
        return new ArrayMap(this);
    }
}

