/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.ui.CustomPanel;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.ConfigSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.Format;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GridContentPanel
extends CustomPanel {
    private static boolean debugBoundaries = false;
    GridBagLayout gbl;
    GridBagConstraints c;
    int rowCount;
    int maxColumns;
    boolean edittingRow = false;
    Color headingBarColor = ConfigSettings.getColor("WindowSettings", "HeadingBarBackgroundColor");

    public GridContentPanel(int n) {
        this(null, n);
    }

    public GridContentPanel(String string, int n) {
        super(string);
        if (this.headingBarColor == null) {
            this.headingBarColor = new Color(197, 214, 252);
        }
        if (debugBoundaries) {
            this.setOpaque(true);
            this.setBackground(Color.PINK);
        }
        this.gbl = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.anchor = 17;
        this.c.insets = new Insets(3, 5, 3, 5);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridheight = 1;
        this.rowCount = 0;
        this.maxColumns = n * 4;
        this.setLayout(this.gbl);
    }

    public void setContainerEnabled(boolean bl) {
        this.setContainerEnabled(this, bl);
    }

    public void setContainerEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
            if (!(componentArray[i] instanceof Container)) continue;
            this.setContainerEnabled((Container)componentArray[i], bl);
        }
    }

    public void addHeadingBar(String string) {
        String string2 = ConfigResource.getUiRbString(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.headingBarColor);
        jLabel.setAlignmentX(0.0f);
        if (debugBoundaries) {
            jLabel.setBorder(BorderFactory.createEtchedBorder());
        }
        this.c.weightx = 1.0;
        this.c.anchor = 17;
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = this.rowCount++;
        this.c.gridheight = 1;
        this.c.gridwidth = this.maxColumns;
        this.add((Component)jLabel, this.c);
    }

    public void addBlankLine() {
        double d = this.c.weighty;
        this.c.weighty = 0.0;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = this.rowCount++;
        this.add((Component)new JLabel(), this.c);
    }

    public void addTextLine(String string) {
        String string2 = ConfigResource.getUiRbString(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setAlignmentX(0.0f);
        if (debugBoundaries) {
            jLabel.setBorder(BorderFactory.createEtchedBorder());
        }
        this.c.weightx = 1.0;
        this.c.anchor = 17;
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = this.rowCount++;
        this.c.gridheight = 1;
        this.c.gridwidth = this.maxColumns;
        this.add((Component)jLabel, this.c);
    }

    public JLabel addColumnHeading(String string, ActionListener actionListener) {
        return this.addColumnHeading(string, actionListener, 0, true);
    }

    public JLabel addColumnHeading(String string, ActionListener actionListener, int n, boolean bl) {
        JLabel jLabel = new JLabel(ConfigResource.getUiRbString(string));
        this.addField(null, jLabel, null, n, bl);
        return jLabel;
    }

    public JLabel addJLabel(String string, String string2) {
        return this.addJLabel(string, string2, 0, 0, true);
    }

    public JLabel addJLabel(String string, String string2, int n) {
        return this.addJLabel(string, string2, n, 0, true);
    }

    public JLabel addJLabel(String string, String string2, int n, int n2, boolean bl) {
        JLabel jLabel = new JLabel();
        if (n > 0) {
            jLabel.setMaximumSize(new Dimension(n, 20));
            jLabel.setPreferredSize(new Dimension(n, 20));
        }
        this.addField(string, jLabel, string2, n2, bl);
        return jLabel;
    }

    public JTextField addJTextField(String string, String string2, int n, FocusListener focusListener) {
        return this.addJTextField(string, string2, n, focusListener, 0, true);
    }

    public JTextField addJTextField(String string, String string2, int n, FocusListener focusListener, int n2, boolean bl) {
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(focusListener);
        jTextField.setMaximumSize(new Dimension(n, 20));
        jTextField.setPreferredSize(new Dimension(n, 20));
        this.addField(string, jTextField, string2, n2, bl);
        return jTextField;
    }

    public JFormattedTextField addJFormattedTextField(String string, String string2, JFormattedTextField.AbstractFormatter abstractFormatter, int n, FocusListener focusListener) {
        return this.addJFormattedTextField(string, string2, abstractFormatter, n, focusListener, 0, true);
    }

    public JFormattedTextField addJFormattedTextField(String string, String string2, JFormattedTextField.AbstractFormatter abstractFormatter, int n, FocusListener focusListener, int n2, boolean bl) {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(abstractFormatter);
        jFormattedTextField.addFocusListener(focusListener);
        jFormattedTextField.setMaximumSize(new Dimension(n, 20));
        jFormattedTextField.setPreferredSize(new Dimension(n, 20));
        this.addField(string, jFormattedTextField, string2, n2, bl);
        return jFormattedTextField;
    }

    public JFormattedTextField addJFormattedTextField(String string, String string2, Format format, int n, FocusListener focusListener) {
        return this.addJFormattedTextField(string, string2, format, n, focusListener, 0, true);
    }

    public JFormattedTextField addJFormattedTextField(String string, String string2, Format format, int n, FocusListener focusListener, int n2, boolean bl) {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(format);
        jFormattedTextField.addFocusListener(focusListener);
        jFormattedTextField.setMaximumSize(new Dimension(n, 20));
        jFormattedTextField.setPreferredSize(new Dimension(n, 20));
        this.addField(string, jFormattedTextField, string2, n2, bl);
        return jFormattedTextField;
    }

    public JPasswordField addJPasswordField(String string, String string2, int n, FocusListener focusListener) {
        return this.addJPasswordField(string, string2, n, focusListener, 0, true);
    }

    public JPasswordField addJPasswordField(String string, String string2, int n, FocusListener focusListener, int n2, boolean bl) {
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.addFocusListener(focusListener);
        jPasswordField.setMaximumSize(new Dimension(n, 20));
        jPasswordField.setPreferredSize(new Dimension(n, 20));
        this.addField(string, jPasswordField, string2, n2, bl);
        return jPasswordField;
    }

    public JCheckBox addJCheckBox(String string, ActionListener actionListener) {
        return this.addJCheckBox(string, actionListener, 0, true);
    }

    public JCheckBox addJCheckBox(String string, ActionListener actionListener, int n, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox();
        if (string != null) {
            jCheckBox.setText(ConfigResource.getUiRbString(string));
        }
        jCheckBox.setOpaque(false);
        jCheckBox.addActionListener(actionListener);
        this.addField(null, jCheckBox, null, n, bl);
        return jCheckBox;
    }

    public JComboBox addJComboBox(String string, String string2, String[] stringArray, ActionListener actionListener) {
        return this.addJComboBox(string, string2, stringArray, actionListener, 0, true);
    }

    public JComboBox addJComboBox(String string, String string2, String[] stringArray, ActionListener actionListener, int n, boolean bl) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.addActionListener(actionListener);
        this.addField(string, jComboBox, string2, n, bl);
        return jComboBox;
    }

    public JRadioButton addJRadioButton(String string, ActionListener actionListener) {
        return this.addJRadioButton(string, actionListener, null, 0, true);
    }

    public JRadioButton addJRadioButton(String string, ActionListener actionListener, ButtonGroup buttonGroup) {
        return this.addJRadioButton(string, actionListener, buttonGroup, 0, true);
    }

    public JRadioButton addJRadioButton(String string, ActionListener actionListener, ButtonGroup buttonGroup, int n, boolean bl) {
        JRadioButton jRadioButton = string != null ? new JRadioButton(ConfigResource.getUiRbString(string)) : new JRadioButton();
        jRadioButton.setOpaque(false);
        jRadioButton.addActionListener(actionListener);
        this.addField(null, jRadioButton, null, n, bl);
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButton);
        }
        return jRadioButton;
    }

    public void addSubPanel(JComponent jComponent) {
        this.freshRow();
        JLabel jLabel = new JLabel();
        if (debugBoundaries) {
            jLabel.setBorder(BorderFactory.createEtchedBorder());
        }
        this.c.weightx = 0.0;
        this.c.anchor = 13;
        this.c.fill = 0;
        this.c.gridx = 0;
        this.c.gridy = this.rowCount;
        this.c.gridheight = 1;
        this.c.gridwidth = 1;
        this.add((Component)jLabel, this.c);
        jComponent.setAlignmentX(0.0f);
        if (debugBoundaries) {
            jComponent.setBorder(BorderFactory.createEtchedBorder());
        }
        this.c.weightx = 1.0;
        this.c.anchor = 17;
        this.c.fill = 2;
        this.c.gridx = 1;
        this.c.gridy = this.rowCount;
        this.c.gridheight = 1;
        this.c.gridwidth = this.maxColumns - 1;
        this.add((Component)jComponent, this.c);
        this.nextRow();
    }

    public void addVGlue() {
        this.freshRow();
        double d = this.c.weighty;
        this.c.weighty = 1.0;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = this.rowCount;
        this.add((Component)new JLabel(), this.c);
        this.c.weighty = d;
        this.nextRow();
    }

    public JButton addAction(String string, Action action, String string2) {
        return this.addAction(string, action, string2, 0, true);
    }

    public JButton addAction(String string, Action action, String string2, int n, boolean bl) {
        JButton jButton = new JButton(action);
        this.addField(string, jButton, string2, n, bl);
        return jButton;
    }

    public void addField(String string, Component component, String string2) {
        this.addField(string, component, string2, 0, true);
    }

    public void addField(String string, Component component, String string2, int n, boolean bl) {
        JLabel jLabel;
        int n2 = n * 4;
        this.edittingRow = true;
        int n3 = 1;
        if (string == null) {
            ++n3;
        }
        if (string2 == null) {
            ++n3;
        }
        if (n3 > 1 && string2 != null && component instanceof JButton) {
            --n3;
        }
        if (string != null) {
            jLabel = new JLabel(ConfigResource.getUiRbString(string));
            if (debugBoundaries) {
                jLabel.setBorder(BorderFactory.createEtchedBorder());
            }
            this.c.weightx = 0.0;
            this.c.anchor = 13;
            this.c.fill = 0;
            this.c.gridx = n2++;
            this.c.gridy = this.rowCount;
            this.c.gridheight = 1;
            this.c.gridwidth = 1;
            this.add((Component)jLabel, this.c);
        }
        this.c.weightx = 0.0;
        this.c.anchor = 17;
        this.c.fill = 0;
        this.c.gridx = n2;
        this.c.gridy = this.rowCount;
        this.c.gridheight = 1;
        this.c.gridwidth = n3;
        this.add(component, this.c);
        n2 += n3;
        if (string2 != null) {
            jLabel = new JLabel(ConfigResource.getUiRbString(string2));
            this.c.weightx = 1.0;
            this.c.anchor = 17;
            this.c.fill = 2;
            this.c.gridx = n2++;
            this.c.gridy = this.rowCount;
            this.c.gridheight = 1;
            this.c.gridwidth = 1;
            this.add((Component)jLabel, this.c);
        }
        if (bl) {
            jLabel = new JLabel();
            if (debugBoundaries) {
                jLabel.setBorder(BorderFactory.createEtchedBorder());
            }
            this.c.weightx = 1.0;
            this.c.anchor = 17;
            this.c.fill = 2;
            this.c.gridx = this.maxColumns - 1;
            this.c.gridy = this.rowCount;
            this.c.gridheight = 1;
            this.c.gridwidth = 1;
            this.add((Component)jLabel, this.c);
            this.nextRow();
        } else {
            jLabel = new JLabel();
            if (debugBoundaries) {
                jLabel.setBorder(BorderFactory.createEtchedBorder());
            }
            this.c.weightx = 0.0;
            this.c.anchor = 17;
            this.c.fill = 0;
            this.c.gridx = n2++;
            this.c.gridy = this.rowCount;
            this.c.gridheight = 1;
            this.c.gridwidth = 1;
            this.add((Component)jLabel, this.c);
        }
    }

    private int nextRow() {
        ++this.rowCount;
        this.edittingRow = false;
        return this.rowCount;
    }

    private void freshRow() {
        if (this.edittingRow) {
            this.nextRow();
        }
    }
}

