/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.RciCommand;
import com.digi.config.core.RciConnection;
import com.digi.config.core.RciHttpConnection;
import com.digi.config.ui.SplashScreenPanel;
import java.net.MalformedURLException;
import java.net.URL;

public class RciServer {
    private static RciServer defaultInstance = null;
    private String name;
    private URL url;
    private RciConnection rciConnection;
    private static final String RCI_SERVER_PATH = "/UE/rci";
    private static final String DEFAULT_RCI_SERVER_HOST = "localhost:8080";
    private static final String DEFAULT_RCI_PROTOCOL = "http";

    public static RciServer getDefaultInstance() {
        return defaultInstance;
    }

    public static void setDefaultInstance(RciServer rciServer) {
        defaultInstance = rciServer;
    }

    public RciServer() throws MalformedURLException {
        String string;
        SplashScreenPanel.currentScreen().updateProgress();
        String string2 = System.getProperties().getProperty("RciHost");
        if (string2 == null || string2.trim().length() == 0) {
            string2 = DEFAULT_RCI_SERVER_HOST;
        }
        string = (string = System.getProperties().getProperty("RciProtocol")) == null || string.trim().length() == 0 ? DEFAULT_RCI_PROTOCOL : string.trim().toLowerCase();
        String string3 = string + "://" + string2 + RCI_SERVER_PATH;
        this.setName(string3);
    }

    public RciServer(String string) throws MalformedURLException {
        this.setName(string);
    }

    public void setName(String string) throws MalformedURLException {
        this.name = string;
        this.url = new URL(string);
        this.rciConnection = null;
    }

    public String getName() {
        return this.name;
    }

    public URL getURL() {
        return this.url;
    }

    public RciConnection getConnection() {
        if (this.rciConnection == null) {
            this.rciConnection = new RciHttpConnection(this.getURL());
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.rciConnection;
    }

    public void sendCommand(RciCommand rciCommand) throws Exception {
        this.getConnection().sendCommand(rciCommand);
    }
}

