/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.util.SystemLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RciCommandError {
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    String context;
    int errorCode;
    int severity;
    String description;
    ArrayList involvedKvpFieldList;

    public RciCommandError(String string, int n, int n2, String string2) {
        this.context = string;
        this.errorCode = n;
        this.description = string2;
        this.involvedKvpFieldList = new ArrayList(3);
    }

    public RciCommandError(String string, Node node) {
        Object object;
        this.context = string;
        this.errorCode = 0;
        this.severity = 1;
        this.description = "";
        this.involvedKvpFieldList = new ArrayList(3);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            object = namedNodeMap.getNamedItem("id");
            if (object != null) {
                try {
                    this.errorCode = Integer.parseInt(object.getNodeValue());
                }
                catch (Exception exception) {
                    SystemLog.log(exception);
                }
            }
            if ((object = namedNodeMap.getNamedItem("severity")) != null) {
                try {
                    this.severity = Integer.parseInt(object.getNodeValue());
                }
                catch (Exception exception) {
                    SystemLog.log(exception);
                }
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equals("desc")) {
                this.description = this.getElementNodeText(node2);
                continue;
            }
            if (!node2.getNodeName().equals("field")) continue;
            this.involvedKvpFieldList.add(this.getElementNodeText(node2));
        }
    }

    public void addInvolvedFieldName(String string) {
        this.involvedKvpFieldList.add(string);
    }

    public String getContext() {
        return this.context;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection getInvolvedFieldNames() {
        return this.involvedKvpFieldList;
    }

    public String toString() {
        String string = this.context + "_" + this.errorCode + ":" + this.description;
        if (this.involvedKvpFieldList.size() > 0) {
            string = string + "(";
            Iterator iterator = this.involvedKvpFieldList.iterator();
            while (iterator.hasNext()) {
                string = string + (String)iterator.next();
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            string = string + ")";
        }
        return string;
    }

    private String getElementNodeText(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            return node2.getNodeValue();
        }
        return "";
    }
}

