/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.util.SystemLog;
import java.util.HashSet;
import java.util.Iterator;

public class DeviceChangeSupport {
    private Device device;
    private HashSet listeners;

    public DeviceChangeSupport(Device device) {
        SplashScreenPanel.currentScreen().updateProgress();
        this.device = device;
        this.listeners = new HashSet();
    }

    public synchronized void addListener(DeviceChangeListener deviceChangeListener) {
        this.listeners.add(deviceChangeListener);
    }

    public synchronized void removeListener(DeviceChangeListener deviceChangeListener) {
        this.listeners.remove(deviceChangeListener);
    }

    public synchronized void fireDeviceChange(DeviceChangeEvent deviceChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DeviceChangeListener deviceChangeListener = (DeviceChangeListener)iterator.next();
            try {
                deviceChangeListener.deviceChanged(deviceChangeEvent);
            }
            catch (RuntimeException runtimeException) {
                SystemLog.log(runtimeException);
            }
        }
    }
}

