/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.ControlledItem;
import com.digi.config.core.VersionManager;
import com.digi.config.util.UUID;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

public abstract class ControlledItemImpl
implements ControlledItem {
    private static final long serialVersionUID = 5359817077571116226L;
    UUID id;
    long baseSortValue = Long.MAX_VALUE;
    long alternateSortValue = Long.MAX_VALUE;
    boolean active = false;
    UUID owningCtlrId = null;

    protected ControlledItemImpl() {
        this(null);
    }

    protected ControlledItemImpl(UUID uUID) {
        this.id = uUID == null ? new UUID() : uUID;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = VersionManager.getTargetVersion();
        objectOutputStream.writeInt(n);
        objectOutputStream.defaultWriteObject();
    }

    public UUID getId() {
        return this.id;
    }

    public long getBaseSortValue() {
        return this.baseSortValue;
    }

    public void setBaseSortValue(long l) {
        this.baseSortValue = l;
    }

    public void setAlternateSortValue(long l) {
        this.alternateSortValue = l;
    }

    public long getAlternateSortValue() {
        return this.alternateSortValue;
    }

    public void setActive(boolean bl) throws Exception {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public UUID getOwningCtlrId() {
        return this.owningCtlrId;
    }

    public void setOwningCtlrId(UUID uUID) {
        this.owningCtlrId = uUID;
    }

    public boolean equals(Object object) {
        if (object instanceof ControlledItem) {
            return this.getId().equals(((ControlledItem)object).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int compareTo(Object object) {
        int n = 0;
        ControlledItem controlledItem = (ControlledItem)object;
        if (controlledItem == null) {
            n = 1;
        } else {
            long l;
            long l2 = this.getBaseSortValue();
            int n2 = l2 < (l = controlledItem.getBaseSortValue()) ? -1 : (n = l2 > l ? 1 : 0);
            if (n == 0) {
                l2 = this.getAlternateSortValue();
                int n3 = l2 < (l = controlledItem.getAlternateSortValue()) ? -1 : (n = l2 > l ? 1 : 0);
            }
            if (n == 0) {
                UUID uUID = this.getId();
                UUID uUID2 = controlledItem.getId();
                n = ControlledItemImpl.nullSafeCompare(uUID, uUID2);
            }
        }
        return n;
    }

    public static int nullSafeCompare(Comparable comparable, Comparable comparable2) {
        int n = 0;
        if (comparable2 == null) {
            if (comparable != null) {
                n = 1;
            }
        } else {
            n = comparable == null ? -1 : comparable.compareTo(comparable2);
        }
        return n;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId().toString();
    }

    public void dump(PrintStream printStream, String string) {
        try {
            printStream.println();
            printStream.println(string + "********** Controlled Item *************");
            printStream.println(string + "ID = " + this.id.toString());
            printStream.println(string + "Class = " + this.getClass().getName());
            printStream.println(string + "Owning Ctlr ID = " + this.owningCtlrId);
            printStream.println(string + "toString() = " + this.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

