/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.InetAddress;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SerialTcpView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            SerialTcpView.this.refreshViewKvpNode();
            SerialTcpView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    GridContentPanel socketIdContent;
    GridContentPanel idleTimeoutContent;
    GridContentPanel tcpClientContent;
    KvpField tcpSocketIdEnabledKvpField;
    KvpField tcpSocketIdKvpField;
    KvpField tcpIdleTimeoutKvpField;
    KvpField tcpDropDCDEnabledKvpField;
    KvpField tcpDropDSREnabledKvpField;
    KvpField tcpAutoConnectEnabledKvpField;
    KvpField tcpConnectTriggerKvpField;
    KvpField tcpConnectDestinationKvpField;
    KvpField tcpConnectServiceKvpField;
    KvpField tcpConnectPortKvpField;
    JCheckBox tcpSocketIdEnabled_UIC;
    JTextField tcpSocketId_UIC;
    JCheckBox tcpIdleTimeoutEnabled_UIC;
    JTextField tcpIdleTimeout_UIC;
    JCheckBox tcpDropDCDEnabled_UIC;
    JCheckBox tcpDropDSREnabled_UIC;
    JCheckBox tcpAutoConnectEnabled_UIC;
    JComboBox tcpConnectTrigger_UIC;
    JTextField tcpConnectDestination_UIC;
    JComboBox tcpConnectService_UIC;
    JTextField tcpConnectPort_UIC;

    public SerialTcpView() throws Exception {
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == SerialTcpView.this.tcpSocketIdEnabled_UIC) {
                    SerialTcpView.this.tcpSocketIdEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialTcpView.this.tcpSocketIdEnabled_UIC.isSelected()));
                    SerialTcpView.this.socketIdContent.setContainerEnabled(SerialTcpView.this.tcpSocketIdEnabled_UIC.isSelected());
                } else if (object == SerialTcpView.this.tcpSocketId_UIC) {
                    SerialTcpView.this.tcpSocketIdKvpField.setStringValue(SerialTcpView.this.tcpSocketId_UIC.getText());
                } else if (object == SerialTcpView.this.tcpIdleTimeoutEnabled_UIC) {
                    SerialTcpView.this.tcpIdleTimeoutKvpField.setStringValue(SerialTcpView.this.tcpIdleTimeoutEnabled_UIC.isSelected() ? SerialTcpView.this.tcpIdleTimeout_UIC.getText() : "0");
                    SerialTcpView.this.idleTimeoutContent.setContainerEnabled(SerialTcpView.this.tcpIdleTimeoutEnabled_UIC.isSelected());
                } else if (object == SerialTcpView.this.tcpIdleTimeout_UIC) {
                    SerialTcpView.this.tcpIdleTimeoutKvpField.setStringValue(SerialTcpView.this.tcpIdleTimeout_UIC.getText());
                } else if (object == SerialTcpView.this.tcpDropDCDEnabled_UIC) {
                    SerialTcpView.this.tcpDropDCDEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialTcpView.this.tcpDropDCDEnabled_UIC.isSelected()));
                } else if (object == SerialTcpView.this.tcpDropDSREnabled_UIC) {
                    SerialTcpView.this.tcpDropDSREnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialTcpView.this.tcpDropDSREnabled_UIC.isSelected()));
                } else if (object == SerialTcpView.this.tcpAutoConnectEnabled_UIC) {
                    SerialTcpView.this.tcpAutoConnectEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialTcpView.this.tcpAutoConnectEnabled_UIC.isSelected()));
                    SerialTcpView.this.tcpClientContent.setContainerEnabled(SerialTcpView.this.tcpAutoConnectEnabled_UIC.isSelected());
                } else if (object == SerialTcpView.this.tcpConnectTrigger_UIC) {
                    SerialTcpView.this.tcpConnectTriggerKvpField.setStringValue(SerialTcpView.this.tcpConnectTrigger_UIC.getSelectedItem().toString());
                } else if (object == SerialTcpView.this.tcpConnectDestination_UIC) {
                    SerialTcpView.this.tcpConnectDestinationKvpField.setStringValue(SerialTcpView.this.tcpConnectDestination_UIC.getText());
                } else if (object == SerialTcpView.this.tcpConnectService_UIC) {
                    SerialTcpView.this.tcpConnectServiceKvpField.setStringValue(SerialTcpView.this.tcpConnectService_UIC.getSelectedItem().toString());
                } else if (object == SerialTcpView.this.tcpConnectPort_UIC) {
                    SerialTcpView.this.tcpConnectPortKvpField.setStringValue(SerialTcpView.this.tcpConnectPort_UIC.getText());
                }
            }
        };
        this.content.addHeadingBar("TcpSerialHeading");
        this.content.addTextLine("TcpSerialDesc");
        this.tcpSocketIdEnabled_UIC = this.content.addJCheckBox("TcpSocketIdEnabled", (ActionListener)controlChangeAdapter);
        this.socketIdContent = new GridContentPanel(1);
        this.tcpSocketId_UIC = this.socketIdContent.addJTextField("TcpSocketId", "TcpSocketIdDesc", 100, (FocusListener)controlChangeAdapter);
        this.content.addSubPanel((JComponent)this.socketIdContent);
        this.tcpIdleTimeoutEnabled_UIC = this.content.addJCheckBox("TcpIdleTimeoutEnabled", (ActionListener)controlChangeAdapter);
        this.idleTimeoutContent = new GridContentPanel(1);
        this.tcpIdleTimeout_UIC = this.idleTimeoutContent.addJTextField("TcpIdleTimeout", "TcpIdleTimeoutDesc", 100, (FocusListener)controlChangeAdapter);
        this.tcpIdleTimeout_UIC.setDocument(this.createIntegerDocument());
        this.content.addSubPanel((JComponent)this.idleTimeoutContent);
        this.tcpDropDCDEnabled_UIC = this.content.addJCheckBox("TcpDropOnDCDEnabled", (ActionListener)controlChangeAdapter);
        this.tcpDropDSREnabled_UIC = this.content.addJCheckBox("TcpDropOnDSREnabled", (ActionListener)controlChangeAdapter);
        this.content.addHeadingBar("TcpClientHeading");
        this.content.addTextLine("TcpClientDesc");
        this.tcpAutoConnectEnabled_UIC = this.content.addJCheckBox("TcpAutoConnectEnabled", (ActionListener)controlChangeAdapter);
        this.tcpClientContent = new GridContentPanel(1);
        String[] stringArray = new String[]{"always", "data", "dsr", "dcd"};
        this.tcpConnectTrigger_UIC = this.tcpClientContent.addJComboBox("TcpConnectTrigger", "TcpConnectTriggerDesc", stringArray, (ActionListener)controlChangeAdapter);
        this.tcpConnectDestination_UIC = this.tcpClientContent.addJTextField("TcpConnectDestination", "TcpConnectDestinationDesc", 100, (FocusListener)controlChangeAdapter);
        this.tcpConnectDestination_UIC.setDocument(this.createNetworkAddressDocument());
        String[] stringArray2 = new String[]{"raw", "telnet", "ssl"};
        this.tcpConnectService_UIC = this.tcpClientContent.addJComboBox("TcpConnectService", "TcpConnectServiceDesc", stringArray2, (ActionListener)controlChangeAdapter);
        this.tcpConnectPort_UIC = this.tcpClientContent.addJTextField("TcpConnectPort", "TcpConnectPortDesc", 100, (FocusListener)controlChangeAdapter);
        this.tcpConnectPort_UIC.setDocument(this.createIntegerDocument());
        this.content.addSubPanel((JComponent)this.tcpClientContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialTcpView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.tcpSocketIdEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "socketid_state");
        this.tcpSocketIdKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "socketid_string");
        this.tcpIdleTimeoutKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "idle_timeout");
        this.tcpDropDCDEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "hangup_dcd");
        this.tcpDropDSREnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "hangup_dsr");
        this.tcpAutoConnectEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "state");
        this.tcpConnectTriggerKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "trigger");
        this.tcpConnectDestinationKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "address");
        this.tcpConnectServiceKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "service");
        this.tcpConnectPortKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "autoconnect", "port");
    }

    private void refreshViewControls() {
        this.tcpSocketId_UIC.setEnabled(this.tcpSocketIdKvpField != null);
        if (this.tcpSocketIdKvpField != null) {
            this.tcpSocketId_UIC.setText(this.tcpSocketIdKvpField.getStringValue());
        }
        this.tcpSocketIdEnabled_UIC.setEnabled(this.tcpSocketIdEnabledKvpField != null);
        if (this.tcpSocketIdEnabledKvpField != null) {
            this.tcpSocketIdEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpSocketIdEnabledKvpField.getStringValue()));
            this.socketIdContent.setContainerEnabled(this.tcpSocketIdEnabled_UIC.isSelected());
        }
        this.tcpIdleTimeout_UIC.setEnabled(this.tcpIdleTimeoutKvpField != null);
        this.tcpIdleTimeoutEnabled_UIC.setEnabled(this.tcpIdleTimeoutKvpField != null);
        if (this.tcpIdleTimeoutKvpField != null) {
            if (Integer.parseInt(this.tcpIdleTimeoutKvpField.getStringValue()) <= 0) {
                this.tcpIdleTimeoutEnabled_UIC.setSelected(false);
                this.tcpIdleTimeout_UIC.setText("");
            } else {
                this.tcpIdleTimeoutEnabled_UIC.setSelected(true);
                this.tcpIdleTimeout_UIC.setText(this.tcpIdleTimeoutKvpField.getStringValue());
            }
            this.idleTimeoutContent.setContainerEnabled(this.tcpIdleTimeoutEnabled_UIC.isSelected());
        }
        this.tcpDropDCDEnabled_UIC.setEnabled(this.tcpDropDCDEnabledKvpField != null);
        if (this.tcpDropDCDEnabledKvpField != null) {
            this.tcpDropDCDEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpDropDCDEnabledKvpField.getStringValue()));
        }
        this.tcpDropDSREnabled_UIC.setEnabled(this.tcpDropDSREnabledKvpField != null);
        if (this.tcpDropDSREnabledKvpField != null) {
            this.tcpDropDSREnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpDropDSREnabledKvpField.getStringValue()));
        }
        this.tcpConnectTrigger_UIC.setEnabled(this.tcpConnectTriggerKvpField != null);
        if (this.tcpConnectTriggerKvpField != null) {
            this.tcpConnectTrigger_UIC.setSelectedItem(this.tcpConnectTriggerKvpField.getStringValue());
        }
        this.tcpConnectDestination_UIC.setEnabled(this.tcpConnectDestinationKvpField != null);
        if (this.tcpConnectDestinationKvpField != null) {
            this.tcpConnectDestination_UIC.setText(this.tcpConnectDestinationKvpField.getStringValue());
        }
        this.tcpConnectService_UIC.setEnabled(this.tcpConnectServiceKvpField != null);
        if (this.tcpConnectServiceKvpField != null) {
            this.tcpConnectService_UIC.setSelectedItem(this.tcpConnectServiceKvpField.getStringValue());
        }
        this.tcpConnectPort_UIC.setEnabled(this.tcpConnectPortKvpField != null);
        if (this.tcpConnectPortKvpField != null) {
            this.tcpConnectPort_UIC.setText(this.tcpConnectPortKvpField.getStringValue());
        }
        this.tcpAutoConnectEnabled_UIC.setEnabled(this.tcpAutoConnectEnabledKvpField != null);
        if (this.tcpAutoConnectEnabledKvpField != null) {
            this.tcpAutoConnectEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpAutoConnectEnabledKvpField.getStringValue()));
            this.tcpClientContent.setContainerEnabled(this.tcpAutoConnectEnabled_UIC.isSelected());
        }
        if (this.tcpAutoConnectEnabledKvpField == null) {
            this.content.setContainerEnabled(false);
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        try {
            if (this.tcpSocketIdEnabled_UIC.isSelected() && (this.tcpSocketId_UIC.getText().length() <= 0 || this.tcpSocketId_UIC.getText().length() > 40)) {
                collection.add(new ValidationError("SerialTcpSocketIdError"));
            }
            if (this.tcpIdleTimeoutEnabled_UIC.isSelected() && (!ValidationHelper.isValidUnsigned16((String)this.tcpIdleTimeout_UIC.getText()) || Integer.parseInt(this.tcpIdleTimeout_UIC.getText()) <= 0)) {
                collection.add(new ValidationError("SerialTcpIdleTimeoutError"));
            }
            if (this.tcpAutoConnectEnabled_UIC.isSelected()) {
                if (!ValidationHelper.isValidIPAddress((String)this.tcpConnectDestination_UIC.getText()) || InetAddress.getByName(this.tcpConnectDestination_UIC.getText()).equals(InetAddress.getByName("0.0.0.0"))) {
                    collection.add(new ValidationError("SerialTcpConnectDestinationError"));
                }
                if (!ValidationHelper.isValidNetworkPort((String)this.tcpConnectPort_UIC.getText()) || Integer.parseInt(this.tcpConnectPort_UIC.getText()) <= 0) {
                    collection.add(new ValidationError("SerialTcpConnectPortError"));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in SerialTcpView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

