/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SerialRealportView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            SerialRealportView.this.refreshViewKvpNode();
            SerialRealportView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    GridContentPanel serverContent;
    GridContentPanel secureServerContent;
    KvpField realportServerEnabledKvpField;
    KvpField realportServerPortKvpField;
    KvpField secureRealportServerEnabledKvpField;
    KvpField secureRealportServerPortKvpField;
    JCheckBox realportServerEnabled_UIC;
    JTextField realportServerPort_UIC;
    JCheckBox secureRealportServerEnabled_UIC;
    JTextField secureRealportServerPort_UIC;

    public SerialRealportView() throws Exception {
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == SerialRealportView.this.realportServerEnabled_UIC) {
                    SerialRealportView.this.realportServerEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialRealportView.this.realportServerEnabled_UIC.isSelected()));
                    SerialRealportView.this.serverContent.setContainerEnabled(SerialRealportView.this.realportServerEnabled_UIC.isSelected());
                } else if (object == SerialRealportView.this.realportServerPort_UIC) {
                    SerialRealportView.this.realportServerPortKvpField.setStringValue(SerialRealportView.this.realportServerPort_UIC.getText());
                } else if (object == SerialRealportView.this.secureRealportServerEnabled_UIC) {
                    SerialRealportView.this.secureRealportServerEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialRealportView.this.secureRealportServerEnabled_UIC.isSelected()));
                    SerialRealportView.this.secureServerContent.setContainerEnabled(SerialRealportView.this.secureRealportServerEnabled_UIC.isSelected());
                } else if (object == SerialRealportView.this.secureRealportServerPort_UIC) {
                    SerialRealportView.this.secureRealportServerPortKvpField.setStringValue(SerialRealportView.this.secureRealportServerPort_UIC.getText());
                }
            }
        };
        this.content.addHeadingBar("RealportServerHeading");
        this.realportServerEnabled_UIC = this.content.addJCheckBox("RealportServerEnabled", (ActionListener)controlChangeAdapter);
        this.serverContent = new GridContentPanel(1);
        this.serverContent.addTextLine("RealportServerDesc");
        this.realportServerPort_UIC = this.serverContent.addJTextField("RealportServerPort", "RealportServerPortDesc", 100, (FocusListener)controlChangeAdapter);
        this.realportServerPort_UIC.setDocument(this.createIntegerDocument());
        this.content.addSubPanel((JComponent)this.serverContent);
        this.secureRealportServerEnabled_UIC = this.content.addJCheckBox("SecureRealportServerEnabled", (ActionListener)controlChangeAdapter);
        this.secureServerContent = new GridContentPanel(1);
        this.secureServerContent.addTextLine("SecureRealportServerDesc");
        this.secureRealportServerPort_UIC = this.secureServerContent.addJTextField("SecureRealportServerPort", "SecureRealportServerPortDesc", 100, (FocusListener)controlChangeAdapter);
        this.secureRealportServerPort_UIC.setDocument(this.createIntegerDocument());
        this.content.addSubPanel((JComponent)this.secureServerContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialRealportView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.realportServerEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "realport", "state");
        this.realportServerPortKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "realport", "port");
        this.secureRealportServerEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "secure_realport", "state");
        this.secureRealportServerPortKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "secure_realport", "port");
    }

    private void refreshViewControls() {
        this.realportServerPort_UIC.setEnabled(this.realportServerPortKvpField != null);
        if (this.realportServerPortKvpField != null) {
            this.realportServerPort_UIC.setText(this.realportServerPortKvpField.getStringValue());
        }
        this.realportServerEnabled_UIC.setEnabled(this.realportServerEnabledKvpField != null);
        if (this.realportServerEnabledKvpField != null) {
            this.realportServerEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.realportServerEnabledKvpField.getStringValue()));
            this.serverContent.setContainerEnabled(this.realportServerEnabled_UIC.isSelected());
        }
        this.secureRealportServerPort_UIC.setEnabled(this.secureRealportServerPortKvpField != null);
        if (this.secureRealportServerPortKvpField != null) {
            this.secureRealportServerPort_UIC.setText(this.secureRealportServerPortKvpField.getStringValue());
        }
        this.secureRealportServerEnabled_UIC.setEnabled(this.secureRealportServerEnabledKvpField != null);
        if (this.secureRealportServerEnabledKvpField != null) {
            this.secureRealportServerEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.secureRealportServerEnabledKvpField.getStringValue()));
            this.secureServerContent.setContainerEnabled(this.secureRealportServerEnabled_UIC.isSelected());
        }
        if (this.realportServerEnabledKvpField == null) {
            this.content.setContainerEnabled(false);
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        if (this.realportServerEnabled_UIC.isSelected() && (!ValidationHelper.isValidNetworkPort((String)this.realportServerPort_UIC.getText()) || Integer.parseInt(this.realportServerPort_UIC.getText()) <= 0)) {
            collection.add(new ValidationError("RealportServerPortValidationError"));
        }
        if (this.secureRealportServerEnabled_UIC.isSelected() && (!ValidationHelper.isValidNetworkPort((String)this.secureRealportServerPort_UIC.getText()) || Integer.parseInt(this.secureRealportServerPort_UIC.getText()) <= 0)) {
            collection.add(new ValidationError("SecureRealportServerPortValidationError"));
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

