/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import javax.swing.JLabel;

public class NetworkStatisticsView
extends ConfigViewImpl {
    KvpNode viewStateTree;
    DeviceChangeListener stateChangeListener;
    GridContentPanel content;
    GridContentPanel ipContent;
    GridContentPanel tcpContent;
    GridContentPanel udpContent;
    GridContentPanel icmpContent;
    String[] ipFields = new String[]{"ipinreceives", "ipforwdatagrams", "ipforwarding", "ipoutnoroutes", "iproutingdiscards", "ipdefaultttl"};
    String[] tcpFields = new String[]{"tcpinsegs", "tcpoutsegs", "tcpactiveopens", "tcppassiveopens", "tcpinerrs", "tcpattemptfails", "tcpretranssegs", "tcpestabresets"};
    String[] udpFields = new String[]{"udpindatagrams", "udpoutdatagrams", "udpinerrors", "udpnoports"};
    String[] icmpFields = new String[]{"icmpinmsgs", "icmpinerrors", "icmpindestunreachs"};
    static final int NUM_FIELD_COLUMNS = 2;
    JLabel[] ipLabels;
    JLabel[] tcpLabels;
    JLabel[] udpLabels;
    JLabel[] icmpLabels;

    public NetworkStatisticsView() throws Exception {
        super(false);
        int n;
        this.setIncludeStateFields(true);
        this.setIncludeSettingsFields(false);
        this.viewStateTree = new KvpNode();
        this.stateChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                NetworkStatisticsView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 2);
        int n2 = 0;
        boolean bl = false;
        this.content.addHeadingBar("ipStatisticsHeading");
        this.ipLabels = new JLabel[this.ipFields.length];
        for (n = 0; n < this.ipFields.length; ++n) {
            n2 = n % 2;
            bl = n2 == 1;
            this.ipLabels[n] = this.content.addJLabel(this.ipFields[n] + "Lbl", null, 0, n2, bl);
        }
        this.content.addHeadingBar("tcpStatisticsHeading");
        this.tcpLabels = new JLabel[this.tcpFields.length];
        for (n = 0; n < this.tcpFields.length; ++n) {
            n2 = n % 2;
            bl = n2 == 1;
            this.tcpLabels[n] = this.content.addJLabel(this.tcpFields[n] + "Lbl", null, 0, n2, bl);
        }
        this.content.addHeadingBar("udpStatisticsHeading");
        this.udpLabels = new JLabel[this.udpFields.length];
        for (n = 0; n < this.udpFields.length; ++n) {
            n2 = n % 2;
            bl = n2 == 1;
            this.udpLabels[n] = this.content.addJLabel(this.udpFields[n] + "Lbl", null, 0, n2, bl);
        }
        this.content.addHeadingBar("icmpStatisticsHeading");
        this.icmpLabels = new JLabel[this.icmpFields.length];
        for (n = 0; n < this.icmpFields.length; ++n) {
            n2 = n % 2;
            bl = n2 == 1;
            this.icmpLabels[n] = this.content.addJLabel(this.icmpFields[n] + "Lbl", null, 0, n2, bl);
        }
        this.content.addVGlue();
    }

    public String getName() {
        return "NetworkStatisticsView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewControls();
    }

    private void refreshViewControls() {
        KvpNode kvpNode;
        int n;
        this.viewStateTree.clear();
        for (n = 0; n < this.ipFields.length; ++n) {
            kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "net_stats", this.ipFields[n]);
            this.refreshUIFromField(this.ipLabels[n], (KvpField)kvpNode);
        }
        for (n = 0; n < this.tcpFields.length; ++n) {
            kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "net_stats", this.tcpFields[n]);
            this.refreshUIFromField(this.tcpLabels[n], (KvpField)kvpNode);
        }
        for (n = 0; n < this.udpFields.length; ++n) {
            kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "net_stats", this.udpFields[n]);
            this.refreshUIFromField(this.udpLabels[n], (KvpField)kvpNode);
        }
        for (n = 0; n < this.icmpFields.length; ++n) {
            kvpNode = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "net_stats", this.icmpFields[n]);
            this.refreshUIFromField(this.icmpLabels[n], (KvpField)kvpNode);
        }
    }

    private void refreshUIFromField(JLabel jLabel, KvpField kvpField) {
        jLabel.setEnabled(kvpField != null);
        if (kvpField != null) {
            jLabel.setText(kvpField.getStringValue());
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
        this.device.addStateChangeListener(this.stateChangeListener);
        this.doRefreshAction();
    }

    public void deactivate() {
        this.device.removeStateChangeListener(this.stateChangeListener);
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

