/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class GpioStateView
extends ConfigViewImpl {
    KvpNode viewStateTree;
    DeviceChangeListener stateChangeListener;
    GridContentPanel content;
    KvpField pin1KvpField;
    KvpField pin2KvpField;
    KvpField pin3KvpField;
    KvpField pin4KvpField;
    KvpField pin5KvpField;
    JRadioButton pin1Asserted_UIC;
    JRadioButton pin1Unasserted_UIC;
    JRadioButton pin2Asserted_UIC;
    JRadioButton pin2Unasserted_UIC;
    JRadioButton pin3Asserted_UIC;
    JRadioButton pin3Unasserted_UIC;
    JRadioButton pin4Asserted_UIC;
    JRadioButton pin4Unasserted_UIC;
    JRadioButton pin5Asserted_UIC;
    JRadioButton pin5Unasserted_UIC;
    JButton setGpioPinsBtn;
    ConfigAction setGpioPinsAction;

    public GpioStateView() throws Exception {
        super(false);
        this.setIncludeStateFields(true);
        this.setIncludeSettingsFields(false);
        this.viewStateTree = new KvpNode();
        this.stateChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                GpioStateView.this.refreshViewKvpNode();
                GpioStateView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == GpioStateView.this.pin1Asserted_UIC || object == GpioStateView.this.pin1Unasserted_UIC) {
                    GpioStateView.this.pin1KvpField.setStringValue(RciProtocol.assertedString((boolean)GpioStateView.this.pin1Asserted_UIC.isSelected()));
                } else if (object == GpioStateView.this.pin2Asserted_UIC || object == GpioStateView.this.pin2Unasserted_UIC) {
                    GpioStateView.this.pin2KvpField.setStringValue(RciProtocol.assertedString((boolean)GpioStateView.this.pin2Asserted_UIC.isSelected()));
                } else if (object == GpioStateView.this.pin3Asserted_UIC || object == GpioStateView.this.pin3Unasserted_UIC) {
                    GpioStateView.this.pin3KvpField.setStringValue(RciProtocol.assertedString((boolean)GpioStateView.this.pin3Asserted_UIC.isSelected()));
                } else if (object == GpioStateView.this.pin4Asserted_UIC || object == GpioStateView.this.pin4Unasserted_UIC) {
                    GpioStateView.this.pin4KvpField.setStringValue(RciProtocol.assertedString((boolean)GpioStateView.this.pin4Asserted_UIC.isSelected()));
                } else if (object == GpioStateView.this.pin5Asserted_UIC || object == GpioStateView.this.pin5Unasserted_UIC) {
                    GpioStateView.this.pin5KvpField.setStringValue(RciProtocol.assertedString((boolean)GpioStateView.this.pin5Asserted_UIC.isSelected()));
                }
                GpioStateView.this.setGpioPinsBtn.setEnabled(GpioStateView.this.isChanged());
            }
        };
        this.setGpioPinsAction = new ConfigAction("SetGpioPins", this, "doSaveChangesAction");
        this.content.addTextLine("GpioStateViewDesc");
        GridContentPanel gridContentPanel = new GridContentPanel(3);
        gridContentPanel.addColumnHeading("", (ActionListener)controlChangeAdapter, 0, false);
        gridContentPanel.addColumnHeading("PinAssertedHeading", (ActionListener)controlChangeAdapter, 1, false);
        gridContentPanel.addColumnHeading("PinUnassertedHeading", (ActionListener)controlChangeAdapter, 2, true);
        ButtonGroup buttonGroup = new ButtonGroup();
        gridContentPanel.addColumnHeading("GpioPin1", (ActionListener)controlChangeAdapter, 0, false);
        this.pin1Asserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup, 1, false);
        this.pin1Unasserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup, 2, true);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        gridContentPanel.addColumnHeading("GpioPin2", (ActionListener)controlChangeAdapter, 0, false);
        this.pin2Asserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup2, 1, false);
        this.pin2Unasserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup2, 2, true);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        gridContentPanel.addColumnHeading("GpioPin3", (ActionListener)controlChangeAdapter, 0, false);
        this.pin3Asserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup3, 1, false);
        this.pin3Unasserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup3, 2, true);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        gridContentPanel.addColumnHeading("GpioPin4", (ActionListener)controlChangeAdapter, 0, false);
        this.pin4Asserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup4, 1, false);
        this.pin4Unasserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup4, 2, true);
        ButtonGroup buttonGroup5 = new ButtonGroup();
        gridContentPanel.addColumnHeading("GpioPin5", (ActionListener)controlChangeAdapter, 0, false);
        this.pin5Asserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup5, 1, false);
        this.pin5Unasserted_UIC = gridContentPanel.addJRadioButton(null, (ActionListener)controlChangeAdapter, buttonGroup5, 2, true);
        this.content.addSubPanel((JComponent)gridContentPanel);
        this.setGpioPinsBtn = new JButton(this.setGpioPinsAction);
        this.setGpioPinsBtn.setEnabled(false);
        this.content.addField(null, (Component)this.setGpioPinsBtn, null);
        this.content.addVGlue();
    }

    public String getName() {
        return "GpioStateView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }

    private void refreshViewKvpNode() {
        this.viewStateTree.clear();
        this.pin1KvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "gpio", "pin1");
        this.pin2KvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "gpio", "pin2");
        this.pin3KvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "gpio", "pin3");
        this.pin4KvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "gpio", "pin4");
        this.pin5KvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "gpio", "pin5");
    }

    private void refreshViewControls() {
        this.setPinState(this.pin1KvpField, this.pin1Asserted_UIC, "asserted");
        this.setPinState(this.pin1KvpField, this.pin1Unasserted_UIC, "unasserted");
        this.setPinState(this.pin2KvpField, this.pin2Asserted_UIC, "asserted");
        this.setPinState(this.pin2KvpField, this.pin2Unasserted_UIC, "unasserted");
        this.setPinState(this.pin3KvpField, this.pin3Asserted_UIC, "asserted");
        this.setPinState(this.pin3KvpField, this.pin3Unasserted_UIC, "unasserted");
        this.setPinState(this.pin4KvpField, this.pin4Asserted_UIC, "asserted");
        this.setPinState(this.pin4KvpField, this.pin4Unasserted_UIC, "unasserted");
        this.setPinState(this.pin5KvpField, this.pin5Asserted_UIC, "asserted");
        this.setPinState(this.pin5KvpField, this.pin5Unasserted_UIC, "unasserted");
        this.setGpioPinsBtn.setEnabled(this.isChanged());
    }

    private void setPinState(KvpField kvpField, JRadioButton jRadioButton, String string) {
        jRadioButton.setEnabled(kvpField != null);
        if (kvpField != null) {
            jRadioButton.setSelected(kvpField.getStringValue().equals(string));
            jRadioButton.setEnabled(this.device.getInternalSettingTree().getField("gpio_mode", kvpField.getName()).getStringValue().equals("out"));
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
        this.device.addStateChangeListener(this.stateChangeListener);
        this.device.addSettingChangeListener(this.stateChangeListener);
        this.doRefreshAction();
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
        this.device.removeStateChangeListener(this.stateChangeListener);
        this.device.removeSettingChangeListener(this.stateChangeListener);
    }

    public boolean isChanged() {
        return this.viewStateTree.hasChanged();
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode2.merge(this.viewStateTree, false);
    }

    public void commitChanges() {
        this.viewStateTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

