/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.exception.LocalizationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class LocalizableMessage
implements Serializable,
Cloneable {
    private String resourceKey;
    private MarshalledObject[] replacementText;
    private String rsrcBundleName;
    private Locale originalLocale;
    private transient String fallbackMessage;

    public LocalizableMessage(String string, String string2, Serializable[] serializableArray, Locale locale) {
        int n;
        if (string2 == null || string == null) {
            throw new NullPointerException("Message key or rsrcrBundleName is null");
        }
        if (string2.length() == 0 || string.length() == 0) {
            throw new IllegalArgumentException("Message key and rsrcBundleName must be provided");
        }
        if (serializableArray != null) {
            for (n = 0; n < serializableArray.length; ++n) {
                if (serializableArray[n] != null) continue;
                throw new NullPointerException("ReplacementText[" + n + "] == null");
            }
        }
        try {
            this.replacementText = new MarshalledObject[serializableArray != null ? serializableArray.length : 0];
            for (n = 0; n < this.replacementText.length; ++n) {
                this.replacementText[n] = new MarshalledObject<Serializable>(serializableArray[n]);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Marshalling ReplacementText failed. index: " + n + " Exception: " + iOException);
        }
        this.originalLocale = locale != null ? locale : Locale.getDefault();
        this.resourceKey = string2;
        this.rsrcBundleName = string;
        try {
            this.fallbackMessage = this.localize(string, string2, serializableArray, this.originalLocale);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer("Error: Message '" + this.resourceKey + "' was issued but it was not found in local resource bundle '" + this.rsrcBundleName + "'. ");
            if (serializableArray != null) {
                for (int i = 0; i < serializableArray.length; ++i) {
                    stringBuffer.append(": ");
                    try {
                        stringBuffer.append(serializableArray[i]);
                        continue;
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable2) {
                        stringBuffer.append("??");
                    }
                }
            }
            this.fallbackMessage = stringBuffer.toString();
        }
    }

    public String getLocalizedText(Locale locale) {
        Locale locale2 = locale != null ? locale : Locale.getDefault();
        String string = null;
        try {
            Serializable[] serializableArray = new Serializable[this.replacementText.length];
            for (int i = 0; i < serializableArray.length; ++i) {
                serializableArray[i] = (Serializable)this.replacementText[i].get();
            }
            string = this.localize(this.rsrcBundleName, this.resourceKey, serializableArray, locale2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string != null ? string : this.fallbackMessage;
    }

    public Locale getOriginalLocale() {
        return this.originalLocale;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public MarshalledObject[] getReplacementText() {
        return this.replacementText;
    }

    public String getResourceBundleName() {
        return this.rsrcBundleName;
    }

    public String getFallbackMessage() {
        return this.fallbackMessage;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + "Values: " + string);
        stringBuffer.append("\t originalLocale:   " + this.getOriginalLocale() + string);
        stringBuffer.append("\t key:              " + this.getResourceKey() + string);
        stringBuffer.append("\t resource bundle:  " + this.getResourceBundleName() + string);
        stringBuffer.append("\t fallback message: " + this.getFallbackMessage() + string);
        MarshalledObject[] marshalledObjectArray = this.getReplacementText();
        stringBuffer.append("\t Replacement Text " + string);
        if (marshalledObjectArray.length == 0) {
            stringBuffer.append("\t\t NONE" + string);
        } else {
            for (int i = 0; i < marshalledObjectArray.length; ++i) {
                try {
                    stringBuffer.append("\t\t replacement text[" + i + "]: " + marshalledObjectArray[i].get() + string);
                    continue;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    stringBuffer.append("\t\t replacement text[" + i + "]: ERROR RETRIEVING" + string);
                }
            }
        }
        stringBuffer.append("\t Localized Message: " + this.getLocalizedText(null));
        stringBuffer.append(string + string);
        return stringBuffer.toString();
    }

    protected String localize(String string, String string2, Serializable[] serializableArray, Locale locale) throws LocalizationException {
        Object object;
        Object object2 = null;
        try {
            object = ResourceBundle.getBundle(string, locale);
            if (object != null) {
                object2 = ((ResourceBundle)object).getObject(string2);
            }
        }
        catch (Throwable throwable) {
            throw new LocalizationException("Unable to localize text. ResourceBundle: " + string + " key: " + string2 + " locale: " + locale + "original Throwable: " + throwable, string, string2, true);
        }
        if (object2 == null) {
            throw new MissingResourceException("Resource not found", string, string2);
        }
        object = null;
        if (object2 instanceof String) {
            object = new MessageFormat((String)object2);
        } else if (object2 instanceof MessageFormat) {
            object = (MessageFormat)object2;
        } else {
            throw new LocalizationException("Resource retrieved from ResourceBundle is not a String or MessageFormat.  ResourceBundle: " + string + " key: " + string2 + " locale: " + locale + " resourceType: " + object2.getClass().getName(), string, string2, true);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ((MessageFormat)object).setLocale(locale);
        try {
            if (serializableArray != null) {
                for (int i = 0; i < serializableArray.length; ++i) {
                    if (!(serializableArray[i] instanceof LocalizableMessage)) continue;
                    LocalizableMessage localizableMessage = (LocalizableMessage)serializableArray[i];
                    serializableArray[i] = null;
                    serializableArray[i] = localizableMessage.getLocalizedText(locale);
                }
            }
            ((MessageFormat)object).format(serializableArray, stringBuffer, new FieldPosition(0));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new LocalizationException("Message Format failed ResourceBundle: " + string + " key: " + string2 + " locale: " + locale + "original Throwable: " + throwable, string, string2, true);
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.fallbackMessage);
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fallbackMessage = (String)objectInputStream.readObject();
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

