/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.ui.LoginPrompt;
import com.digi.config.ui.SplashScreenPanel;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class RciAuthenticator
extends Authenticator {
    private static RciAuthenticator self = new RciAuthenticator();
    private boolean credentialsHaveChanged = false;
    private String user = "";
    private String password = "";

    public static RciAuthenticator getInstance() {
        return self;
    }

    public void setNewCredentials(String string, String string2) {
        if (string != null) {
            this.user = string;
            this.credentialsHaveChanged = true;
        }
        if (string2 != null) {
            this.password = string2;
            this.credentialsHaveChanged = true;
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication = null;
        if (this.credentialsHaveChanged) {
            passwordAuthentication = new PasswordAuthentication(this.user, this.password.toCharArray());
            this.credentialsHaveChanged = false;
        } else {
            LoginPrompt loginPrompt = new LoginPrompt(null);
            if (this.user.length() > 0) {
                loginPrompt.setUserName(this.user);
            }
            loginPrompt.setHost(this.getRequestingHost());
            loginPrompt.setRealm(this.getRequestingPrompt());
            int n = loginPrompt.showLoginPrompt();
            if (n == 0) {
                this.user = loginPrompt.getUserName();
                this.password = loginPrompt.getPassword();
                passwordAuthentication = new PasswordAuthentication(this.user, this.password.toCharArray());
            }
        }
        return passwordAuthentication;
    }

    private RciAuthenticator() {
        SplashScreenPanel.currentScreen().updateProgress();
    }
}

