/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.Controller;
import com.digi.config.core.ControllerMembershipEvent;
import com.digi.config.core.ControllerMembershipListener;
import com.digi.config.util.SystemLog;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ControllerMembershipSupport {
    private Controller controller;
    private HashSet listeners;

    public ControllerMembershipSupport(Controller controller) {
        this.controller = controller;
        this.listeners = new HashSet();
    }

    public synchronized void addControllerMembershipListener(ControllerMembershipListener controllerMembershipListener) {
        this.listeners.add(controllerMembershipListener);
    }

    public synchronized void removeControllerMembershipListener(ControllerMembershipListener controllerMembershipListener) {
        this.listeners.remove(controllerMembershipListener);
    }

    public synchronized void fireItemsAdded(ControllerMembershipEvent controllerMembershipEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ControllerMembershipListener controllerMembershipListener = (ControllerMembershipListener)iterator.next();
            try {
                controllerMembershipListener.itemsAdded(controllerMembershipEvent);
            }
            catch (RuntimeException runtimeException) {
                SystemLog.log(runtimeException);
            }
        }
    }

    public synchronized void fireItemsAdded(Collection collection) {
        this.fireItemsAdded(new ControllerMembershipEvent(collection));
    }

    public synchronized void fireItemsAdded(Object object) {
        this.fireItemsAdded(new ControllerMembershipEvent(object));
    }

    public synchronized void fireItemsAdded(Object object, int n) {
        this.fireItemsAdded(new ControllerMembershipEvent(object, n));
    }

    public synchronized void fireItemsRemoved(ControllerMembershipEvent controllerMembershipEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ControllerMembershipListener controllerMembershipListener = (ControllerMembershipListener)iterator.next();
            try {
                controllerMembershipListener.itemsRemoved(controllerMembershipEvent);
            }
            catch (RuntimeException runtimeException) {
                SystemLog.log(runtimeException);
            }
        }
    }

    public synchronized void fireItemsRemoved(Collection collection) {
        this.fireItemsRemoved(new ControllerMembershipEvent(collection));
    }

    public synchronized void fireItemsRemoved(Object object) {
        this.fireItemsRemoved(new ControllerMembershipEvent(object));
    }

    public synchronized void fireItemsRemoved(Object object, int n) {
        this.fireItemsRemoved(new ControllerMembershipEvent(object, n));
    }

    public synchronized void fireItemsResorted() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ControllerMembershipListener controllerMembershipListener = (ControllerMembershipListener)iterator.next();
            try {
                controllerMembershipListener.itemsResorted(this.controller);
            }
            catch (RuntimeException runtimeException) {
                SystemLog.log(runtimeException);
            }
        }
    }
}

