/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.core.ControlledItem;
import com.digi.config.core.ControlledItemImpl;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;

public class SystemLogEntry
extends ControlledItemImpl
implements ControlledItem {
    public static final int MSG_LEVEL_DEBUG = 0;
    public static final int MSG_LEVEL_INFORMATION = 1;
    public static final int MSG_LEVEL_WARNING = 2;
    public static final int MSG_LEVEL_ERROR = 3;
    public static final int MSG_LEVEL_FATAL = 4;
    private static final long serialVersionUID = 4795284070894478266L;
    private String baseMsg;
    private String detailedMsg;
    private int severity;
    private String serviceID;
    private ExceptionInfo exceptionInfo;
    private Calendar creationTime;
    private String systemName;

    public SystemLogEntry(String string, Serializable[] serializableArray, Serializable[] serializableArray2, int n) throws MissingResourceException {
        this(string, serializableArray, serializableArray2, n, null);
    }

    public SystemLogEntry(String string, Serializable[] serializableArray, Serializable[] serializableArray2, int n, Throwable throwable) throws MissingResourceException {
        this.baseMsg = SystemLogEntry.getLocalizedMessage(string, serializableArray, null);
        try {
            n = Integer.parseInt(ConfigResource.getMsgRbStringForce(string + "_SEVERITY"));
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception exception) {
            SystemLog.log("InvalidResource", new Serializable[]{string + "_SEVERITY"});
        }
        this.severity = n;
        try {
            this.serviceID = ConfigResource.getMsgRbStringForce(string + "_ID");
        }
        catch (MissingResourceException missingResourceException) {
            this.serviceID = "";
        }
        try {
            if (ConfigResource.getMsgRbStringForce(string + "_DETAILS") != null) {
                this.detailedMsg = SystemLogEntry.getLocalizedMessage(string + "_DETAILS", serializableArray2, null);
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.detailedMsg = null;
        }
        if (throwable != null) {
            this.exceptionInfo = new ExceptionInfo(throwable);
        }
        this.creationTime = Calendar.getInstance();
        try {
            this.systemName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.systemName = "Unknown";
        }
    }

    private static String getLocalizedMessage(String string, Serializable[] serializableArray, Locale locale) {
        String string2 = ConfigResource.getMsgRbString(string);
        MessageFormat messageFormat = new MessageFormat(string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        messageFormat.setLocale(locale);
        messageFormat.format(serializableArray, stringBuffer, new FieldPosition(0));
        return stringBuffer.toString();
    }

    public String getMsg() {
        return this.baseMsg;
    }

    public String getDetailedMsg() {
        if (this.detailedMsg != null) {
            return this.detailedMsg;
        }
        return null;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean hasDetailedMsg() {
        return this.detailedMsg != null;
    }

    public String toString() {
        return "SystemLogEntry = " + this.getMsg() + "::" + this.getDetailedMsg();
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getServiceId() {
        return this.serviceID;
    }

    public class ExceptionInfo
    implements Serializable {
        public String name;
        public String message;
        public String callStack;

        public ExceptionInfo(Throwable throwable) {
            this.name = throwable.getClass().getName();
            this.message = throwable.getMessage();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            this.callStack = stringWriter.getBuffer().toString();
        }
    }
}

