/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.util.ConfigSettings;
import com.digi.config.util.SystemLogCtlrImpl;
import com.digi.config.util.SystemLogEntry;
import java.io.Serializable;

public class SystemLog {
    private static SystemLogCtlrImpl systemLogCtlr;
    static String defaultRBName;

    public static SystemLogEntry log(String string) {
        return SystemLog.log(string, (Serializable[])null);
    }

    public static SystemLogEntry log(String string, Throwable throwable) {
        return SystemLog.log(string, (Serializable[])null, throwable);
    }

    public static SystemLogEntry log(String string, Serializable[] serializableArray) {
        return SystemLog.log(string, serializableArray, serializableArray);
    }

    public static SystemLogEntry log(String string, Serializable[] serializableArray, Throwable throwable) {
        return SystemLog.log(string, serializableArray, serializableArray, throwable);
    }

    public static SystemLogEntry log(String string, Serializable[] serializableArray, Serializable[] serializableArray2) {
        return SystemLog.log(string, serializableArray, serializableArray2, 1);
    }

    public static SystemLogEntry log(String string, Serializable[] serializableArray, Serializable[] serializableArray2, Throwable throwable) {
        return SystemLog.log(string, serializableArray, serializableArray2, 3, throwable);
    }

    public static SystemLogEntry log(String string, Serializable[] serializableArray, Serializable[] serializableArray2, int n) {
        return SystemLog.log(string, defaultRBName, serializableArray, serializableArray2, n, null);
    }

    public static SystemLogEntry log(String string, Serializable[] serializableArray, Serializable[] serializableArray2, int n, Throwable throwable) {
        return SystemLog.log(string, defaultRBName, serializableArray, serializableArray2, n, throwable);
    }

    public static SystemLogEntry log(String string, String string2, Serializable[] serializableArray, Serializable[] serializableArray2, int n, Throwable throwable) {
        if (n == 0 && !SystemLog.getSystemLogCtlr().isDebugLoggingEnabled()) {
            return null;
        }
        SystemLogEntry systemLogEntry = new SystemLogEntry(string, serializableArray, serializableArray2, n, throwable);
        return SystemLog.log(systemLogEntry);
    }

    public static SystemLogEntry log(Throwable throwable) {
        return SystemLog.log("GeneralException", new Serializable[]{throwable.getClass().getName()}, throwable);
    }

    public static SystemLogEntry log(SystemLogEntry systemLogEntry) {
        try {
            SystemLog.getSystemLogCtlr().add(systemLogEntry);
        }
        catch (Exception exception) {
            System.out.println("Error sending a message to the System Log. Here is the message we were trying to log:");
            System.out.println(systemLogEntry.getMsg());
            if (systemLogEntry.hasDetailedMsg()) {
                System.out.println(systemLogEntry.getDetailedMsg());
            }
            System.out.println("Here are the details of the error that prevented us from logging the message:");
            exception.printStackTrace();
        }
        return systemLogEntry;
    }

    public static SystemLogEntry debug(String string) {
        Serializable[] serializableArray = new Serializable[]{"DEBUG[" + Thread.currentThread().getName() + "]: " + string};
        SystemLogEntry systemLogEntry = SystemLog.log("DebugMsg", serializableArray);
        if (ConfigSettings.getBoolean("DebugSettings", "GeneralDebug")) {
            System.out.println(serializableArray[0]);
        }
        return systemLogEntry;
    }

    public static SystemLogEntry debug(String string, Throwable throwable) {
        Serializable[] serializableArray = new Serializable[]{"DEBUG[" + Thread.currentThread().getName() + "]: " + string};
        SystemLogEntry systemLogEntry = SystemLog.log("DebugMsg", serializableArray, throwable);
        if (ConfigSettings.getBoolean("DebugSettings", "GeneralDebug")) {
            System.out.println(serializableArray[0]);
            if (throwable != null) {
                System.out.println("Detail Message:" + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        return systemLogEntry;
    }

    public static SystemLogCtlrImpl getSystemLogCtlr() {
        if (systemLogCtlr == null) {
            try {
                systemLogCtlr = new SystemLogCtlrImpl("ConfigLogFileName");
            }
            catch (Exception exception) {
                System.out.println("Error creating singleton instance of SystemLogCtlr");
                exception.printStackTrace();
            }
        }
        return systemLogCtlr;
    }

    public static SystemLogCtlrImpl getSystemLogCtlr(String string) {
        if (systemLogCtlr == null) {
            try {
                systemLogCtlr = new SystemLogCtlrImpl(string);
            }
            catch (Exception exception) {
                System.out.println("Error creating singleton instance of SystemLogCtlr");
                exception.printStackTrace();
            }
        }
        return systemLogCtlr;
    }

    static {
        defaultRBName = "com.digi.config.resources.ConfigResourceBundle";
    }
}

