/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.KvpNode;
import com.digi.config.core.RciAbstractCommand;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.util.SystemLog;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RciQuerySettingCommand
extends RciAbstractCommand {
    KvpNode selectionCriteria;

    public RciQuerySettingCommand(KvpNode kvpNode) {
        super("query_settings");
        SplashScreenPanel.currentScreen().updateProgress();
        this.selectionCriteria = kvpNode;
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        SplashScreenPanel.currentScreen().updateProgress();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<rci_request version=\"1.1\">\n");
        stringBuffer.append("  <query_setting>\n");
        this.selectionCriteria.toXml(stringBuffer, "    ", false);
        SplashScreenPanel.currentScreen().updateProgress();
        stringBuffer.append("  </query_setting>\n");
        stringBuffer.append("</rci_request>\n");
        SystemLog.debug("Writing command to URL:");
        SystemLog.debug(stringBuffer.toString());
        dataOutputStream.writeBytes(stringBuffer.toString());
    }

    public KvpNode getResults() throws Exception {
        if (this.resultDocument == null) {
            return null;
        }
        SplashScreenPanel.currentScreen().updateProgress();
        Node node = this.resultDocument.getFirstChild();
        String string = node.getNodeName();
        if (!string.equals("rci_reply")) {
            SystemLog.debug("Unexpected reply to RCI command. Reply string = " + string);
            throw new Exception("Unexpected RCI reply");
        }
        SystemLog.debug("Got rci_reply command");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            node = node2;
            string = node.getNodeName();
            break;
        }
        if (!string.equals("query_setting")) {
            SystemLog.debug("Unexpected reply to RCI query_settings command. Reply string = " + string);
            throw new Exception("Unexpected RCI query_settings reply");
        }
        SystemLog.debug("Got query_settings response");
        KvpNode kvpNode = new KvpNode(node);
        SplashScreenPanel.currentScreen().updateProgress();
        return kvpNode;
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\n");
        stringBuffer.append(string + "RCI query_settings command\n");
        stringBuffer.append(string + "  Selection Criteria:\n");
        this.selectionCriteria.dump(stringBuffer, string + "    ");
        stringBuffer.append(string + "  Result DOM Data: \n");
        RciQuerySettingCommand.dumpTree(this.resultDocument, stringBuffer, string + "    ");
        stringBuffer.append("\n");
    }
}

