/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.core;

import com.digi.config.core.ControlledItem;
import com.digi.config.core.ControlledItemComparator;
import com.digi.config.core.ControlledItemImpl;
import com.digi.config.core.Controller;
import com.digi.config.core.ControllerMembershipListener;
import com.digi.config.core.ControllerMembershipSupport;
import com.digi.config.core.VersionManager;
import com.digi.config.io.PersistanceObjectInputStream;
import com.digi.config.io.PersistanceObjectOutputStream;
import com.digi.config.util.PathLocater;
import com.digi.config.util.SystemLog;
import com.digi.config.util.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ControllerImpl
extends ControlledItemImpl
implements Controller {
    private static final long serialVersionUID = -5016223072897873237L;
    UUID id;
    private transient long nextElementCount = 0L;
    private transient ControlledItemComparator defaultComparator;
    protected transient Collection itemCollection;
    protected transient String persistanceFileName;
    protected transient Map itemMap;
    protected transient ControllerMembershipSupport membershipListener;
    protected transient boolean isActive;

    public ControllerImpl() {
        this(new ControlledItemComparator());
    }

    public ControllerImpl(ControlledItemComparator controlledItemComparator) {
        this.defaultComparator = controlledItemComparator;
        this.itemMap = new HashMap();
        this.itemCollection = new TreeSet(controlledItemComparator);
        this.membershipListener = new ControllerMembershipSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SystemLog.debug("Started reading in the contents of controller ");
        int n = objectInputStream.readInt();
        objectInputStream.defaultReadObject();
        this.nextElementCount = objectInputStream.readLong();
        this.defaultComparator = (ControlledItemComparator)objectInputStream.readObject();
        this.itemCollection = (Collection)objectInputStream.readObject();
        this.itemMap = new HashMap();
        Iterator iterator = this.itemCollection.iterator();
        while (iterator.hasNext()) {
            ControlledItem controlledItem = (ControlledItem)iterator.next();
            this.itemMap.put(controlledItem.getId(), controlledItem);
        }
        this.membershipListener = new ControllerMembershipSupport(this);
        SystemLog.debug("Finished reading in the contents of controller " + this.toString());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SystemLog.debug("Started writing out the contents of controller " + this.toString());
        int n = VersionManager.getTargetVersion();
        objectOutputStream.writeInt(n);
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.nextElementCount);
        objectOutputStream.writeObject(this.defaultComparator);
        objectOutputStream.writeObject(this.itemCollection);
    }

    public UUID getId() {
        return this.id;
    }

    public void setActive(boolean bl) throws Exception {
        super.setActive(bl);
        Iterator iterator = this.itemCollection.iterator();
        while (iterator.hasNext()) {
            try {
                ControlledItem controlledItem = (ControlledItem)iterator.next();
                controlledItem.setActive(bl);
            }
            catch (Exception exception) {
                SystemLog.log(exception);
            }
        }
    }

    public ControlledItemComparator getDefaultComparator() {
        return this.defaultComparator;
    }

    public void setDefaultComparator(ControlledItemComparator controlledItemComparator) {
        this.defaultComparator = controlledItemComparator;
        this.resort();
    }

    public void resort() {
        Collection collection = this.itemCollection;
        this.itemCollection = new TreeSet(this.defaultComparator);
        this.itemCollection.addAll(new ArrayList(collection));
        this.save();
        this.membershipListener.fireItemsResorted();
    }

    public synchronized void add(ControlledItem controlledItem) throws Exception {
        try {
            ControlledItem controlledItem2 = this.get(controlledItem.getId());
            if (controlledItem2 != null) {
                this.remove(controlledItem2);
            }
            controlledItem.setBaseSortValue(Calendar.getInstance().getTime().getTime());
            controlledItem.setAlternateSortValue(this.nextElementCount++);
            controlledItem.setOwningCtlrId(this.getId());
            this.itemCollection.add(controlledItem);
            this.itemMap.put(controlledItem.getId(), controlledItem);
            this.save();
            int n = this.getElements().indexOf(controlledItem);
            this.membershipListener.fireItemsAdded(controlledItem, n);
            controlledItem.setActive(this.isActive);
        }
        catch (Exception exception) {
            SystemLog.log(exception);
            throw exception;
        }
    }

    public synchronized void remove(ControlledItem controlledItem) throws Exception {
        int n = this.getElements().indexOf(controlledItem);
        controlledItem.setActive(false);
        this.itemCollection.remove(controlledItem);
        this.itemMap.remove(controlledItem.getId());
        controlledItem.setOwningCtlrId(null);
        this.save();
        this.membershipListener.fireItemsRemoved(controlledItem, n);
    }

    public synchronized void removeAll() throws Exception {
        Collection collection = this.itemMap.values();
        this.itemCollection.clear();
        this.itemMap.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ControlledItem controlledItem = (ControlledItem)iterator.next();
            controlledItem.setActive(false);
            controlledItem.setOwningCtlrId(null);
        }
        this.save();
        this.membershipListener.fireItemsRemoved(collection);
    }

    public synchronized ControlledItem get(Object object) {
        return (ControlledItem)this.itemMap.get(object);
    }

    public synchronized boolean contains(ControlledItem controlledItem) {
        return this.itemMap.containsKey(controlledItem.getId());
    }

    public synchronized Iterator getIterator() {
        return this.getElements().iterator();
    }

    public synchronized ControlledItem getElement(int n) {
        Object[] objectArray = this.itemCollection.toArray();
        if (n < 0 || n > objectArray.length) {
            return null;
        }
        return (ControlledItem)objectArray[n];
    }

    public synchronized List getElements() {
        return new ArrayList(this.itemCollection);
    }

    public synchronized List getElements(Comparator comparator) {
        List list = this.getElements();
        if (comparator != this.defaultComparator) {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public synchronized int getCount() {
        return this.itemCollection.size();
    }

    public synchronized int getCount(Class clazz) {
        int n = 0;
        Iterator iterator = this.itemCollection.iterator();
        while (iterator.hasNext()) {
            if (!clazz.isInstance(iterator.next())) continue;
            ++n;
        }
        return n;
    }

    public void setPersistanceFileName(String string) {
        this.persistanceFileName = string;
    }

    public void save() {
        if (this.persistanceFileName != null) {
            File file = new File(PathLocater.getDefaultSaveFileName(this.persistanceFileName));
            if (file.exists()) {
                file.delete();
            }
            try {
                PathLocater.createPathToFile(file);
                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.save(fileOutputStream);
            }
            catch (Exception exception) {
                SystemLog.log("CtlrSaveError", new Serializable[]{this.persistanceFileName}, exception);
            }
        }
    }

    public void save(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                PersistanceObjectOutputStream persistanceObjectOutputStream = new PersistanceObjectOutputStream(outputStream);
                persistanceObjectOutputStream.writeObject(this);
                persistanceObjectOutputStream.flush();
                persistanceObjectOutputStream.close();
            }
            catch (Exception exception) {
                SystemLog.log("CtlrSaveError", new Serializable[]{this.persistanceFileName}, exception);
            }
        }
    }

    public static Controller load(String string) {
        File file;
        if (string != null && (file = new File(PathLocater.getDefaultSaveFileName(string))).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                PersistanceObjectInputStream persistanceObjectInputStream = new PersistanceObjectInputStream(fileInputStream);
                ControllerImpl controllerImpl = (ControllerImpl)persistanceObjectInputStream.readObject();
                persistanceObjectInputStream.close();
                return controllerImpl;
            }
            catch (Exception exception) {
                SystemLog.log("CtlrLoadError", new Serializable[]{string}, exception);
                return null;
            }
        }
        return null;
    }

    public void addControllerMembershipListener(ControllerMembershipListener controllerMembershipListener) {
        this.membershipListener.addControllerMembershipListener(controllerMembershipListener);
    }

    public void removeControllerMembershipListener(ControllerMembershipListener controllerMembershipListener) {
        this.membershipListener.removeControllerMembershipListener(controllerMembershipListener);
    }

    public void dump(PrintStream printStream, String string) {
        super.dump(printStream, string);
        printStream.println(string + "Items controlled by this item are:");
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            ((ControlledItem)iterator.next()).dump(printStream, string + "   ");
        }
    }
}

