/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Date;

public final class UUID
implements Serializable,
Comparable {
    private static final SecureRandom secRand = new SecureRandom();
    private static final long serialVersionUID = -5279696515406579267L;
    private long mostSig = 0L;
    private long leastSig = 0L;

    public UUID() {
        this(new Date().getTime(), (int)secRand.nextLong());
    }

    public UUID(long l, int n) {
        byte[] byArray;
        this.mostSig = l;
        this.leastSig = this.leastSig & 0xFFFFFFFFL | (long)n << 32;
        try {
            byArray = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            byArray = new byte[4];
            secRand.nextBytes(byArray);
        }
        long l2 = 0L;
        for (int i = 0; i < 4; ++i) {
            l2 = byArray[i] >= 0 ? (l2 += (long)byArray[i]) : (l2 += 128L + (long)(byArray[i] & 0x7F));
            l2 <<= 8;
        }
        this.leastSig |= (l2 >>= 8);
    }

    public UUID(long l, long l2) {
        this.mostSig = l;
        this.leastSig = l2;
    }

    public UUID(String string) {
        int n = string.indexOf(95);
        this.mostSig = Long.parseLong(string.substring(0, n));
        this.leastSig = Long.parseLong(string.substring(n + 1));
    }

    public long getMostSignificantBits() {
        return this.mostSig;
    }

    public long getLeastSignificantBits() {
        return this.leastSig;
    }

    public void writeBytes(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.mostSig);
        dataOutput.writeLong(this.leastSig);
    }

    public int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UUID)) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.mostSig == uUID.mostSig && this.leastSig == uUID.leastSig;
    }

    public String toString() {
        return Long.toString(this.mostSig) + "_" + Long.toString(this.leastSig);
    }

    public int compareTo(Object object) {
        UUID uUID = (UUID)object;
        int n = 0;
        if (this.mostSig > uUID.mostSig) {
            n = 1;
        } else if (this.mostSig < uUID.mostSig) {
            n = -1;
        }
        if (n == 0) {
            if (this.leastSig > uUID.leastSig) {
                n = 1;
            } else if (this.leastSig < uUID.leastSig) {
                n = -1;
            }
        }
        return n;
    }
}

