/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.ui.GridContentPanel;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class HttpsTrustManager
implements X509TrustManager {
    KeyStore keyStore = null;
    X509TrustManager sunX509TrustManager = null;

    public HttpsTrustManager() {
        try {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(null, null);
            this.initSunX509TrustManager(this.keyStore);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.sunX509TrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.sunX509TrustManager.checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            try {
                if (this.promptUser(x509CertificateArray)) {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        this.keyStore.setCertificateEntry(((Object)x509CertificateArray[i].getIssuerDN()).toString(), x509CertificateArray[i]);
                    }
                } else {
                    throw new CertificateException("Server certificate not trusted by the user.");
                }
                this.initSunX509TrustManager(this.keyStore);
            }
            catch (Exception exception) {
                System.out.println("Exception checking with user if server trusted: " + exception);
                exception.printStackTrace();
                throw new CertificateException("Server certificate validation error.");
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.sunX509TrustManager.getAcceptedIssuers();
    }

    private boolean promptUser(X509Certificate[] x509CertificateArray) {
        JOptionPane jOptionPane = new JOptionPane();
        GridContentPanel gridContentPanel = new GridContentPanel(1);
        gridContentPanel.setOpaque(false);
        String string = ((Object)x509CertificateArray[0].getSubjectDN()).toString();
        String string2 = ((Object)x509CertificateArray[0].getIssuerDN()).toString();
        String string3 = "Do you want to accept the certificate from '" + string + "' to exchange encrypted information?";
        String string4 = "The certificate was issued by '" + string2 + "'.";
        int n = JOptionPane.showConfirmDialog(null, new Object[]{string3, new String(""), string4}, "Security Alert", 0);
        return n == 0;
    }

    private void initSunX509TrustManager(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(this.keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            this.sunX509TrustManager = (X509TrustManager)trustManagerArray[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

