/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.util.DefaultConfigSettings;
import com.digi.config.util.DefaultValueFinder;
import com.digi.config.util.ModifiedSettings;
import com.digi.config.util.PathLocater;
import com.digi.config.util.SystemLog;
import com.digi.config.util.Vector2;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigSettings
extends Observable {
    private String configFileName = System.getProperty("ConfigFileName", "config.ini");
    private static ConfigSettings theInstance = null;
    public static final String CATEGORY_SYSTEM = "System";
    public static final String CATEGORY_CFG = "General";
    private Hashtable ivSectionTable = new Hashtable();
    private Vector ivDefValFunction = new Vector();
    private ModifiedSettings ivModSettings = null;
    private String iniFileName = null;

    public static ConfigSettings getInstance() {
        if (theInstance == null) {
            theInstance = new ConfigSettings();
        }
        return theInstance;
    }

    private ConfigSettings() {
        try {
            this.load_profile();
        }
        catch (Exception exception) {
            System.out.println("Error loading configuration profile: ");
            exception.printStackTrace();
        }
        this.addDefaultValueFinderListener(new DefaultConfigSettings());
    }

    public void addDefaultValueFinderListener(DefaultValueFinder defaultValueFinder) {
        this.ivDefValFunction.addElement(defaultValueFinder);
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getProfileProperty(String string, String string2) {
        return this.getProfileProperty(string, string2, null, null);
    }

    public String getProfileProperty(String string, String string2, String string3, String string4) {
        Object object;
        String string5 = null;
        if (string.equals(CATEGORY_SYSTEM)) {
            string5 = System.getProperty(string2);
        } else {
            object = (Vector2)this.ivSectionTable.get(string);
            if (object != null) {
                string5 = (String)((Vector2)object).get(string2);
            }
        }
        if (string5 == null && string3 != null) {
            if (string3.equals(CATEGORY_SYSTEM)) {
                string5 = System.getProperty(string4);
            } else {
                object = (Vector2)this.ivSectionTable.get(string3);
                if (object != null) {
                    string5 = (String)((Vector2)object).get(string4);
                }
            }
        }
        if (string5 == null) {
            object = this.ivDefValFunction.elements();
            while (string5 == null && object.hasMoreElements()) {
                string5 = ((DefaultValueFinder)object.nextElement()).getDefaultValue(string, string2);
            }
        }
        if (string5 == null && string3 != null) {
            object = this.ivDefValFunction.elements();
            while (string5 == null && object.hasMoreElements()) {
                string5 = ((DefaultValueFinder)object.nextElement()).getDefaultValue(string3, string4);
            }
        }
        return string5;
    }

    public String getProfileProperty(String string, String string2, String string3) {
        String string4 = this.getProfileProperty(string, string2);
        return string4 != null ? string4 : string3;
    }

    public boolean getBooleanProfileProperty(String string, String string2) {
        return this.getBooleanProfileProperty(string, string2, null, null);
    }

    public boolean getBooleanProfileProperty(String string, String string2, String string3, String string4) {
        return Boolean.valueOf(this.getProfileProperty(string, string2, string3, string4));
    }

    public int getIntegerProfileProperty(String string, String string2) {
        return this.getIntegerProfileProperty(string, string2, null, null);
    }

    public int getIntegerProfileProperty(String string, String string2, String string3, String string4) {
        try {
            return Integer.parseInt(this.getProfileProperty(string, string2, string3, string4));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Color getColorProfileProperty(String string, String string2) {
        return this.getColorProfileProperty(string, string2, null, null);
    }

    public Color getColorProfileProperty(String string, String string2, String string3, String string4) {
        String string5 = this.getProfileProperty(string, string2, string3, string4);
        Color color = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 255;
        if (string5 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ", ", false);
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                }
                color = new Color(n, n2, n3, n4);
            }
            catch (Exception exception) {
                SystemLog.debug("Error loading color '" + string2 + "' from profile", exception);
            }
        }
        return color;
    }

    public Font getFontProfileProperty(String string, String string2) {
        return this.getFontProfileProperty(string, string2, null, null);
    }

    public Font getFontProfileProperty(String string, String string2, String string3, String string4) {
        String string5 = this.getProfileProperty(string, string2, string3, string4);
        Font font = null;
        int n = 16;
        int n2 = 0;
        if (string5 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ", ", false);
            try {
                String string6 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                }
                font = new Font(string6, n2, n);
            }
            catch (Exception exception) {
                SystemLog.debug("Error loading font '" + string2 + "' from profile", exception);
            }
        }
        return font;
    }

    public synchronized void setProfileProperty(String string, String string2, String string3) {
        if (string.equals(CATEGORY_SYSTEM)) {
            System.setProperty(string2, string3);
            return;
        }
        String string4 = this.getProfileProperty(string, string2);
        Object var5_5 = null;
        Vector2 vector2 = (Vector2)this.ivSectionTable.get(string);
        if (vector2 == null) {
            vector2 = new Vector2();
            this.ivSectionTable.put(string, vector2);
        } else {
            int n = vector2.keyIndexOf(string2);
            if (n != -1) {
                vector2.removeElementAt(n);
            }
        }
        vector2.put(string2, string3);
        if (string4 == null || !string4.equals(string3)) {
            Hashtable hashtable;
            Hashtable<String, String> hashtable2;
            if (this.ivModSettings == null) {
                this.ivModSettings = new ModifiedSettings();
            }
            if ((hashtable2 = (Hashtable<String, String>)(hashtable = this.ivModSettings.getSections()).get(string)) == null) {
                hashtable2 = new Hashtable<String, String>();
                hashtable.put(string, hashtable2);
            }
            hashtable2.put(string2, string3);
        }
    }

    public void setBooleanProfileProperty(String string, String string2, boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.setProfileProperty(string, string2, bl2.toString());
    }

    public void setColorProfileProperty(String string, String string2, Color color) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        this.setProfileProperty(string, string2, stringWriter.getBuffer().toString());
    }

    public void setIntegerProfileProperty(String string, String string2, int n) {
        Integer n2 = new Integer(n);
        this.setProfileProperty(string, string2, n2.toString());
    }

    public synchronized void save_profile() throws IOException {
        if (this.iniFileName == null) {
            this.iniFileName = PathLocater.getDefaultSaveFileName(this.configFileName);
        }
        PathLocater.createPathToFile(this.iniFileName);
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.iniFileName), true);
        this.list(printWriter);
        this.setChanged();
        if (this.ivModSettings != null) {
            this.notifyObservers(this.ivModSettings);
            this.ivModSettings.getSections().clear();
        }
    }

    public void list(PrintWriter printWriter) {
        Object object;
        String string;
        printWriter.println("// " + new Date());
        Vector2 vector2 = (Vector2)this.ivSectionTable.get("");
        if (vector2 != null) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                try {
                    string = (String)vector2.keyElementAt(i);
                    object = (String)vector2.valueElementAt(i);
                    printWriter.println(string + "=" + (String)object);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        Enumeration enumeration = this.ivSectionTable.keys();
        Enumeration enumeration2 = this.ivSectionTable.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equals("")) continue;
            printWriter.println("[" + string + "]");
            object = (Vector2)enumeration2.nextElement();
            int n = ((Vector2)object).size();
            for (int i = 0; i < n; ++i) {
                try {
                    String string2 = (String)((Vector2)object).keyElementAt(i);
                    String string3 = (String)((Vector2)object).valueElementAt(i);
                    printWriter.println("  " + string2 + "=" + string3);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized BufferedReader openProfile() {
        URL uRL;
        System.out.println("Locating profile: " + this.configFileName);
        Object var1_1 = null;
        try {
            System.out.println("Checking local filesystem: ");
            this.iniFileName = PathLocater.getDefaultSaveFileName(this.configFileName);
            System.out.println("   look for file " + this.iniFileName);
            return new BufferedReader(new FileReader(this.iniFileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (PathLocater.getDocumentBase() != null) {
                System.out.println("Checking device web filesystem: ");
                uRL = new URL(PathLocater.getDocumentBase(), this.configFileName);
                System.out.println("   look for file " + uRL);
                return new BufferedReader(new InputStreamReader(uRL.openStream()));
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            System.out.println("Checking jar filesystem: ");
            uRL = this.getClass().getResource(this.configFileName);
            System.out.println("   look for file " + uRL);
            if (uRL != null) {
                return new BufferedReader(new InputStreamReader(uRL.openStream()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("profile not found. Using defaults.");
        return null;
    }

    public synchronized void load_profile() throws IOException {
        String string;
        BufferedReader bufferedReader = this.openProfile();
        if (bufferedReader == null) {
            return;
        }
        String string2 = "";
        Vector2 vector2 = new Vector2();
        this.ivSectionTable.put(string2, vector2);
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            String string3;
            String string4;
            int n3;
            if ((string = string.trim()).length() == 0 || (n3 = string.indexOf("//")) != -1 && (n3 == 0 || string.length() == 2 || (string = string.substring(0, n3).trim()).length() == 0)) continue;
            int n4 = string.indexOf(61);
            int n5 = string.indexOf("$(", n4);
            while (n5 != -1) {
                int n6 = string.indexOf(41, n5);
                if (n6 != -1) {
                    String string5;
                    string4 = string.substring(n5 + 2, n6).trim();
                    string3 = "";
                    n2 = string4.indexOf(58);
                    if (n2 != -1) {
                        string3 = string4.substring(0, n2).trim();
                        string4 = string4.substring(n2 + 1).trim();
                    }
                    if ((string5 = this.getProfileProperty(string3, string4)) == null) {
                        string5 = "";
                    }
                    string = string.substring(0, n5) + string5 + string.substring(n6 + 1);
                } else {
                    n4 = n5 + 2;
                }
                n5 = string.indexOf("$(", n4);
            }
            if (string.charAt(0) == '[') {
                int n7 = string.indexOf(93);
                if (n7 == -1) {
                    return;
                }
                string2 = string.substring(1, n7).trim();
                vector2 = (Vector2)this.ivSectionTable.get("section_prefix");
                if (vector2 != null) continue;
                vector2 = new Vector2();
                this.ivSectionTable.put(string2, vector2);
                continue;
            }
            n2 = string.indexOf(61);
            if (n2 == -1) {
                string4 = string;
                string3 = "";
            } else {
                string4 = string.substring(0, n2).trim();
                string3 = string.substring(n2 + 1).trim();
            }
            int n8 = string3.length();
            if (n8 > 1 && string3.charAt(0) == '\"' && string3.charAt(n8 - 1) == '\"') {
                string3 = string3.substring(1, n8 - 1);
            }
            if ((n = vector2.keyIndexOf(string4)) != -1) {
                vector2.removeElementAt(n);
            }
            vector2.put(string4, string3);
        }
        bufferedReader.close();
    }

    public static boolean getBoolean(String string, String string2) {
        return ConfigSettings.getInstance().getBooleanProfileProperty(string, string2);
    }

    public static boolean getBoolean(String string, String string2, String string3, String string4) {
        return ConfigSettings.getInstance().getBooleanProfileProperty(string, string2, string3, string4);
    }

    public static void setBoolean(String string, String string2, boolean bl) {
        ConfigSettings.getInstance().setBooleanProfileProperty(string, string2, bl);
    }

    public static int getInteger(String string, String string2) {
        return ConfigSettings.getInstance().getIntegerProfileProperty(string, string2);
    }

    public static int getInteger(String string, String string2, String string3, String string4) {
        return ConfigSettings.getInstance().getIntegerProfileProperty(string, string2, string3, string4);
    }

    public static void setInteger(String string, String string2, int n) {
        ConfigSettings.getInstance().setIntegerProfileProperty(string, string2, n);
    }

    public static Font getFont(String string, String string2) {
        return ConfigSettings.getInstance().getFontProfileProperty(string, string2, null, null);
    }

    public static Font getFont(String string, String string2, String string3, String string4) {
        return ConfigSettings.getInstance().getFontProfileProperty(string, string2, string3, string4);
    }

    public static Color getColor(String string, String string2) {
        return ConfigSettings.getInstance().getColorProfileProperty(string, string2);
    }

    public static Color getColor(String string, String string2, String string3, String string4) {
        return ConfigSettings.getInstance().getColorProfileProperty(string, string2, string3, string4);
    }

    public static void setColor(String string, String string2, Color color) {
        ConfigSettings.getInstance().setColorProfileProperty(string, string2, color);
    }

    public static String getProperty(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Category and Key are MANDATORY parameters");
        }
        String string3 = ConfigSettings.getInstance().getProfileProperty(string, string2);
        if (string3 == null) {
            throw new MissingResourceException("Value not found for category: " + string + " and key: " + string2, string, string2);
        }
        return string3;
    }

    public static String getProperty(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Category and Key are MANDATORY parameters");
        }
        String string5 = ConfigSettings.getInstance().getProfileProperty(string, string2, string3, string4);
        if (string5 == null) {
            throw new MissingResourceException("Value not found for category: " + string + " and key: " + string2, string, string2);
        }
        return string5;
    }

    public static String getProperty(String string, String string2, String string3) {
        String string4 = null;
        try {
            string4 = ConfigSettings.getProperty(string, string2);
        }
        catch (MissingResourceException missingResourceException) {
            string4 = string3;
        }
        return string4;
    }

    public static void setProperty(String string, String string2, String string3) {
        if (string.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("Category and Key are MANDATORY parameters and must not be empty Strings");
        }
        ConfigSettings.getInstance().setProfileProperty(string, string2, string3);
    }

    public static void save() throws IOException {
        ConfigSettings.getInstance().save_profile();
    }
}

