/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.util;

import com.digi.config.util.SystemLog;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ConfigResource {
    static ConfigResource theInstance = null;
    public static final String DFT_MSG_TEXT_BUNDLE_NAME = "com.digi.config.resources.CommonResourceBundle";
    public static final String DFT_UI_TEXT_BUNDLE_NAME = "com.digi.config.resources.CommonUiResourceBundle";
    public static final String DFT_UI_IMAGE_BUNDLE_NAME = "com.digi.config.resources.CommonImgResourceBundle";
    public static final String DFT_HELP_TEXT_BUNDLE_NAME = "com.digi.config.resources.CommonHelpResourceBundle";
    private static String imagesDirectory = "/com/digi/config/images/";
    Vector msgTextRbList = new Vector();
    Vector uiTextRbList = new Vector();
    Vector uiImageRbList = new Vector();
    Vector helpTextRbList = new Vector();
    private static Map imageMap = new HashMap();
    static /* synthetic */ Class class$com$digi$config$util$ConfigResource;

    public static ConfigResource getInstance() {
        if (theInstance == null) {
            theInstance = new ConfigResource();
        }
        return theInstance;
    }

    public static void setImagesDirectory(String string) {
        imagesDirectory = string;
    }

    protected ConfigResource() {
        this._loadMsgTextRb(DFT_MSG_TEXT_BUNDLE_NAME);
        this._loadUiTextRb(DFT_UI_TEXT_BUNDLE_NAME);
        this._loadUiImageRb(DFT_UI_IMAGE_BUNDLE_NAME);
        this._loadHelpTextRb(DFT_HELP_TEXT_BUNDLE_NAME);
    }

    public void _loadMsgTextRb(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.msgTextRbList.add(0, resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            SystemLog.log("MissingBundle", new Serializable[]{string}, new Serializable[]{missingResourceException});
        }
    }

    public void _loadUiTextRb(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.uiTextRbList.add(0, resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            SystemLog.log("MissingBundle", new Serializable[]{string}, new Serializable[]{missingResourceException});
        }
    }

    public void _loadUiImageRb(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.uiImageRbList.add(0, resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            SystemLog.log("MissingBundle", new Serializable[]{string}, new Serializable[]{missingResourceException});
        }
    }

    public void _loadHelpTextRb(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.helpTextRbList.add(0, resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            SystemLog.log("MissingBundle", new Serializable[]{string}, new Serializable[]{missingResourceException});
        }
    }

    public static void loadMsgTextRb(String string) {
        ConfigResource.getInstance()._loadMsgTextRb(string);
    }

    public static void loadUiTextRb(String string) {
        ConfigResource.getInstance()._loadUiTextRb(string);
    }

    public static void loadUiImageRb(String string) {
        ConfigResource.getInstance()._loadUiImageRb(string);
    }

    public static void loadHelpTextRb(String string) {
        ConfigResource.getInstance()._loadHelpTextRb(string);
    }

    public static String getMsgRbString(String string) {
        try {
            return ConfigResource.getMsgRbStringForce(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getMsgRbStringForce(String string) throws MissingResourceException {
        MissingResourceException missingResourceException = null;
        String string2 = null;
        Iterator iterator = ConfigResource.getInstance().msgTextRbList.iterator();
        while (string2 == null && iterator.hasNext()) {
            ResourceBundle resourceBundle = (ResourceBundle)iterator.next();
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                missingResourceException = missingResourceException2;
            }
        }
        if (string2 == null && missingResourceException != null) {
            throw missingResourceException;
        }
        return string2;
    }

    public static String getMsgRbString(String string, Object[] objectArray) {
        String string2 = ConfigResource.getMsgRbString(string);
        if (!string2.equals(string)) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public static String getUiRbString(String string) {
        String string2 = null;
        Iterator iterator = ConfigResource.getInstance().uiTextRbList.iterator();
        while (string2 == null && iterator.hasNext()) {
            ResourceBundle resourceBundle = (ResourceBundle)iterator.next();
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String getUiRbString(String string, Object[] objectArray) {
        String string2 = ConfigResource.getUiRbString(string);
        if (!string2.equals(string)) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public static ImageIcon getImageRbIcon(String string) {
        ImageIcon imageIcon = null;
        imageIcon = (ImageIcon)imageMap.get(string);
        if (imageIcon == null) {
            Object object;
            String string2 = null;
            Object object2 = ConfigResource.getInstance().uiImageRbList.iterator();
            while (string2 == null && object2.hasNext()) {
                object = (ResourceBundle)object2.next();
                try {
                    string2 = ((ResourceBundle)object).getString(string);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            if (string2 == null) {
                string2 = string;
            }
            if (((String)(object2 = string2)).indexOf(File.separatorChar) == -1) {
                object2 = imagesDirectory + (String)object2;
            }
            try {
                object = (class$com$digi$config$util$ConfigResource == null ? (class$com$digi$config$util$ConfigResource = ConfigResource.class$("com.digi.config.util.ConfigResource")) : class$com$digi$config$util$ConfigResource).getResource((String)object2);
                if (object != null) {
                    imageIcon = new ImageIcon((URL)object);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (imageIcon != null) {
                imageMap.put(string, imageIcon);
            }
        }
        if (imageIcon == null) {
            // empty if block
        }
        return imageIcon;
    }

    public static String getHelpRbString(String string) {
        String string2 = null;
        Iterator iterator = ConfigResource.getInstance().helpTextRbList.iterator();
        while (string2 == null && iterator.hasNext()) {
            ResourceBundle resourceBundle = (ResourceBundle)iterator.next();
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

