/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.util.ConfigResource;
import com.digi.config.util.ConfigSettings;
import com.digi.config.util.SystemLog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class CustomPanel
extends JPanel {
    String customizeKey;
    ImageIcon backgroundIcon = null;
    Image backgroundImage = null;
    boolean tileImage = true;
    boolean stretchImage = false;
    boolean opaque = true;
    static Color dftBackgroundColor = new Color(255, 255, 255, 0);
    static Color dftForegroundColor = new Color(0, 0, 0, 255);
    Color backgroundColor = dftBackgroundColor;
    Color foregroundColor = dftForegroundColor;
    private ResourceBundle bundle = null;
    private boolean inPaint = false;

    public CustomPanel() {
        this("Default");
    }

    public CustomPanel(String string) {
        this.customizeKey = string;
        try {
            String string2 = ConfigSettings.getProperty("WindowSettings", string + "PanelBackgroundImage", "WindowSettings", "DefaultPanelBackgroundImage");
            if (string2 != null) {
                this.backgroundIcon = ConfigResource.getImageRbIcon(string2);
                this.backgroundImage = this.backgroundIcon.getImage();
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception exception) {
            SystemLog.debug("Unable to load background image for panel " + string, exception);
        }
        this.tileImage = ConfigSettings.getBoolean("WindowSettings", string + "PanelTileBackground", "WindowSettings", "DefaultPanelTileBackground");
        this.stretchImage = ConfigSettings.getBoolean("WindowSettings", string + "PanelStretchBackground", "WindowSettings", "DefaultPanelStretchBackground");
        this.opaque = ConfigSettings.getBoolean("WindowSettings", string + "PanelOpaque", "WindowSettings", "DefaultPanelOpaque");
        this.setOpaque(this.opaque);
        this.backgroundColor = ConfigSettings.getColor("WindowSettings", string + "PanelBackgroundColor", "WindowSettings", "DefaultPanelBackgroundColor");
        this.setBackground(this.backgroundColor);
        this.foregroundColor = ConfigSettings.getColor("WindowSettings", string + "PanelForegroundColor", "WindowSettings", "DefaultPanelForegroundColor");
        this.setForeground(this.foregroundColor);
        try {
            int n = ConfigSettings.getInteger("WindowSettings", string + "PanelWidth");
            int n2 = ConfigSettings.getInteger("WindowSettings", string + "PanelHeight");
            this.setSize(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        if (!this.inPaint && color.getAlpha() < 255) {
            return false;
        }
        return super.isOpaque();
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpaque()) {
            graphics.clearRect(0, 0, n, n2);
        }
        if (this.backgroundImage != null) {
            int n3 = this.backgroundIcon.getIconWidth();
            int n4 = this.backgroundIcon.getIconHeight();
            if (this.tileImage) {
                for (int i = 0; i < n; i += n3) {
                    for (int j = 0; j < n2; j += n4) {
                        graphics.drawImage(this.backgroundImage, i, j, this);
                    }
                }
            } else if (this.stretchImage) {
                graphics.drawImage(this.backgroundImage, 0, 0, n, n2, this);
            } else {
                int n5 = 1;
                try {
                    n5 = ConfigSettings.getInteger("WindowSettings", this.customizeKey + "PanelBackgroundImagePos");
                }
                catch (Exception exception) {
                    try {
                        n5 = ConfigSettings.getInteger("WindowSettings", "DefaultPanelBackgroundImagePos");
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                int n6 = 0;
                int n7 = 0;
                switch (n5) {
                    default: {
                        n6 = 0;
                        n7 = 0;
                        break;
                    }
                    case 2: {
                        n6 = n / 2 - n3 / 2;
                        n7 = 0;
                        break;
                    }
                    case 3: {
                        n6 = n - n3;
                        n7 = 0;
                        break;
                    }
                    case 4: {
                        n6 = 0;
                        n7 = n2 / 2 - n4 / 2;
                        break;
                    }
                    case 5: {
                        n6 = n / 2 - n3 / 2;
                        n7 = n2 / 2;
                        break;
                    }
                    case 6: {
                        n6 = n - n3;
                        n7 = n2 / 2 - n4 / 2;
                        break;
                    }
                    case 7: {
                        n6 = 0;
                        n7 = n2 - n4;
                        break;
                    }
                    case 8: {
                        n6 = n / 2 - n3 / 2;
                        n7 = n2 - n4;
                        break;
                    }
                    case 9: {
                        n6 = n - n3;
                        n7 = n2 / 2 - n4 / 2;
                    }
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                graphics.drawImage(this.backgroundImage, n6, n7, n3, n4, this);
            }
        }
        this.inPaint = true;
        super.paint(graphics);
        this.inPaint = false;
    }
}

