/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SerialNetworkServicesView
extends ConfigViewImpl {
    KvpNode viewSettingTree;
    DeviceChangeListener settingChangeListener;
    GridContentPanel content;
    String[] serviceName = new String[]{"tcp", "ssl", "udp", "rp", "srp", "telnet", "lpd"};
    String[] serviceSettingName = new String[]{"tcp_server", "securesocket", "udp_server", "realport", "secure_realport", "telnet_server", "lpd"};
    KvpField[] serverEnabledKvpField = new KvpField[this.serviceName.length];
    KvpField[] serverPortKvpField = new KvpField[this.serviceName.length];
    JCheckBox[] serverEnabled_UIC = new JCheckBox[this.serviceName.length];
    JTextField[] serverPort_UIC = new JTextField[this.serviceName.length];

    public SerialNetworkServicesView() throws Exception {
        this.viewSettingTree = new KvpNode();
        this.settingChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                SerialNetworkServicesView.this.refreshViewKvpNode();
                SerialNetworkServicesView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                for (int i = 0; i < SerialNetworkServicesView.this.serviceName.length; ++i) {
                    if (object == SerialNetworkServicesView.this.serverEnabled_UIC[i]) {
                        SerialNetworkServicesView.this.serverEnabledKvpField[i].setStringValue(RciProtocol.toString((boolean)SerialNetworkServicesView.this.serverEnabled_UIC[i].isSelected()));
                        continue;
                    }
                    if (object != SerialNetworkServicesView.this.serverPort_UIC[i]) continue;
                    SerialNetworkServicesView.this.serverPortKvpField[i].setStringValue(SerialNetworkServicesView.this.serverPort_UIC[i].getText());
                }
            }
        };
        this.content.addHeadingBar("SerialNetworkServicesHeading");
        this.content.addTextLine("SerialNetworkServicesDesc");
        GridContentPanel gridContentPanel = new GridContentPanel(2);
        for (int i = 0; i < this.serviceName.length; ++i) {
            this.serverEnabled_UIC[i] = gridContentPanel.addJCheckBox(this.serviceName[i] + "ServerEnabled", (ActionListener)controlChangeAdapter, 1, false);
            this.serverPort_UIC[i] = gridContentPanel.addJTextField(this.serviceName[i] + "ServerPort", this.serviceName[i] + "ServerPortDesc", 100, (FocusListener)controlChangeAdapter, 2, true);
            this.serverPort_UIC[i].setDocument(this.createIntegerDocument());
        }
        this.content.addSubPanel((JComponent)gridContentPanel);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialNetworkServicesView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        for (int i = 0; i < this.serviceName.length; ++i) {
            this.serverEnabledKvpField[i] = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), this.serviceSettingName[i], "state");
            this.serverPortKvpField[i] = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), this.serviceSettingName[i], "port");
        }
    }

    private void refreshViewControls() {
        for (int i = 0; i < this.serviceName.length; ++i) {
            this.serverPort_UIC[i].setEnabled(this.serverPortKvpField[i] != null);
            if (this.serverPortKvpField[i] != null) {
                this.serverPort_UIC[i].setText(this.serverPortKvpField[i].getStringValue());
            }
            this.serverEnabled_UIC[i].setEnabled(this.serverEnabledKvpField[i] != null);
            if (this.serverEnabledKvpField[i] == null) continue;
            this.serverEnabled_UIC[i].setSelected(RciProtocol.booleanValue((String)this.serverEnabledKvpField[i].getStringValue()));
        }
        if (this.serverEnabledKvpField[0] == null) {
            this.content.setContainerEnabled(false);
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        try {
            for (int i = 0; i < this.serviceName.length; ++i) {
                if (!this.serverEnabled_UIC[i].isSelected() || ValidationHelper.isValidNetworkPort((String)this.serverPort_UIC[i].getText()) && Integer.parseInt(this.serverPort_UIC[i].getText()) > 0) continue;
                collection.add(new ValidationError("Serial" + this.serviceName[i] + "ServerPortError"));
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in SerialNetworkServicesView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

