/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JComboBox;

public class NetworkAdvancedView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            NetworkAdvancedView.this.refreshViewKvpNode();
            NetworkAdvancedView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    KvpField ethernetSpeedKvpField;
    KvpField ethernetModeKvpField;
    KvpField parityKvpField;
    KvpField stopbitsKvpField;
    KvpField flowcontrolKvpField;
    JComboBox ethernetSpeed_UIC;
    JComboBox ethernetMode_UIC;

    public NetworkAdvancedView() throws Exception {
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == NetworkAdvancedView.this.ethernetSpeed_UIC) {
                    NetworkAdvancedView.this.ethernetSpeedKvpField.setStringValue(NetworkAdvancedView.this.ethernetSpeed_UIC.getSelectedItem().toString());
                } else if (object == NetworkAdvancedView.this.ethernetMode_UIC) {
                    NetworkAdvancedView.this.ethernetModeKvpField.setStringValue(NetworkAdvancedView.this.ethernetMode_UIC.getSelectedItem().toString());
                }
            }
        };
        String[] stringArray = new String[]{"auto", "10", "100"};
        this.ethernetSpeed_UIC = this.content.addJComboBox("EthernetSpeed", "EthernetSpeedDesc", stringArray, (ActionListener)controlChangeAdapter);
        String[] stringArray2 = new String[]{"auto", "full", "half"};
        this.ethernetMode_UIC = this.content.addJComboBox("EthernetMode", "EthernetModeDesc", stringArray2, (ActionListener)controlChangeAdapter);
        this.content.addVGlue();
    }

    public String getName() {
        return "NetworkAdvancedView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.ethernetSpeedKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "eth_speed");
        this.ethernetModeKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "eth_duplex");
    }

    private void refreshViewControls() {
        this.ethernetSpeed_UIC.setEnabled(this.ethernetSpeedKvpField != null);
        if (this.ethernetSpeedKvpField != null) {
            this.ethernetSpeed_UIC.setSelectedItem(this.ethernetSpeedKvpField.getStringValue());
        }
        this.ethernetMode_UIC.setEnabled(this.ethernetModeKvpField != null);
        if (this.ethernetModeKvpField != null) {
            this.ethernetMode_UIC.setSelectedItem(this.ethernetModeKvpField.getStringValue());
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

