/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.HelpDisplay;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JLabel;

public class HomeView
extends ConfigViewImpl {
    KvpNode viewSettingTree;
    KvpNode viewStateTree;
    DeviceChangeListener settingChangeListener;
    GridContentPanel content;
    KvpField modelKvpField;
    KvpField ipKvpField;
    KvpField hostNameKvpField;
    KvpField macAddressKvpField;
    JLabel model_UIC;
    JLabel ip_UIC;
    JLabel hostName_UIC;
    JLabel macAddress_UIC;

    public HomeView() throws Exception {
        this.setIncludeStateFields(true);
        this.viewSettingTree = new KvpNode();
        this.viewStateTree = new KvpNode();
        this.settingChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                HomeView.this.refreshViewKvpNode();
                HomeView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        this.content.addHeadingBar("GettingStarted");
        this.content.addAction(null, (Action)new ConfigAction("Tutorial", this, "doTutorialAction"), "TutorialDesc");
        this.content.addHeadingBar("SystemSummary");
        this.model_UIC = this.content.addJLabel("Model", "ModelDesc", 200);
        this.model_UIC.setText(ConfigResource.getUiRbString((String)"ProductName"));
        this.ip_UIC = this.content.addJLabel("Home.IPAddress", "Home.IPAddressDesc", 200);
        this.macAddress_UIC = this.content.addJLabel("MACAddress", "MACAddressDesc", 200);
        this.content.addVGlue();
    }

    public void doTutorialAction() {
        SystemLog.debug((String)"Launching Tutorial!");
        HelpDisplay.showHelp((String)"Tutorial");
    }

    public String getName() {
        return "HomeView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public Component getViewButtons() {
        return null;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        try {
            device.refreshStateTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
        device.addStateChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.modelKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "boot", "model");
        this.hostNameKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "network", "hostName");
        this.viewStateTree.clear();
        this.ipKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "boot_stats", "ip");
        this.macAddressKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "device_info", "mac");
    }

    private void refreshViewControls() {
        this.ip_UIC.setEnabled(this.ipKvpField != null);
        if (this.ipKvpField != null) {
            this.ip_UIC.setText(this.ipKvpField.getStringValue());
        }
        this.macAddress_UIC.setEnabled(this.macAddressKvpField != null);
        if (this.macAddressKvpField != null) {
            this.macAddress_UIC.setText(this.macAddressKvpField.getStringValue());
        }
    }

    public void activate() {
        SystemLog.debug((String)"Activating HomeView");
    }

    public void deactivate() {
        SystemLog.debug((String)"Deactivating HomeView");
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

