/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JComboBox;

public class GpioView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            GpioView.this.refreshViewKvpNode();
            GpioView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    KvpField pin1KvpField;
    KvpField pin2KvpField;
    KvpField pin3KvpField;
    KvpField pin4KvpField;
    KvpField pin5KvpField;
    JComboBox pin1_UIC;
    JComboBox pin2_UIC;
    JComboBox pin3_UIC;
    JComboBox pin4_UIC;
    JComboBox pin5_UIC;

    public GpioView() throws Exception {
        super(true);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == GpioView.this.pin1_UIC) {
                    GpioView.this.pin1KvpField.setStringValue(GpioView.this.pin1_UIC.getSelectedItem().toString());
                } else if (object == GpioView.this.pin2_UIC) {
                    GpioView.this.pin2KvpField.setStringValue(GpioView.this.pin2_UIC.getSelectedItem().toString());
                } else if (object == GpioView.this.pin3_UIC) {
                    GpioView.this.pin3KvpField.setStringValue(GpioView.this.pin3_UIC.getSelectedItem().toString());
                } else if (object == GpioView.this.pin4_UIC) {
                    GpioView.this.pin4KvpField.setStringValue(GpioView.this.pin4_UIC.getSelectedItem().toString());
                } else if (object == GpioView.this.pin5_UIC) {
                    GpioView.this.pin5KvpField.setStringValue(GpioView.this.pin5_UIC.getSelectedItem().toString());
                }
            }
        };
        this.content.addTextLine("GpioViewDesc");
        String[] stringArray = new String[]{"in", "out", "serial"};
        this.pin1_UIC = this.content.addJComboBox("GpioPin1", "GpioPin1Desc", stringArray, (ActionListener)controlChangeAdapter);
        this.pin2_UIC = this.content.addJComboBox("GpioPin2", "GpioPin1Desc", stringArray, (ActionListener)controlChangeAdapter);
        this.pin3_UIC = this.content.addJComboBox("GpioPin3", "GpioPin1Desc", stringArray, (ActionListener)controlChangeAdapter);
        this.pin4_UIC = this.content.addJComboBox("GpioPin4", "GpioPin1Desc", stringArray, (ActionListener)controlChangeAdapter);
        this.pin5_UIC = this.content.addJComboBox("GpioPin5", "GpioPin1Desc", stringArray, (ActionListener)controlChangeAdapter);
        this.content.addVGlue();
    }

    public String getName() {
        return "GpioView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        KvpNode kvpNode = this.viewSettingTree.mergeChild(this.device.getInternalSettingTree().getChild("gpio_mode"), true);
        if (kvpNode != null) {
            this.pin1KvpField = kvpNode.getChild("pin1");
            this.pin2KvpField = kvpNode.getChild("pin2");
            this.pin3KvpField = kvpNode.getChild("pin3");
            this.pin4KvpField = kvpNode.getChild("pin4");
            this.pin5KvpField = kvpNode.getChild("pin5");
        }
    }

    private void refreshViewControls() {
        this.pin1_UIC.setEnabled(this.pin1KvpField != null);
        if (this.pin1KvpField != null) {
            this.pin1_UIC.setSelectedItem(this.pin1KvpField.getStringValue());
        }
        this.pin2_UIC.setEnabled(this.pin2KvpField != null);
        if (this.pin2KvpField != null) {
            this.pin2_UIC.setSelectedItem(this.pin2KvpField.getStringValue());
        }
        this.pin3_UIC.setEnabled(this.pin3KvpField != null);
        if (this.pin3KvpField != null) {
            this.pin3_UIC.setSelectedItem(this.pin3KvpField.getStringValue());
        }
        this.pin4_UIC.setEnabled(this.pin4KvpField != null);
        if (this.pin4KvpField != null) {
            this.pin4_UIC.setSelectedItem(this.pin4KvpField.getStringValue());
        }
        this.pin5_UIC.setEnabled(this.pin5KvpField != null);
        if (this.pin5KvpField != null) {
            this.pin5_UIC.setSelectedItem(this.pin5KvpField.getStringValue());
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

