/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.BitMaskPanel;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class AlarmGpioView
extends ConfigViewImpl {
    KvpNode viewSettingTree;
    DeviceChangeListener settingChangeListener;
    GridContentPanel content;
    GridContentPanel alarmContent;
    GridContentPanel smtpContent;
    GridContentPanel listContent;
    GridContentPanel detailContent;
    int MAXALARMS = 10;
    KvpField alarmsEnabledKvpField;
    KvpField alarmSmtpServerKvpField;
    KvpField alarmSmtpFromKvpField;
    KvpField[] alarmEnabledKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmToKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmCcKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmSubjectKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmPriorityKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmTriggerModeKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmPatternKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmMonitorMaskKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmStateMaskKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmTriggerIntervalTimeKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmSendReminderEnabledKvpField = new KvpField[this.MAXALARMS];
    KvpField[] alarmReminderIntervalTimeKvpField = new KvpField[this.MAXALARMS];
    JCheckBox alarmsEnabled_UIC;
    JTextField alarmSmtpServer_UIC;
    JTextField alarmSmtpFrom_UIC;
    JCheckBox[] alarmEnabled_UIC = new JCheckBox[this.MAXALARMS];
    JTextField[] alarmTo_UIC = new JTextField[this.MAXALARMS];
    JTextField[] alarmCc_UIC = new JTextField[this.MAXALARMS];
    JTextField[] alarmSubject_UIC = new JTextField[this.MAXALARMS];
    JComboBox[] alarmPriority_UIC = new JComboBox[this.MAXALARMS];
    JComboBox[] alarmTriggerMode_UIC = new JComboBox[this.MAXALARMS];
    JTextField[] alarmPattern_UIC = new JTextField[this.MAXALARMS];
    BitMaskPanel[] alarmTrigger_UIC = new BitMaskPanel[this.MAXALARMS];
    JTextField[] alarmTriggerIntervalTime_UIC = new JTextField[this.MAXALARMS];
    JCheckBox[] alarmSendRemindersEnabled_UIC = new JCheckBox[this.MAXALARMS];
    JTextField[] alarmReminderIntervalTime_UIC = new JTextField[this.MAXALARMS];
    JTextField[] alarmMonitorMask_UIC = new JTextField[this.MAXALARMS];
    JTextField[] alarmStateMask_UIC = new JTextField[this.MAXALARMS];
    int[] gpioPinMask = new int[]{1, 2, 4, 32, 64};

    public AlarmGpioView() throws Exception {
        super(true);
        this.viewSettingTree = new KvpNode();
        this.settingChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                SystemLog.debug((String)"AlarmGpioView was notified that device kvpGroup changed");
                AlarmGpioView.this.refreshViewKvpNode();
                AlarmGpioView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                block33: {
                    block34: {
                        if (object != AlarmGpioView.this.alarmsEnabled_UIC) break block34;
                        AlarmGpioView.this.alarmsEnabledKvpField.setStringValue(RciProtocol.toString((boolean)AlarmGpioView.this.alarmsEnabled_UIC.isSelected()));
                        AlarmGpioView.this.alarmContent.setContainerEnabled(AlarmGpioView.this.alarmsEnabled_UIC.isSelected());
                        if (!AlarmGpioView.this.alarmsEnabled_UIC.isSelected()) break block33;
                        for (int i = 0; i < AlarmGpioView.this.MAXALARMS; ++i) {
                            boolean bl = true;
                            String string = AlarmGpioView.this.alarmTriggerMode_UIC[i].getSelectedItem().toString();
                            if (string.equalsIgnoreCase("gpio")) {
                                bl = true;
                            } else if (string.equalsIgnoreCase("pattern_match")) {
                                bl = false;
                            }
                            AlarmGpioView.this.alarmPattern_UIC[i].setEnabled(!bl);
                            AlarmGpioView.this.alarmTrigger_UIC[i].setEnabled(bl);
                            AlarmGpioView.this.alarmTriggerIntervalTime_UIC[i].setEnabled(bl);
                            AlarmGpioView.this.alarmSendRemindersEnabled_UIC[i].setEnabled(bl);
                            AlarmGpioView.this.alarmReminderIntervalTime_UIC[i].setEnabled(bl);
                        }
                        break block33;
                    }
                    if (object == AlarmGpioView.this.alarmSmtpServer_UIC) {
                        AlarmGpioView.this.alarmSmtpServerKvpField.setStringValue(AlarmGpioView.this.alarmSmtpServer_UIC.getText());
                    } else if (object == AlarmGpioView.this.alarmSmtpFrom_UIC) {
                        AlarmGpioView.this.alarmSmtpFromKvpField.setStringValue(AlarmGpioView.this.alarmSmtpFrom_UIC.getText());
                    } else {
                        for (int i = 0; i < AlarmGpioView.this.MAXALARMS; ++i) {
                            if (object == AlarmGpioView.this.alarmEnabled_UIC[i]) {
                                AlarmGpioView.this.alarmEnabledKvpField[i].setStringValue(RciProtocol.toString((boolean)AlarmGpioView.this.alarmEnabled_UIC[i].isSelected()));
                            } else if (object == AlarmGpioView.this.alarmTo_UIC[i]) {
                                AlarmGpioView.this.alarmToKvpField[i].setStringValue(AlarmGpioView.this.alarmTo_UIC[i].getText());
                            } else if (object == AlarmGpioView.this.alarmCc_UIC[i]) {
                                AlarmGpioView.this.alarmCcKvpField[i].setStringValue(AlarmGpioView.this.alarmCc_UIC[i].getText());
                            } else if (object == AlarmGpioView.this.alarmSubject_UIC[i]) {
                                AlarmGpioView.this.alarmSubjectKvpField[i].setStringValue(AlarmGpioView.this.alarmSubject_UIC[i].getText());
                            } else if (object == AlarmGpioView.this.alarmPriority_UIC[i]) {
                                AlarmGpioView.this.alarmPriorityKvpField[i].setStringValue(AlarmGpioView.this.alarmPriority_UIC[i].getSelectedItem().toString());
                            } else if (object == AlarmGpioView.this.alarmTriggerMode_UIC[i]) {
                                AlarmGpioView.this.alarmTriggerModeKvpField[i].setStringValue(AlarmGpioView.this.alarmTriggerMode_UIC[i].getSelectedItem().toString());
                                boolean bl = true;
                                String string = AlarmGpioView.this.alarmTriggerMode_UIC[i].getSelectedItem().toString();
                                if (string.equalsIgnoreCase("gpio")) {
                                    bl = true;
                                } else if (string.equalsIgnoreCase("pattern_match")) {
                                    bl = false;
                                }
                                AlarmGpioView.this.alarmPattern_UIC[i].setEnabled(!bl);
                                AlarmGpioView.this.alarmTrigger_UIC[i].setEnabled(bl);
                                AlarmGpioView.this.alarmTriggerIntervalTime_UIC[i].setEnabled(bl);
                                AlarmGpioView.this.alarmSendRemindersEnabled_UIC[i].setEnabled(bl);
                                AlarmGpioView.this.alarmReminderIntervalTime_UIC[i].setEnabled(bl);
                            } else if (object == AlarmGpioView.this.alarmPattern_UIC[i]) {
                                AlarmGpioView.this.alarmPatternKvpField[i].setStringValue(AlarmGpioView.this.alarmPattern_UIC[i].getText());
                            } else if (object == AlarmGpioView.this.alarmTrigger_UIC[i]) {
                                int[] nArray = AlarmGpioView.this.alarmTrigger_UIC[i].getBits();
                                SystemLog.debug((String)("Trigger changed to " + nArray));
                                for (int j = 0; j < nArray.length; ++j) {
                                    SystemLog.debug((String)("pin[" + j + "] = " + nArray[j]));
                                }
                                AlarmGpioView.this.alarmMonitorMaskKvpField[i].setStringValue(AlarmGpioView.this.computeMonitorMask(nArray));
                                AlarmGpioView.this.alarmStateMaskKvpField[i].setStringValue(AlarmGpioView.this.computeStateMask(nArray));
                            } else if (object == AlarmGpioView.this.alarmTriggerIntervalTime_UIC[i]) {
                                AlarmGpioView.this.alarmTriggerIntervalTimeKvpField[i].setStringValue(AlarmGpioView.this.alarmTriggerIntervalTime_UIC[i].getText());
                            } else if (object == AlarmGpioView.this.alarmSendRemindersEnabled_UIC[i]) {
                                AlarmGpioView.this.alarmSendReminderEnabledKvpField[i].setStringValue(RciProtocol.toString((boolean)AlarmGpioView.this.alarmSendRemindersEnabled_UIC[i].isSelected()));
                            } else {
                                if (object != AlarmGpioView.this.alarmReminderIntervalTime_UIC[i]) continue;
                                AlarmGpioView.this.alarmReminderIntervalTimeKvpField[i].setStringValue(AlarmGpioView.this.alarmReminderIntervalTime_UIC[i].getText());
                            }
                            break;
                        }
                    }
                }
            }
        };
        int[] nArray = new int[5];
        this.alarmsEnabled_UIC = this.content.addJCheckBox("AlarmsEnabled", (ActionListener)controlChangeAdapter);
        this.alarmContent = new GridContentPanel(1);
        this.alarmContent.addTextLine("AlarmDesc");
        this.alarmContent.addBlankLine();
        this.alarmContent.addTextLine("SmtpSettings");
        this.smtpContent = new GridContentPanel(1);
        this.smtpContent.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.alarmSmtpServer_UIC = this.smtpContent.addJTextField("AlarmSmtpServer", "AlarmSmtpServerDesc", 150, (FocusListener)controlChangeAdapter);
        this.alarmSmtpServer_UIC.setDocument(this.createNetworkAddressDocument());
        this.alarmSmtpFrom_UIC = this.smtpContent.addJTextField("AlarmSmtpFrom", "AlarmSmtpFromDesc", 150, (FocusListener)controlChangeAdapter);
        this.alarmSmtpFrom_UIC.setDocument(this.createEmailDocument());
        this.alarmContent.addSubPanel((JComponent)this.smtpContent);
        this.alarmContent.addBlankLine();
        this.alarmContent.addTextLine("AlarmListDesc");
        this.detailContent = new GridContentPanel(2);
        this.detailContent.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        for (int i = 0; i < this.MAXALARMS; ++i) {
            this.detailContent.addHeadingBar("Alarm #" + (i + 1));
            this.alarmEnabled_UIC[i] = this.detailContent.addJCheckBox("AlarmEnabled", (ActionListener)controlChangeAdapter, 0, true);
            this.alarmTo_UIC[i] = this.detailContent.addJTextField("AlarmTo", "AlarmToDesc", 150, (FocusListener)controlChangeAdapter, 0, false);
            this.alarmTo_UIC[i].setDocument(this.createEmailDocument());
            this.alarmCc_UIC[i] = this.detailContent.addJTextField("AlarmCc", "AlarmCcDesc", 150, (FocusListener)controlChangeAdapter, 1, true);
            this.alarmCc_UIC[i].setDocument(this.createEmailDocument());
            this.alarmSubject_UIC[i] = this.detailContent.addJTextField("AlarmSubject", "AlarmSubjectDesc", 150, (FocusListener)controlChangeAdapter, 0, false);
            this.alarmSubject_UIC[i].setDocument(this.createGeneralDocument());
            String[] stringArray = new String[]{"normal", "high"};
            this.alarmPriority_UIC[i] = this.detailContent.addJComboBox("AlarmPriority", "AlarmPriorityDesc", stringArray, (ActionListener)controlChangeAdapter, 1, true);
            String[] stringArray2 = new String[]{"gpio", "pattern_match"};
            this.alarmTriggerMode_UIC[i] = this.detailContent.addJComboBox("AlarmTriggerMode", "AlarmTriggerModeDesc", stringArray2, (ActionListener)controlChangeAdapter, 0, false);
            this.alarmPattern_UIC[i] = this.detailContent.addJTextField("AlarmPattern", "AlarmPatternDesc", 150, (FocusListener)controlChangeAdapter, 1, true);
            this.alarmPattern_UIC[i].setEnabled(false);
            this.alarmTrigger_UIC[i] = new BitMaskPanel("Gpio");
            this.alarmTrigger_UIC[i].addActionListener(controlChangeAdapter);
            this.detailContent.addField("AlarmTrigger", (Component)this.alarmTrigger_UIC[i], "AlarmTriggerDesc", 0, false);
            this.alarmTriggerIntervalTime_UIC[i] = this.detailContent.addJTextField("AlarmTriggerIntervalTime", "AlarmTriggerIntervalTimeDesc", 150, (FocusListener)controlChangeAdapter, 1, true);
            this.alarmTriggerIntervalTime_UIC[i].setDocument(this.createIntegerDocument());
            this.alarmSendRemindersEnabled_UIC[i] = this.detailContent.addJCheckBox("AlarmSendRemindersEnabled", (ActionListener)controlChangeAdapter, 0, false);
            this.alarmReminderIntervalTime_UIC[i] = this.detailContent.addJTextField("AlarmReminderIntervalTime", "AlarmReminderIntervalTimeDesc", 150, (FocusListener)controlChangeAdapter, 1, true);
            this.alarmReminderIntervalTime_UIC[i].setDocument(this.createIntegerDocument());
        }
        JScrollPane jScrollPane = new JScrollPane((Component)this.detailContent);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getViewport().setScrollMode(0);
        this.alarmContent.addSubPanel((JComponent)jScrollPane);
        this.content.addSubPanel((JComponent)this.alarmContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "AlarmGpioView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        KvpNode kvpNode = this.viewSettingTree.mergeChild(this.device.getInternalSettingTree().getChild("gpio_alarm"), true);
        if (kvpNode != null) {
            this.alarmsEnabledKvpField = kvpNode.getChild("state");
            this.alarmSmtpServerKvpField = kvpNode.getChild("smtp_server");
            this.alarmSmtpFromKvpField = kvpNode.getChild("from");
            for (int i = 0; i < this.MAXALARMS; ++i) {
                KvpNode kvpNode2 = kvpNode.getChild("alarm", i + 1);
                this.alarmEnabledKvpField[i] = kvpNode2.getChild("state");
                this.alarmToKvpField[i] = kvpNode2.getChild("to");
                this.alarmCcKvpField[i] = kvpNode2.getChild("cc");
                this.alarmSubjectKvpField[i] = kvpNode2.getChild("subject");
                this.alarmPriorityKvpField[i] = kvpNode2.getChild("priority");
                this.alarmTriggerModeKvpField[i] = kvpNode2.getChild("trigger_mode");
                this.alarmPatternKvpField[i] = kvpNode2.getChild("match_string");
                this.alarmMonitorMaskKvpField[i] = kvpNode2.getChild("monitor_mask");
                this.alarmStateMaskKvpField[i] = kvpNode2.getChild("state_mask");
                this.alarmTriggerIntervalTimeKvpField[i] = kvpNode2.getChild("alarm_throttle");
                this.alarmSendReminderEnabledKvpField[i] = kvpNode2.getChild("trigger_on_state");
                this.alarmReminderIntervalTimeKvpField[i] = kvpNode2.getChild("alarm_interval");
            }
        }
    }

    private void refreshViewControls() {
        this.content.setContainerEnabled(true);
        this.alarmSmtpServer_UIC.setEnabled(this.alarmSmtpServerKvpField != null);
        if (this.alarmSmtpServerKvpField != null) {
            this.alarmSmtpServer_UIC.setText(this.alarmSmtpServerKvpField.getStringValue());
        }
        this.alarmSmtpFrom_UIC.setEnabled(this.alarmSmtpFromKvpField != null);
        if (this.alarmSmtpFromKvpField != null) {
            this.alarmSmtpFrom_UIC.setText(this.alarmSmtpFromKvpField.getStringValue());
        }
        for (int i = 0; i < this.MAXALARMS; ++i) {
            this.alarmEnabled_UIC[i].setEnabled(this.alarmEnabledKvpField[i] != null);
            if (this.alarmEnabledKvpField[i] != null) {
                this.alarmEnabled_UIC[i].setSelected(RciProtocol.booleanValue((String)this.alarmEnabledKvpField[i].getStringValue()));
            }
            this.alarmTo_UIC[i].setEnabled(this.alarmToKvpField[i] != null);
            if (this.alarmToKvpField[i] != null) {
                this.alarmTo_UIC[i].setText(this.alarmToKvpField[i].getStringValue());
            }
            this.alarmCc_UIC[i].setEnabled(this.alarmCcKvpField[i] != null);
            if (this.alarmCcKvpField[i] != null) {
                this.alarmCc_UIC[i].setText(this.alarmCcKvpField[i].getStringValue());
            }
            this.alarmSubject_UIC[i].setEnabled(this.alarmSubjectKvpField[i] != null);
            if (this.alarmSubjectKvpField[i] != null) {
                this.alarmSubject_UIC[i].setText(this.alarmSubjectKvpField[i].getStringValue());
            }
            this.alarmPriority_UIC[i].setEnabled(this.alarmPriorityKvpField[i] != null);
            if (this.alarmPriorityKvpField[i] != null) {
                this.alarmPriority_UIC[i].setSelectedItem(this.alarmPriorityKvpField[i].getStringValue());
            }
            this.alarmTriggerMode_UIC[i].setEnabled(this.alarmTriggerModeKvpField[i] != null);
            if (this.alarmTriggerModeKvpField[i] != null) {
                this.alarmTriggerMode_UIC[i].setSelectedItem(this.alarmTriggerModeKvpField[i].getStringValue());
            }
            this.alarmPattern_UIC[i].setEnabled(this.alarmPatternKvpField[i] != null);
            if (this.alarmPatternKvpField[i] != null) {
                this.alarmPattern_UIC[i].setText(this.alarmPatternKvpField[i].getStringValue());
            }
            this.alarmTrigger_UIC[i].setEnabled(this.alarmMonitorMaskKvpField[i] != null && this.alarmStateMaskKvpField[i] != null);
            if (this.alarmMonitorMaskKvpField[i] != null && this.alarmStateMaskKvpField[i] != null) {
                int[] nArray = this.computeTriggerBits(this.alarmMonitorMaskKvpField[i].getStringValue(), this.alarmStateMaskKvpField[i].getStringValue());
                this.alarmTrigger_UIC[i].setBits(nArray);
            }
            this.alarmTriggerIntervalTime_UIC[i].setEnabled(this.alarmTriggerIntervalTimeKvpField[i] != null);
            if (this.alarmTriggerIntervalTimeKvpField[i] != null) {
                this.alarmTriggerIntervalTime_UIC[i].setText(this.alarmTriggerIntervalTimeKvpField[i].getStringValue());
            }
            this.alarmSendRemindersEnabled_UIC[i].setEnabled(this.alarmSendReminderEnabledKvpField[i] != null);
            if (this.alarmSendReminderEnabledKvpField[i] != null) {
                this.alarmSendRemindersEnabled_UIC[i].setSelected(RciProtocol.booleanValue((String)this.alarmSendReminderEnabledKvpField[i].getStringValue()));
            }
            this.alarmReminderIntervalTime_UIC[i].setEnabled(this.alarmReminderIntervalTimeKvpField[i] != null);
            if (this.alarmReminderIntervalTimeKvpField[i] != null) {
                this.alarmReminderIntervalTime_UIC[i].setText(this.alarmReminderIntervalTimeKvpField[i].getStringValue());
            }
            boolean bl = true;
            String string = this.alarmTriggerMode_UIC[i].getSelectedItem().toString();
            if (string.equalsIgnoreCase("gpio")) {
                bl = true;
            } else if (string.equalsIgnoreCase("pattern_match")) {
                bl = false;
            }
            this.alarmPattern_UIC[i].setEnabled(!bl);
            this.alarmTrigger_UIC[i].setEnabled(bl);
            this.alarmTriggerIntervalTime_UIC[i].setEnabled(bl);
            this.alarmSendRemindersEnabled_UIC[i].setEnabled(bl);
            this.alarmReminderIntervalTime_UIC[i].setEnabled(bl);
        }
        this.alarmsEnabled_UIC.setEnabled(this.alarmsEnabledKvpField != null);
        if (this.alarmsEnabledKvpField != null) {
            this.alarmsEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.alarmsEnabledKvpField.getStringValue()));
            if (!RciProtocol.booleanValue((String)this.alarmsEnabledKvpField.getStringValue())) {
                this.alarmContent.setContainerEnabled(false);
            }
        }
        if (this.alarmsEnabledKvpField == null) {
            this.content.setContainerEnabled(false);
        }
    }

    protected int[] computeTriggerBits(String string, String string2) {
        int[] nArray = new int[5];
        int n = 0;
        int n2 = 0;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                SystemLog.log((String)"GeneralException", (Throwable)numberFormatException);
            }
        }
        if (string2 != null && string2.length() > 0) {
            try {
                n2 = Integer.parseInt(string2.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                SystemLog.log((String)"GeneralException", (Throwable)numberFormatException);
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = this.gpioPinMask[i];
            int n4 = 0;
            if ((n & n3) != 0) {
                n4 = (n2 & n3) != 0 ? 1 : 2;
            }
            nArray[i] = n4;
        }
        return nArray;
    }

    protected String computeMonitorMask(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            n |= this.gpioPinMask[i];
        }
        String string = "0x" + Integer.toHexString(n);
        SystemLog.debug((String)("computed monitor mask as: " + string));
        return string;
    }

    protected String computeStateMask(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0 || nArray[i] != 1) continue;
            n |= this.gpioPinMask[i];
        }
        String string = "0x" + Integer.toHexString(n);
        SystemLog.debug((String)("computed state mask as: " + string));
        return string;
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        if (!this.alarmsEnabled_UIC.isSelected()) {
            return;
        }
        try {
            if (!ValidationHelper.isValidIPAddress((String)this.alarmSmtpServer_UIC.getText()) || InetAddress.getByName(this.alarmSmtpServer_UIC.getText()).equals(InetAddress.getByName("0.0.0.0"))) {
                collection.add(new ValidationError("AlarmSmtpServerError"));
            }
            if (!ValidationHelper.isValidEmailAddress((String)this.alarmSmtpFrom_UIC.getText())) {
                collection.add(new ValidationError("AlarmSmtpFromError"));
            }
            for (int i = 0; i < this.MAXALARMS; ++i) {
                if (!ValidationHelper.isValidInteger((String)this.alarmTriggerIntervalTime_UIC[i].getText())) {
                    collection.add(new ValidationError("AlarmTriggerIntervalError", new Serializable[]{String.valueOf(i + 1)}));
                }
                if (this.alarmTo_UIC[i].getText().length() > 0 && !ValidationHelper.isValidEmailAddress((String)this.alarmTo_UIC[i].getText())) {
                    collection.add(new ValidationError("AlarmToError", new Serializable[]{String.valueOf(i + 1)}));
                }
                if (this.alarmCc_UIC[i].getText().length() > 0 && !ValidationHelper.isValidEmailAddress((String)this.alarmCc_UIC[i].getText())) {
                    collection.add(new ValidationError("AlarmCcError", new Serializable[]{String.valueOf(i + 1)}));
                }
                if (!this.alarmEnabled_UIC[i].isSelected()) continue;
                if (this.alarmTo_UIC[i].getText().length() == 0) {
                    collection.add(new ValidationError("AlarmToError", new Serializable[]{String.valueOf(i + 1)}));
                }
                if (this.alarmSubject_UIC[i].getText().length() != 0) continue;
                collection.add(new ValidationError("AlarmSubjectError", new Serializable[]{String.valueOf(i + 1)}));
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in AlarmGpioView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

