/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SerialStatisticsView
extends ConfigViewImpl {
    KvpNode viewStateTree;
    DeviceChangeListener stateChangeListener;
    GridContentPanel content;
    GridContentPanel signalsContent;
    GridContentPanel countersContent;
    KvpField overrunErrKvpField;
    KvpField overflowErrKvpField;
    KvpField frameErrKvpField;
    KvpField parityErrKvpField;
    KvpField rxKvpField;
    KvpField txKvpField;
    KvpField dtrKvpField;
    KvpField rtsKvpField;
    KvpField ctsKvpField;
    KvpField dsrKvpField;
    KvpField dcdKvpField;
    KvpField rtsToggleKvpField;
    JLabel overrunErr_UIC;
    JLabel overflowErr_UIC;
    JLabel frameErr_UIC;
    JLabel parityErr_UIC;
    JLabel rx_UIC;
    JLabel tx_UIC;
    JLabel dtr_UIC;
    JLabel rts_UIC;
    JLabel cts_UIC;
    JLabel dsr_UIC;
    JLabel dcd_UIC;
    JLabel rtsToggle_UIC;

    public SerialStatisticsView() throws Exception {
        super(false);
        this.setIncludeStateFields(true);
        this.setIncludeSettingsFields(false);
        this.viewStateTree = new KvpNode();
        this.stateChangeListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                SerialStatisticsView.this.refreshViewKvpNode();
                SerialStatisticsView.this.refreshViewControls();
            }
        };
        this.content = new GridContentPanel(this.getName(), 1);
        this.content.addHeadingBar("SerialSignalsHeading");
        this.signalsContent = new GridContentPanel(5);
        this.dtr_UIC = this.signalsContent.addJLabel("DTR", null, 25, 0, false);
        this.rts_UIC = this.signalsContent.addJLabel("RTS", null, 25, 1, false);
        this.cts_UIC = this.signalsContent.addJLabel("CTS", null, 25, 2, false);
        this.dsr_UIC = this.signalsContent.addJLabel("DSR", null, 25, 3, false);
        this.dcd_UIC = this.signalsContent.addJLabel("DCD", null, 25, 4, true);
        this.rtsToggle_UIC = this.signalsContent.addJLabel("RtsToggle", null, 25);
        this.content.addSubPanel((JComponent)this.signalsContent);
        this.content.addHeadingBar("SerialStatisticsHeading");
        this.countersContent = new GridContentPanel(2);
        this.tx_UIC = this.countersContent.addJLabel("TX", null, 100, 0, false);
        this.rx_UIC = this.countersContent.addJLabel("RX", null, 100, 1, true);
        this.overrunErr_UIC = this.countersContent.addJLabel("OverrunErr", null, 100, 0, false);
        this.overflowErr_UIC = this.countersContent.addJLabel("OverflowErr", null, 100, 1, true);
        this.frameErr_UIC = this.countersContent.addJLabel("FrameErr", null, 100, 0, false);
        this.parityErr_UIC = this.countersContent.addJLabel("ParityErr", null, 100, 1, true);
        this.content.addSubPanel((JComponent)this.countersContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialStatisticsView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }

    private void refreshViewKvpNode() {
        this.viewStateTree.clear();
        this.overrunErrKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "overrun_err");
        this.overflowErrKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "overflow_err");
        this.frameErrKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "frame_err");
        this.parityErrKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "parity_err");
        this.rxKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "rx");
        this.txKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "tx");
        this.dtrKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "dtr");
        this.rtsKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "rts");
        this.ctsKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "cts");
        this.dsrKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "dsr");
        this.dcdKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "dcd");
        this.rtsToggleKvpField = this.viewStateTree.mergeFrom(this.device.getInternalStateTree(), "serial_stats", "rts_toggle");
    }

    private void refreshViewControls() {
        this.refreshUIFromField(this.overrunErr_UIC, this.overrunErrKvpField);
        this.refreshUIFromField(this.overflowErr_UIC, this.overflowErrKvpField);
        this.refreshUIFromField(this.frameErr_UIC, this.frameErrKvpField);
        this.refreshUIFromField(this.parityErr_UIC, this.parityErrKvpField);
        this.refreshUIFromField(this.rx_UIC, this.rxKvpField);
        this.refreshUIFromField(this.tx_UIC, this.txKvpField);
        this.refreshUIFromField(this.dtr_UIC, this.dtrKvpField);
        this.refreshUIFromField(this.rts_UIC, this.rtsKvpField);
        this.refreshUIFromField(this.cts_UIC, this.ctsKvpField);
        this.refreshUIFromField(this.dsr_UIC, this.dsrKvpField);
        this.refreshUIFromField(this.dcd_UIC, this.dcdKvpField);
        this.refreshUIFromField(this.rtsToggle_UIC, this.rtsToggleKvpField);
    }

    private void refreshUIFromField(JLabel jLabel, KvpField kvpField) {
        jLabel.setEnabled(kvpField != null);
        if (kvpField != null) {
            jLabel.setText(kvpField.getStringValue());
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
        this.device.addStateChangeListener(this.stateChangeListener);
        this.doRefreshAction();
    }

    public void deactivate() {
        this.device.removeStateChangeListener(this.stateChangeListener);
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

