/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciProtocol;
import com.digi.config.core.ValidationError;
import com.digi.config.core.ValidationHelper;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SerialAdvancedView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            SerialAdvancedView.this.refreshViewKvpNode();
            SerialAdvancedView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    GridContentPanel tcpSocketIdContent;
    GridContentPanel tcpIdleTimeoutContent;
    GridContentPanel tcpConnectContent;
    GridContentPanel udpSocketIdContent;
    KvpField tcpSocketIdEnabledKvpField;
    KvpField tcpSocketIdKvpField;
    KvpField tcpIdleTimeoutKvpField;
    KvpField tcpDropDCDEnabledKvpField;
    KvpField tcpDropDSREnabledKvpField;
    KvpField udpSocketIdEnabledKvpField;
    KvpField udpSocketIdKvpField;
    JCheckBox tcpSocketIdEnabled_UIC;
    JTextField tcpSocketId_UIC;
    JCheckBox tcpIdleTimeoutEnabled_UIC;
    JTextField tcpIdleTimeout_UIC;
    JCheckBox tcpDropDCDEnabled_UIC;
    JCheckBox tcpDropDSREnabled_UIC;
    JCheckBox udpSocketIdEnabled_UIC;
    JTextField udpSocketId_UIC;

    public SerialAdvancedView() throws Exception {
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == SerialAdvancedView.this.tcpSocketIdEnabled_UIC) {
                    SerialAdvancedView.this.tcpSocketIdEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialAdvancedView.this.tcpSocketIdEnabled_UIC.isSelected()));
                    SerialAdvancedView.this.tcpSocketIdContent.setContainerEnabled(SerialAdvancedView.this.tcpSocketIdEnabled_UIC.isSelected());
                } else if (object == SerialAdvancedView.this.tcpSocketId_UIC) {
                    SerialAdvancedView.this.tcpSocketIdKvpField.setStringValue(SerialAdvancedView.this.tcpSocketId_UIC.getText());
                } else if (object == SerialAdvancedView.this.tcpIdleTimeoutEnabled_UIC) {
                    SerialAdvancedView.this.tcpIdleTimeoutKvpField.setStringValue(SerialAdvancedView.this.tcpIdleTimeoutEnabled_UIC.isSelected() ? SerialAdvancedView.this.tcpIdleTimeout_UIC.getText() : "0");
                    SerialAdvancedView.this.tcpIdleTimeoutContent.setContainerEnabled(SerialAdvancedView.this.tcpIdleTimeoutEnabled_UIC.isSelected());
                } else if (object == SerialAdvancedView.this.tcpIdleTimeout_UIC) {
                    SerialAdvancedView.this.tcpIdleTimeoutKvpField.setStringValue(SerialAdvancedView.this.tcpIdleTimeout_UIC.getText());
                } else if (object == SerialAdvancedView.this.tcpDropDCDEnabled_UIC) {
                    SerialAdvancedView.this.tcpDropDCDEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialAdvancedView.this.tcpDropDCDEnabled_UIC.isSelected()));
                } else if (object == SerialAdvancedView.this.tcpDropDSREnabled_UIC) {
                    SerialAdvancedView.this.tcpDropDSREnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialAdvancedView.this.tcpDropDSREnabled_UIC.isSelected()));
                } else if (object == SerialAdvancedView.this.udpSocketIdEnabled_UIC) {
                    SerialAdvancedView.this.udpSocketIdEnabledKvpField.setStringValue(RciProtocol.toString((boolean)SerialAdvancedView.this.udpSocketIdEnabled_UIC.isSelected()));
                    SerialAdvancedView.this.udpSocketIdContent.setContainerEnabled(SerialAdvancedView.this.udpSocketIdEnabled_UIC.isSelected());
                } else if (object == SerialAdvancedView.this.udpSocketId_UIC) {
                    SerialAdvancedView.this.udpSocketIdKvpField.setStringValue(SerialAdvancedView.this.udpSocketId_UIC.getText());
                }
            }
        };
        this.content.addHeadingBar("SerialAdvancedTcpHeading");
        this.tcpSocketIdEnabled_UIC = this.content.addJCheckBox("TcpSocketIdEnabled", (ActionListener)controlChangeAdapter);
        this.tcpSocketIdContent = new GridContentPanel(1);
        this.tcpSocketId_UIC = this.tcpSocketIdContent.addJTextField("TcpSocketId", "TcpSocketIdDesc", 100, (FocusListener)controlChangeAdapter);
        this.content.addSubPanel((JComponent)this.tcpSocketIdContent);
        this.tcpIdleTimeoutEnabled_UIC = this.content.addJCheckBox("TcpIdleTimeoutEnabled", (ActionListener)controlChangeAdapter);
        this.tcpIdleTimeoutContent = new GridContentPanel(1);
        this.tcpIdleTimeout_UIC = this.tcpIdleTimeoutContent.addJTextField("TcpIdleTimeout", "TcpIdleTimeoutDesc", 100, (FocusListener)controlChangeAdapter);
        this.tcpIdleTimeout_UIC.setDocument(this.createIntegerDocument());
        this.content.addSubPanel((JComponent)this.tcpIdleTimeoutContent);
        this.tcpDropDCDEnabled_UIC = this.content.addJCheckBox("TcpDropOnDCDEnabled", (ActionListener)controlChangeAdapter);
        this.tcpDropDSREnabled_UIC = this.content.addJCheckBox("TcpDropOnDSREnabled", (ActionListener)controlChangeAdapter);
        this.content.addHeadingBar("SerialAdvancedUdpHeading");
        this.udpSocketIdEnabled_UIC = this.content.addJCheckBox("UdpSocketIdEnabled", (ActionListener)controlChangeAdapter);
        this.udpSocketIdContent = new GridContentPanel(1);
        this.udpSocketId_UIC = this.udpSocketIdContent.addJTextField("UdpSocketId", "UdpSocketIdDesc", 100, (FocusListener)controlChangeAdapter);
        this.content.addSubPanel((JComponent)this.udpSocketIdContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialAdvancedView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        this.tcpSocketIdEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "socketid_state");
        this.tcpSocketIdKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "socketid_string");
        this.tcpIdleTimeoutKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "idle_timeout");
        this.tcpDropDCDEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "hangup_dcd");
        this.tcpDropDSREnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "tcp_serial", "hangup_dsr");
        this.udpSocketIdEnabledKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "udp_serial", "socketid_state");
        this.udpSocketIdKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "udp_serial", "socketid_string");
    }

    private void refreshViewControls() {
        this.tcpSocketId_UIC.setEnabled(this.tcpSocketIdKvpField != null);
        if (this.tcpSocketIdKvpField != null) {
            this.tcpSocketId_UIC.setText(this.tcpSocketIdKvpField.getStringValue());
        }
        this.tcpSocketIdEnabled_UIC.setEnabled(this.tcpSocketIdEnabledKvpField != null);
        if (this.tcpSocketIdEnabledKvpField != null) {
            this.tcpSocketIdEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpSocketIdEnabledKvpField.getStringValue()));
            this.tcpSocketIdContent.setContainerEnabled(this.tcpSocketIdEnabled_UIC.isSelected());
        }
        this.tcpIdleTimeout_UIC.setEnabled(this.tcpIdleTimeoutKvpField != null);
        this.tcpIdleTimeoutEnabled_UIC.setEnabled(this.tcpIdleTimeoutKvpField != null);
        if (this.tcpIdleTimeoutKvpField != null) {
            if (Integer.parseInt(this.tcpIdleTimeoutKvpField.getStringValue()) <= 0) {
                this.tcpIdleTimeoutEnabled_UIC.setSelected(false);
                this.tcpIdleTimeout_UIC.setText("");
            } else {
                this.tcpIdleTimeoutEnabled_UIC.setSelected(true);
                this.tcpIdleTimeout_UIC.setText(this.tcpIdleTimeoutKvpField.getStringValue());
            }
            this.tcpIdleTimeoutContent.setContainerEnabled(this.tcpIdleTimeoutEnabled_UIC.isSelected());
        }
        this.tcpDropDCDEnabled_UIC.setEnabled(this.tcpDropDCDEnabledKvpField != null);
        if (this.tcpDropDCDEnabledKvpField != null) {
            this.tcpDropDCDEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpDropDCDEnabledKvpField.getStringValue()));
        }
        this.tcpDropDSREnabled_UIC.setEnabled(this.tcpDropDSREnabledKvpField != null);
        if (this.tcpDropDSREnabledKvpField != null) {
            this.tcpDropDSREnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.tcpDropDSREnabledKvpField.getStringValue()));
        }
        this.udpSocketId_UIC.setEnabled(this.udpSocketIdKvpField != null);
        if (this.udpSocketIdKvpField != null) {
            this.udpSocketId_UIC.setText(this.udpSocketIdKvpField.getStringValue());
        }
        this.udpSocketIdEnabled_UIC.setEnabled(this.udpSocketIdEnabledKvpField != null);
        if (this.udpSocketIdEnabledKvpField != null) {
            this.udpSocketIdEnabled_UIC.setSelected(RciProtocol.booleanValue((String)this.udpSocketIdEnabledKvpField.getStringValue()));
            this.udpSocketIdContent.setContainerEnabled(this.udpSocketIdEnabled_UIC.isSelected());
        }
        if (this.tcpSocketIdKvpField == null) {
            this.content.setContainerEnabled(false);
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        try {
            if (this.tcpSocketIdEnabled_UIC.isSelected() && (this.tcpSocketId_UIC.getText().length() <= 0 || this.tcpSocketId_UIC.getText().length() > 40)) {
                collection.add(new ValidationError("SerialTcpSocketIdError"));
            }
            if (this.tcpIdleTimeoutEnabled_UIC.isSelected() && (!ValidationHelper.isValidUnsigned16((String)this.tcpIdleTimeout_UIC.getText()) || Integer.parseInt(this.tcpIdleTimeout_UIC.getText()) <= 0)) {
                collection.add(new ValidationError("SerialTcpIdleTimeoutError"));
            }
            if (this.udpSocketIdEnabled_UIC.isSelected() && (this.udpSocketId_UIC.getText().length() <= 0 || this.udpSocketId_UIC.getText().length() > 40)) {
                collection.add(new ValidationError("SerialUdpSocketIdError"));
            }
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in SerialAdvancedView::validationChanges()");
            exception.printStackTrace();
        }
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

