/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class SecureAccessIcon
extends JLabel {
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private boolean secure = false;
    private ImageIcon secureIcon = null;
    private ImageIcon unsecureIcon = null;
    String secureToolTip = null;
    String unsecureToolTip = null;

    public SecureAccessIcon() {
        this.initialize();
        this.setSecure(false);
    }

    public SecureAccessIcon(boolean bl) {
        this.initialize();
        this.setSecure(bl);
    }

    public SecureAccessIcon(String string) {
        this.initialize();
        this.setSecure(string);
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
        this.setIcon(this.secure ? this.secureIcon : this.unsecureIcon);
        this.setToolTipText(this.secure ? this.secureToolTip : this.unsecureToolTip);
        this.paintImmediately(this.getVisibleRect());
    }

    public void setSecure(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            SystemLog.debug((String)(string + " is a bad URL. Showing unsecure icon."), (Throwable)malformedURLException);
        }
        if (uRL != null && uRL.getProtocol().equalsIgnoreCase(HTTPS_PROTOCOL)) {
            this.setSecure(true);
        } else {
            this.setSecure(false);
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    private void initialize() {
        this.secureIcon = ConfigResource.getImageRbIcon((String)"SecureAccessImage");
        this.unsecureIcon = ConfigResource.getImageRbIcon((String)"UnsecureAccessImage");
        this.secureToolTip = ConfigResource.getUiRbString((String)"SecureAccessToolTip");
        this.unsecureToolTip = ConfigResource.getUiRbString((String)"UnsecureAccessToolTip");
    }
}

