/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceCommandException;
import com.digi.config.core.DeviceValidationException;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciCommandError;
import com.digi.config.ui.ConfigAction;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.Busy;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class RestoreFactoryDefaultsView
extends ConfigViewImpl {
    GridContentPanel content = new GridContentPanel(1);

    public RestoreFactoryDefaultsView() throws Exception {
        this.content.addTextLine("RestoreFactoryDefaultsHeading");
        this.content.addAction(null, (Action)new ConfigAction("RestoreNowBtn", this, "doRestoreFactoryDefaultsAction"), "RestoreNowBtnDesc");
        this.content.addVGlue();
    }

    public void doRestoreFactoryDefaultsAction() {
        int n;
        boolean bl = this.restoreFactoryDefaults();
        this.doRefreshAction();
        if (bl && (n = JOptionPane.showConfirmDialog((Component)this.content, ConfigResource.getUiRbString((String)"RestoreFactoryDefaultsRebootPrompt"), ConfigResource.getUiRbString((String)"RestoreFactoryDefaultsViewTitle"), 0)) == 0) {
            this.reboot();
        }
    }

    boolean restoreFactoryDefaults() {
        boolean bl = false;
        Busy.begin((String)ConfigResource.getUiRbString((String)"RestoreFactoryDefaultsStatus"));
        try {
            this.device.restoreFactoryDefaults();
            SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RestoreFactoryDefaultsMenu")});
            bl = true;
        }
        catch (DeviceCommandException deviceCommandException) {
            SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RestoreFactoryDefaultsMenu")}, (Throwable)deviceCommandException);
        }
        catch (DeviceValidationException deviceValidationException) {
            SystemLog.debug((String)"Invalid fields detected while restoring factory default settings on device", (Throwable)deviceValidationException);
            KvpNode kvpNode = deviceValidationException.getCluster();
            Collection collection = kvpNode.getErrors();
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RciCommandError rciCommandError = (RciCommandError)iterator.next();
                stringBuffer.append(rciCommandError.toString() + "\n");
            }
            SystemLog.log((String)"RestoreFactoryDefaultsError", (Serializable[])new Serializable[]{stringBuffer.toString()});
        }
        Busy.end();
        return bl;
    }

    void reboot() {
        Busy.begin((String)ConfigResource.getUiRbString((String)"RebootStatus"));
        try {
            this.device.reboot();
            SystemLog.log((String)"Op1Succ", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RebootMenu")});
        }
        catch (DeviceCommandException deviceCommandException) {
            SystemLog.log((String)"Op1Fail", (Serializable[])new Serializable[]{ConfigResource.getUiRbString((String)"RebootMenu")}, (Throwable)deviceCommandException);
        }
        Busy.end();
    }

    public String getName() {
        return "RestoreFactoryDefaultsView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public Component getViewButtons() {
        return null;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
    }

    public void activate() {
        SystemLog.debug((String)"Activating RestoreFactoryDefaultsView");
    }

    public void deactivate() {
        SystemLog.debug((String)"Deactivating RestoreFactoryDefaultsView");
    }

    public boolean isChanged() {
        return false;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
    }

    public void commitChanges() {
    }

    public void cancelChanges() {
    }
}

