/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.CustomPanel;
import com.digi.config.util.SystemLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GlobalSettingView
extends ConfigViewImpl {
    JLabel heading;
    JPanel encompassingPanel;
    JTree globalKvpFieldTree;
    KvpNodeTreeModel kvpFieldTreeModel = new KvpNodeTreeModel();
    JPanel editKvpFieldPanel;
    KvpField selectedKvpField;
    JLabel editKvpFieldName;
    JTextField editKvpFieldValue;
    KvpNode viewSettingTree;
    DeviceChangeListener deviceChangedListener;

    public GlobalSettingView() throws Exception {
        super(true);
        this.globalKvpFieldTree = new JTree(this.kvpFieldTreeModel);
        this.globalKvpFieldTree.getSelectionModel().setSelectionMode(1);
        this.globalKvpFieldTree.setCellRenderer(new KvpFieldRenderer());
        this.globalKvpFieldTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                KvpNode kvpNode;
                Object object = treeSelectionEvent.getPath().getLastPathComponent();
                if (object == null) {
                    return;
                }
                if (object instanceof KvpNode && (kvpNode = (KvpNode)object).getName().length() > 0 && kvpNode.getChildCount() == 0) {
                    GlobalSettingView.this.doEditKvpField((KvpField)kvpNode);
                }
            }
        });
        this.encompassingPanel = new CustomPanel(this.getName());
        this.encompassingPanel.setLayout(new BorderLayout());
        this.encompassingPanel.add((Component)this.globalKvpFieldTree, "Center");
        this.encompassingPanel.add((Component)this.getEditKvpFieldPanel(), "South");
    }

    public String getName() {
        return "GlobalSettingView";
    }

    public Component getViewContent() {
        return this.encompassingPanel;
    }

    public void activate() {
        SystemLog.debug((String)"Activating GlobalSettingView");
        this.viewSettingTree = this.device.getSettingTree();
        this.viewSettingTree.resetChanged();
        this.kvpFieldTreeModel.setKvpNode(this.viewSettingTree);
        this.deviceChangedListener = new DeviceChangeListener(){

            public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
                GlobalSettingView.this.viewSettingTree = GlobalSettingView.this.device.getSettingTree();
                GlobalSettingView.this.viewSettingTree.resetChanged();
                GlobalSettingView.this.kvpFieldTreeModel.setKvpNode(GlobalSettingView.this.viewSettingTree);
            }
        };
        this.device.addSettingChangeListener(this.deviceChangedListener);
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        this.device.removeSettingChangeListener(this.deviceChangedListener);
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.viewSettingTree = this.device.getSettingTree();
        this.viewSettingTree.resetChanged();
        this.kvpFieldTreeModel.setKvpNode(this.viewSettingTree);
    }

    public void doEditKvpField(KvpField kvpField) {
        this.selectedKvpField = kvpField;
        this.editKvpFieldName.setText(kvpField.getName() + " = ");
        this.editKvpFieldValue.setText(kvpField.getStringValue());
        this.editKvpFieldValue.requestFocus();
    }

    public void doEditKvpFieldComplete() {
        TreePath treePath = this.globalKvpFieldTree.getSelectionPath();
        if (treePath != null) {
            this.kvpFieldTreeModel.valueForPathChanged(treePath, this.editKvpFieldValue.getText());
        }
    }

    public JPanel getEditKvpFieldPanel() {
        if (this.editKvpFieldPanel == null) {
            this.editKvpFieldPanel = new JPanel(new BorderLayout());
            this.editKvpFieldName = new JLabel();
            this.editKvpFieldValue = new JTextField();
            this.editKvpFieldPanel.add((Component)this.editKvpFieldName, "West");
            this.editKvpFieldPanel.add((Component)this.editKvpFieldValue, "Center");
            this.editKvpFieldValue.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GlobalSettingView.this.doEditKvpFieldComplete();
                }
            });
            this.editKvpFieldPanel.setMinimumSize(new Dimension(400, 100));
        }
        return this.editKvpFieldPanel;
    }

    public class KvpNodeTreeModel
    implements TreeModel {
        private KvpNode rootNode;
        private Vector treeModelListeners = new Vector();

        public void setKvpNode(KvpNode kvpNode) {
            System.out.println("GlobalSettingView.setKvpNode(" + kvpNode + ")");
            this.rootNode = kvpNode;
            if (kvpNode != null) {
                this.fireTreeStructureChanged(kvpNode);
            }
        }

        protected void fireTreeStructureChanged(KvpNode kvpNode) {
            int n = this.treeModelListeners.size();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{kvpNode});
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(treeModelEvent);
            }
        }

        protected void fireTreeNodesChanged(TreePath treePath) {
            int n = this.treeModelListeners.size();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesChanged(treeModelEvent);
            }
        }

        public Object getRoot() {
            return this.rootNode;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object == null || object2 == null) {
                return -1;
            }
            if (object instanceof KvpNode) {
                ArrayList arrayList = new ArrayList(((KvpNode)object).getAllFields());
                return arrayList.indexOf(object2);
            }
            return -1;
        }

        public Object getChild(Object object, int n) {
            if (object == null) {
                return null;
            }
            if (object instanceof KvpNode) {
                ArrayList arrayList = new ArrayList(((KvpNode)object).getAllFields());
                return arrayList.get(n);
            }
            return null;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.addElement(treeModelListener);
        }

        public int getChildCount(Object object) {
            int n = 0;
            if (object instanceof KvpNode) {
                n = ((KvpNode)object).getAllFields().size();
            }
            return n;
        }

        public boolean isLeaf(Object object) {
            boolean bl = true;
            if (object instanceof KvpNode) {
                bl = ((KvpNode)object).getChildCount() == 0;
            }
            return bl;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            Object object2 = treePath.getLastPathComponent();
            if (object2 instanceof KvpField) {
                KvpField kvpField = (KvpField)object2;
                kvpField.setStringValue((String)object);
                this.fireTreeNodesChanged(treePath);
            }
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.remove(treeModelListener);
        }
    }

    public class KvpFieldRenderer
    extends JLabel
    implements TreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            if (object instanceof KvpNode) {
                KvpNode kvpNode = (KvpNode)object;
                String string = "Device";
                if (kvpNode.getName().length() > 0) {
                    string = kvpNode.getName();
                    String string2 = kvpNode.getAttribute("index");
                    if (string2 != null) {
                        string = string + "[" + string2 + "]";
                    }
                    if (kvpNode.getStringValue().length() > 0) {
                        string = string + " = " + kvpNode.getStringValue();
                    }
                }
                this.setText(string);
                if (bl) {
                    this.setOpaque(true);
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLACK);
                }
            } else {
                this.setText("Error. Invalid Node type of " + object.getClass().getName());
            }
            return this;
        }
    }
}

