/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.ControlledItem;
import com.digi.config.core.Controller;
import com.digi.config.core.ControllerMembershipEvent;
import com.digi.config.core.ControllerMembershipListener;
import com.digi.config.ui.ControlledItemFilter;
import com.digi.config.util.ArrayMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ControllerListModel
implements ListModel,
Serializable {
    protected Controller controller;
    protected boolean listUpdates = false;
    protected ArrayList filterChain;
    protected ArrayMap exposedItems;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public void addFilter(ControlledItemFilter controlledItemFilter) {
        this.filterChain.add(controlledItemFilter);
        this.resetExposedItems();
    }

    public void removeFilter(ControlledItemFilter controlledItemFilter) {
        this.filterChain.remove(controlledItemFilter);
        this.resetExposedItems();
    }

    public void updateFilter(ControlledItemFilter controlledItemFilter) {
        this.resetExposedItems();
    }

    protected void resetExposedItems() {
        this.exposedItems.clear();
        Iterator iterator = this.controller.getIterator();
        while (iterator.hasNext()) {
            ControlledItem controlledItem = (ControlledItem)iterator.next();
            if (this.isFiltered(controlledItem)) continue;
            this.exposedItems.put((Object)controlledItem, (Object)controlledItem);
        }
        this.refreshList();
    }

    protected boolean isFiltered(ControlledItem controlledItem) {
        Iterator iterator = this.filterChain.iterator();
        while (iterator.hasNext()) {
            ControlledItemFilter controlledItemFilter = (ControlledItemFilter)iterator.next();
            if (!controlledItemFilter.isFiltered(controlledItem)) continue;
            return true;
        }
        return false;
    }

    protected int findExposedItemPosition(int n) {
        Object[] objectArray = this.controller.getElements().toArray();
        Object var3_3 = null;
        for (int i = n - 1; i >= 0; --i) {
            ControlledItem controlledItem = (ControlledItem)objectArray[i];
            if (this.exposedItems.get((Object)controlledItem) == null) continue;
            return this.exposedItems.valuesList().indexOf(controlledItem) + 1;
        }
        return 0;
    }

    ControllerListModel(Controller controller) {
        this.controller = controller;
        this.filterChain = new ArrayList();
        this.exposedItems = new ArrayMap();
        controller.addControllerMembershipListener(new ControllerMembershipListener(){

            public void itemsAdded(ControllerMembershipEvent controllerMembershipEvent) {
                ControllerListModel.this.controllerItemsAdded(controllerMembershipEvent);
            }

            public void itemsRemoved(ControllerMembershipEvent controllerMembershipEvent) {
                ControllerListModel.this.controllerItemsRemoved(controllerMembershipEvent);
            }

            public void itemsResorted(Controller controller) {
                ControllerListModel.this.controllerItemsResorted();
            }
        });
        this.resetExposedItems();
    }

    public int getSize() {
        return this.exposedItems.size();
    }

    public Object getElementAt(int n) {
        return (ControlledItem)this.exposedItems.valuesList().get(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = ControllerListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = ControllerListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    protected void fireListContentsChanged(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? ControllerListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    protected void fireListIntervalAdded(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? ControllerListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    protected void fireListIntervalRemoved(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? ControllerListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
        }
    }

    protected void rowsAdded(int n, int n2) {
        this.listUpdates = true;
        this.fireListIntervalAdded(n, n2);
        this.listUpdates = false;
    }

    protected void rowsRemoved(int n, int n2) {
        this.listUpdates = true;
        this.fireListIntervalRemoved(n, n2);
        this.listUpdates = false;
    }

    protected void refreshList() {
        this.listUpdates = true;
        this.fireListContentsChanged(0, this.getSize());
        this.listUpdates = false;
    }

    protected void controllerItemsAdded(ControllerMembershipEvent controllerMembershipEvent) {
        int n = controllerMembershipEvent.items().size();
        if (n > 0) {
            int n2 = controllerMembershipEvent.getReferencePosition();
            int n3 = this.findExposedItemPosition(n2);
            int n4 = n3 - 1;
            Iterator iterator = controllerMembershipEvent.iterator();
            while (iterator.hasNext()) {
                ControlledItem controlledItem = (ControlledItem)iterator.next();
                if (this.isFiltered(controlledItem)) continue;
                this.exposedItems.putAt((Object)controlledItem, ++n4, (Object)controlledItem);
            }
            if (n4 >= n3) {
                this.rowsAdded(n3, n4);
            }
        }
    }

    protected void controllerItemsRemoved(ControllerMembershipEvent controllerMembershipEvent) {
        int n = controllerMembershipEvent.items().size();
        if (n > 0) {
            int n2 = -1;
            int n3 = n2 - 1;
            Iterator iterator = controllerMembershipEvent.iterator();
            while (iterator.hasNext()) {
                ControlledItem controlledItem = (ControlledItem)iterator.next();
                if (!this.exposedItems.containsKey((Object)controlledItem)) continue;
                n3 = n2 == -1 ? (n2 = this.exposedItems.valuesList().indexOf(controlledItem)) : ++n3;
                this.exposedItems.remove((Object)controlledItem);
            }
            if (n3 >= n2) {
                this.rowsRemoved(n2, n3);
            }
        }
    }

    protected void controllerItemsResorted() {
        this.resetExposedItems();
        this.refreshList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

