/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.ui.ConfigAppPanel;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.ConfigSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ConfigBorderPanel
extends JPanel {
    JPanel northPanel = null;
    JPanel southPanel = null;
    JPanel eastPanel = null;
    JPanel westPanel = null;
    ConfigAppPanel configAppPanel = null;
    private static final int PREFERRED_WIDTH = 800;
    private static final int PREFERRED_HEIGHT = 720;
    private ResourceBundle bundle = null;

    public ConfigBorderPanel() throws Exception {
        SplashScreenPanel.currentScreen().updateProgress();
        this.setLayout(new BorderLayout());
        this.initializeContent();
    }

    public void initializeContent() throws Exception {
        if (this.northPanel == null) {
            this.northPanel = this.getUserPanel("NorthBorder");
            this.add((Component)this.northPanel, "North");
            SplashScreenPanel.currentScreen().updateProgress();
        }
        if (this.southPanel == null) {
            this.southPanel = this.getUserPanel("SouthBorder");
            this.add((Component)this.southPanel, "South");
            SplashScreenPanel.currentScreen().updateProgress();
        }
        if (this.eastPanel == null) {
            this.eastPanel = this.getUserPanel("EastBorder");
            this.add((Component)this.eastPanel, "East");
            SplashScreenPanel.currentScreen().updateProgress();
        }
        if (this.westPanel == null) {
            this.westPanel = this.getUserPanel("WestBorder");
            this.add((Component)this.westPanel, "West");
            SplashScreenPanel.currentScreen().updateProgress();
        }
        this.add((Component)((Object)this.getConfigAppPanel()), "Center");
        SplashScreenPanel.currentScreen().updateProgress();
    }

    public JPanel getUserPanel(String string) {
        JPanel jPanel = new JPanel(){
            ImageIcon backgroundIcon = ConfigResource.getImageRbIcon((String)"BorderBackgroundImage");
            Image backgroundImage;
            boolean tileImage = true;
            boolean stretchImage = false;
            {
                this.setOpaque(false);
                if (this.backgroundIcon != null) {
                    this.backgroundImage = this.backgroundIcon.getImage();
                }
            }

            public void paint(Graphics graphics) {
                if (this.backgroundImage != null) {
                    if (this.tileImage) {
                        for (int i = 0; i < this.getWidth(); i += this.backgroundIcon.getIconWidth()) {
                            for (int j = 0; j < this.getHeight(); j += this.backgroundIcon.getIconHeight()) {
                                graphics.drawImage(this.backgroundImage, i, j, this);
                            }
                        }
                    } else if (this.stretchImage) {
                        graphics.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
                    } else {
                        graphics.drawImage(this.backgroundImage, 0, 0, this);
                    }
                }
                super.paint(graphics);
            }
        };
        jPanel.setBackground(Color.WHITE);
        int n = ConfigSettings.getInteger((String)"WindowSettings", (String)"BorderAreaWidth");
        int n2 = ConfigSettings.getInteger((String)"WindowSettings", (String)"BorderAreaHeight");
        jPanel.setSize(n, n2);
        if (string.equals("NorthBorder")) {
            ImageIcon imageIcon = ConfigResource.getImageRbIcon((String)"logo");
            ImageIcon imageIcon2 = ConfigResource.getImageRbIcon((String)"device");
        }
        return jPanel;
    }

    public ConfigAppPanel getConfigAppPanel() throws Exception {
        if (this.configAppPanel == null) {
            this.configAppPanel = new ConfigAppPanel();
            SplashScreenPanel.currentScreen().updateProgress();
        }
        return this.configAppPanel;
    }

    public String getString(String string) {
        String string2 = null;
        try {
            string2 = this.getResourceBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("java.util.MissingResourceException: Couldn't find value for: " + string);
        }
        if (string2 == null) {
            string2 = "Could not find resource: " + string + "  ";
        }
        return string2;
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("resources.swingset");
        }
        return this.bundle;
    }

    public static ImageIcon getImage(String string, Component component) {
        Image image = null;
        URLClassLoader uRLClassLoader = (URLClassLoader)component.getClass().getClassLoader();
        URL uRL = uRLClassLoader.findResource("images/" + string);
        image = component.getToolkit().createImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
            if (mediaTracker.isErrorAny()) {
                System.out.println("Error loading image " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new ImageIcon(image);
    }
}

