/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.ui.ConfigAppPanel;
import com.digi.config.ui.SplashScreenPanel;
import com.digi.config.util.ConfigResource;
import com.digi.config.util.ConfigSettings;
import com.digi.config.util.HelpDisplay;
import com.digi.config.util.HttpsSocketFactory;
import com.digi.config.util.PathLocater;
import com.digi.config.util.SystemLog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.Timer;

public class ConfigApp
extends JApplet {
    static HttpsSocketFactory httpsSocketFactory;
    static JFrame shellAppFrame;
    JFrame configAppFrame;
    boolean appletMode = true;
    protected ConfigAppPanel configPanel;
    protected static ConfigApp m_currentApplet;

    public static void main(String[] stringArray) {
        try {
            httpsSocketFactory = new HttpsSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)httpsSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)httpsSocketFactory);
            shellAppFrame = new JFrame();
            ConfigApp configApp = new ConfigApp();
            configApp.appletMode = false;
            shellAppFrame.setContentPane(configApp);
            configApp.init();
            configApp.start();
            shellAppFrame.setTitle(ConfigResource.getUiRbString((String)"AppTitle"));
            ImageIcon imageIcon = ConfigResource.getImageRbIcon((String)"logo");
            if (imageIcon != null) {
                shellAppFrame.setIconImage(imageIcon.getImage());
            }
            shellAppFrame.pack();
            shellAppFrame.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Error Initializing Configuration Application: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void init() {
        m_currentApplet = this;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.appletMode) {
            PathLocater.setDocumentBase((URL)this.getDocumentBase());
            HelpDisplay.setApplet((Applet)this);
        }
        ConfigResource.loadMsgTextRb((String)"com.digi.config.resources.ConfigResourceBundle");
        ConfigResource.loadUiTextRb((String)"com.digi.config.resources.ConfigUiResourceBundle");
        ConfigResource.loadUiImageRb((String)"com.digi.config.resources.ConfigImgResourceBundle");
        ConfigResource.loadHelpTextRb((String)"com.digi.config.resources.ConfigHelpResourceBundle");
        try {
            System.out.println("Initializing Applet...");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new SplashScreenPanel(), "Center");
            this.setSize(500, 300);
            this.setVisible(true);
            SplashScreenPanel.currentScreen().updateProgress();
            InitConfigAppPanelThread initConfigAppPanelThread = new InitConfigAppPanelThread();
            initConfigAppPanelThread.start();
        }
        catch (Exception exception) {
            System.out.println("Error Initializing Configuration Applet: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void setConfigPanel(ConfigAppPanel configAppPanel) {
        this.configPanel = configAppPanel;
    }

    public static ConfigApp currentApplet() {
        return m_currentApplet;
    }

    protected void launchConfigAppFrame() {
        try {
            this.configAppFrame = new JFrame();
            System.out.println("Initializing Interface...");
            this.configAppFrame.setTitle(ConfigResource.getUiRbString((String)"AppTitle") + " - " + this.configPanel.device.getUrlName());
            ImageIcon imageIcon = ConfigResource.getImageRbIcon((String)"logo");
            if (imageIcon != null) {
                this.configAppFrame.setIconImage(imageIcon.getImage());
            }
            this.configAppFrame.getContentPane().removeAll();
            this.configAppFrame.getContentPane().setLayout(new BorderLayout());
            this.configAppFrame.getContentPane().add((Component)((Object)this.configPanel), "Center");
            int n = ConfigSettings.getInteger((String)"WindowSettings", (String)"FrameWidth");
            int n2 = ConfigSettings.getInteger((String)"WindowSettings", (String)"FrameHeight");
            this.configAppFrame.setSize(new Dimension(n, n2));
            this.configAppFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.out.println("Closing browser window");
                    ConfigApp.this.exitApplication();
                }
            });
            this.configAppFrame.setVisible(true);
            SplashScreenPanel.currentScreen().finished();
            SplashScreenPanel.currentScreen().showCurrentState();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.getContentPane().validate();
            System.out.println("Running...");
        }
        catch (Exception exception) {
            System.out.println("Error Initializing Configuration Applet: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void exitApplication() {
        if (!this.appletMode) {
            shellAppFrame.setVisible(false);
            shellAppFrame.dispose();
            System.exit(0);
        }
    }

    static {
        m_currentApplet = null;
    }

    class InitConfigAppPanelThread
    extends Thread {
        InitConfigAppPanelThread() {
        }

        public void run() {
            Object object;
            try {
                System.out.println("Initializing main GUI in background thread...");
                if (ConfigApp.currentApplet().appletMode) {
                    String string;
                    System.out.println("Initializing applet settings...");
                    ConfigSettings.setBoolean((String)"General", (String)"AppletMode", (boolean)true);
                    SplashScreenPanel.currentScreen().updateProgress();
                    object = ConfigApp.this.getParameter("ConfigDeveloper");
                    if (object != null) {
                        System.getProperties().setProperty("ConfigDeveloper", (String)object);
                    }
                    if ((string = ConfigApp.this.getParameter("ConnectTimeout")) != null) {
                        System.getProperties().setProperty("sun.net.client.defaultConnectTimeout", string);
                    }
                    URL uRL = ConfigApp.currentApplet().getCodeBase();
                    String string2 = ConfigApp.this.getParameter("RciHost");
                    if (string2 == null || string2.trim().length() == 0) {
                        string2 = uRL.getHost();
                    }
                    System.getProperties().setProperty("RciHost", string2);
                    SystemLog.debug((String)("RciHost = " + string2));
                    String string3 = ConfigApp.this.getParameter("RciProtocol");
                    if (string3 == null || string3.trim().length() == 0) {
                        string3 = uRL.getProtocol();
                    }
                    System.getProperties().setProperty("RciProtocol", string3);
                }
                ConfigApp.currentApplet().setConfigPanel(new ConfigAppPanel(false));
                SplashScreenPanel.currentScreen().updateProgress();
            }
            catch (Exception exception) {
                System.out.println("Error Initializing Configuration Applet: " + exception.getMessage());
                exception.printStackTrace();
            }
            object = new Timer(1000, new ActionListener(this){
                private final /* synthetic */ InitConfigAppPanelThread this$1;
                {
                    this.this$1 = initConfigAppPanelThread;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigApp.currentApplet().launchConfigAppFrame();
                }
            });
            ((Timer)object).setRepeats(false);
            ((Timer)object).start();
        }
    }
}

