/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.SystemLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JComboBox;

public class SerialBasicView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            SerialBasicView.this.refreshViewKvpNode();
            SerialBasicView.this.refreshViewControls();
        }
    };
    GridContentPanel content = new GridContentPanel(this.getName(), 1);
    KvpField baudKvpField;
    KvpField databitsKvpField;
    KvpField parityKvpField;
    KvpField stopbitsKvpField;
    KvpField flowcontrolKvpField;
    JComboBox baud_UIC;
    JComboBox databits_UIC;
    JComboBox parity_UIC;
    JComboBox stopbits_UIC;
    JComboBox flowcontrol_UIC;

    public SerialBasicView() throws Exception {
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == SerialBasicView.this.baud_UIC) {
                    SerialBasicView.this.baudKvpField.setStringValue(SerialBasicView.this.baud_UIC.getSelectedItem().toString());
                } else if (object == SerialBasicView.this.databits_UIC) {
                    SerialBasicView.this.databitsKvpField.setStringValue(SerialBasicView.this.databits_UIC.getSelectedItem().toString());
                } else if (object == SerialBasicView.this.parity_UIC) {
                    SerialBasicView.this.parityKvpField.setStringValue(SerialBasicView.this.parity_UIC.getSelectedItem().toString());
                } else if (object == SerialBasicView.this.stopbits_UIC) {
                    SerialBasicView.this.stopbitsKvpField.setStringValue(SerialBasicView.this.stopbits_UIC.getSelectedItem().toString());
                } else if (object == SerialBasicView.this.flowcontrol_UIC) {
                    SystemLog.debug((String)(" flowcontrol_UIC value changed. Value is " + SerialBasicView.this.flowcontrol_UIC.getSelectedItem().toString()));
                    SerialBasicView.this.flowcontrolKvpField.setStringValue(SerialBasicView.this.flowcontrol_UIC.getSelectedItem().toString());
                }
            }
        };
        String[] stringArray = new String[]{"50", "75", "110", "134", "150", "200", "300", "600", "1200", "1800", "2400", "4800", "9600", "14400", "19200", "28800", "38400", "57600", "115200", "230400"};
        this.baud_UIC = this.content.addJComboBox("Baud", "BaudDesc", stringArray, (ActionListener)controlChangeAdapter);
        String[] stringArray2 = new String[]{"5", "6", "7", "8"};
        this.databits_UIC = this.content.addJComboBox("Databits", "DatabitsDesc", stringArray2, (ActionListener)controlChangeAdapter);
        String[] stringArray3 = new String[]{"none", "odd", "even", "mark", "space"};
        this.parity_UIC = this.content.addJComboBox("Parity", "ParityDesc", stringArray3, (ActionListener)controlChangeAdapter);
        String[] stringArray4 = new String[]{"1", "2"};
        this.stopbits_UIC = this.content.addJComboBox("Stopbits", "StopbitsDesc", stringArray4, (ActionListener)controlChangeAdapter);
        String[] stringArray5 = new String[]{"none", "software", "hardware"};
        this.flowcontrol_UIC = this.content.addJComboBox("Flowcontrol", "FlowcontrolDesc", stringArray5, (ActionListener)controlChangeAdapter);
        this.content.addVGlue();
    }

    public String getName() {
        return "SerialBasicView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refreshViewKvpNode();
        this.refreshViewControls();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refreshViewKvpNode() {
        this.viewSettingTree.clear();
        KvpNode kvpNode = this.viewSettingTree.mergeChild(this.device.getInternalSettingTree().getChild("serial"), true);
        if (kvpNode != null) {
            this.baudKvpField = kvpNode.getChild("baud");
            this.databitsKvpField = kvpNode.getChild("databits");
            this.parityKvpField = kvpNode.getChild("parity");
            this.stopbitsKvpField = kvpNode.getChild("stopbits");
            this.flowcontrolKvpField = kvpNode.getChild("flowcontrol");
        }
    }

    private void refreshViewControls() {
        this.baud_UIC.setEnabled(this.baudKvpField != null);
        if (this.baudKvpField != null) {
            this.baud_UIC.setSelectedItem(this.baudKvpField.getStringValue());
        }
        this.databits_UIC.setEnabled(this.databitsKvpField != null);
        if (this.databitsKvpField != null) {
            this.databits_UIC.setSelectedItem(this.databitsKvpField.getStringValue());
        }
        this.parity_UIC.setEnabled(this.parityKvpField != null);
        if (this.parityKvpField != null) {
            this.parity_UIC.setSelectedItem(this.parityKvpField.getStringValue());
        }
        this.stopbits_UIC.setEnabled(this.stopbitsKvpField != null);
        if (this.stopbitsKvpField != null) {
            this.stopbits_UIC.setSelectedItem(this.stopbitsKvpField.getStringValue());
        }
        this.flowcontrol_UIC.setEnabled(this.flowcontrolKvpField != null);
        if (this.flowcontrolKvpField != null) {
            this.flowcontrol_UIC.setSelectedItem(this.flowcontrolKvpField.getStringValue());
        }
    }

    public void activate() {
        SystemLog.debug((String)("Activating " + this.getName()));
    }

    public void deactivate() {
        SystemLog.debug((String)("Deactivating " + this.getName()));
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refreshViewKvpNode();
        this.refreshViewControls();
    }
}

