/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.core.Device;
import com.digi.config.core.DeviceChangeEvent;
import com.digi.config.core.DeviceChangeListener;
import com.digi.config.core.KvpField;
import com.digi.config.core.KvpNode;
import com.digi.config.core.RciAuthenticator;
import com.digi.config.core.ValidationError;
import com.digi.config.ui.ConfigViewImpl;
import com.digi.config.ui.ControlChangeAdapter;
import com.digi.config.ui.GridContentPanel;
import com.digi.config.util.ConfigResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SecurityView
extends ConfigViewImpl {
    KvpNode viewSettingTree = new KvpNode();
    DeviceChangeListener settingChangeListener = new DeviceChangeListener(){

        public void deviceChanged(DeviceChangeEvent deviceChangeEvent) {
            SecurityView.this.refresh();
        }
    };
    GridContentPanel content = new GridContentPanel(1);
    GridContentPanel securityContent;
    KvpField passwordModeKvpField;
    KvpField userNameKvpField;
    KvpNode passwordKvpField;
    JCheckBox passwordMode_UIC;
    JTextField userName_UIC;
    JPasswordField password_UIC;
    JPasswordField verifyPassword_UIC;
    String newPassword = "";

    public SecurityView() throws Exception {
        super(true);
        ControlChangeAdapter controlChangeAdapter = new ControlChangeAdapter(){

            public void changePerformed(Object object, ActionEvent actionEvent, FocusEvent focusEvent) {
                if (object == SecurityView.this.passwordMode_UIC) {
                    boolean bl = SecurityView.this.passwordMode_UIC.isSelected();
                    SecurityView.this.passwordModeKvpField.setStringValue(SecurityView.this.stringValuePasswordMode(bl));
                    SecurityView.this.securityContent.setContainerEnabled(bl);
                    if (!bl) {
                        SecurityView.this.refreshUserPassword();
                    }
                } else if (object == SecurityView.this.userName_UIC) {
                    SecurityView.this.userNameKvpField.setStringValue(SecurityView.this.userName_UIC.getText());
                } else if (object == SecurityView.this.password_UIC) {
                    SecurityView.this.passwordKvpField.setStringValue(String.valueOf(SecurityView.this.password_UIC.getPassword()));
                }
            }
        };
        this.passwordMode_UIC = this.content.addJCheckBox("SecurityPasswordMode", (ActionListener)controlChangeAdapter);
        this.securityContent = new GridContentPanel(1);
        this.securityContent.addTextLine("SecurityEnabledDesc");
        this.userName_UIC = this.securityContent.addJTextField("SecurityUserNameLbl", null, 150, (FocusListener)controlChangeAdapter);
        this.userName_UIC.setDocument(this.createGeneralDocument());
        this.password_UIC = this.securityContent.addJPasswordField("SecurityPasswordLbl", null, 150, (FocusListener)controlChangeAdapter);
        this.password_UIC.setDocument(this.createGeneralDocument());
        this.verifyPassword_UIC = this.securityContent.addJPasswordField("SecurityVerifyPasswordLbl", null, 150, (FocusListener)controlChangeAdapter);
        this.verifyPassword_UIC.setDocument(this.createGeneralDocument());
        this.content.addSubPanel((JComponent)this.securityContent);
        this.content.addVGlue();
    }

    public String getName() {
        return "SecurityView";
    }

    public Component getViewContent() {
        return this.content;
    }

    public void setDevice(Device device) {
        super.setDevice(device);
        this.refresh();
        device.addSettingChangeListener(this.settingChangeListener);
    }

    private void refresh() {
        this.viewSettingTree.clear();
        this.passwordModeKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "simple_password", "password_mode");
        this.passwordMode_UIC.setEnabled(this.passwordModeKvpField != null);
        if (this.passwordModeKvpField != null) {
            this.passwordMode_UIC.setSelected(this.booleanValuePasswordMode(this.passwordModeKvpField.getStringValue()));
        }
        this.refreshUserPassword();
    }

    private void refreshUserPassword() {
        KvpNode kvpNode;
        this.userNameKvpField = this.viewSettingTree.mergeFrom(this.device.getInternalSettingTree(), "simple_password", "username");
        this.userName_UIC.setEnabled(this.userNameKvpField != null);
        if (this.userNameKvpField != null) {
            this.userName_UIC.setText(this.userNameKvpField.getStringValue());
        }
        if ((kvpNode = this.viewSettingTree.getGroup("simple_password")) != null) {
            this.passwordKvpField = new KvpNode("password");
            kvpNode.addChild(this.passwordKvpField);
        }
        this.password_UIC.setEnabled(this.passwordKvpField != null);
        this.verifyPassword_UIC.setEnabled(this.passwordKvpField != null);
        if (this.passwordKvpField != null) {
            this.password_UIC.setText("");
            this.verifyPassword_UIC.setText("");
        }
        this.securityContent.setContainerEnabled(this.passwordMode_UIC.isSelected());
        if (this.passwordModeKvpField == null) {
            this.content.setContainerEnabled(false);
        }
    }

    boolean booleanValuePasswordMode(String string) {
        return !string.equalsIgnoreCase("always_accept");
    }

    String stringValuePasswordMode(boolean bl) {
        if (bl) {
            return "test_password";
        }
        return "always_accept";
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public boolean isChanged() {
        return this.viewSettingTree.hasChanged();
    }

    public void validateChanges(Collection collection) {
        if (!this.passwordMode_UIC.isSelected()) {
            return;
        }
        JTextField jTextField = null;
        String string = String.valueOf(this.password_UIC.getPassword());
        String string2 = String.valueOf(this.verifyPassword_UIC.getPassword());
        if (string.length() == 0 || string.length() > 15) {
            collection.add(new ValidationError("SecurityPasswordLengthError"));
            jTextField = this.password_UIC;
        } else if (!string.equals(string2)) {
            collection.add(new ValidationError("SecurityPasswordMismatchError"));
            jTextField = this.password_UIC;
        }
        String string3 = this.userName_UIC.getText();
        string3 = string3.trim();
        this.userNameKvpField.setStringValue(string3);
        if (string3.length() == 0 || string3.length() > 15) {
            collection.add(new ValidationError("SecurityUserLengthError"));
            jTextField = this.userName_UIC;
        }
        if (jTextField != null) {
            jTextField.requestFocus();
            jTextField.selectAll();
        }
        this.newPassword = string;
    }

    public void getChanges(KvpNode kvpNode, KvpNode kvpNode2) {
        kvpNode.merge(this.viewSettingTree, false);
    }

    public void commitChanges() {
        boolean bl = this.booleanValuePasswordMode(this.passwordModeKvpField.getStringValue());
        if (bl) {
            RciAuthenticator rciAuthenticator = RciAuthenticator.getInstance();
            rciAuthenticator.setNewCredentials(this.userNameKvpField.getStringValue(), this.newPassword);
            JOptionPane.showMessageDialog((Component)this.content, ConfigResource.getUiRbString((String)"SecurityCloseAfterChange"));
        }
        this.viewSettingTree.resetChanged();
    }

    public void cancelChanges() {
        this.refresh();
    }
}

