/*
 * Decompiled with CFR 0.152.
 */
package com.digi.config.ui;

import com.digi.config.util.ConfigResource;
import com.digi.config.util.SystemLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class BitMaskPanel
extends JPanel {
    Vector listeners = new Vector();
    ImageIcon[] states;
    String[] labels;
    BitButton[] buttons;
    int[] bits;
    String name;

    public BitMaskPanel(String string) {
        this.name = string;
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
    }

    public BitMaskPanel(String string, int[] nArray) {
        this(string);
        if (nArray != null) {
            this.setBits(nArray);
        }
    }

    public void setBits(int[] nArray) {
        this.removeAll();
        this.bits = nArray;
        this.states = new ImageIcon[3];
        this.labels = new String[3];
        this.states[0] = ConfigResource.getImageRbIcon((String)"DontCare");
        this.states[1] = ConfigResource.getImageRbIcon((String)"Asserted");
        this.states[2] = ConfigResource.getImageRbIcon((String)"UnAsserted");
        this.labels[0] = "X";
        this.labels[1] = "1";
        this.labels[2] = "0";
        this.buttons = new BitButton[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.buttons[i] = new BitButton(this.labels);
            this.buttons[i].setState(nArray[i]);
            String string = this.name + "Bit" + i + "Desc";
            String string2 = ConfigResource.getUiRbString((String)string);
            if (!string2.equals(string)) {
                this.buttons[i].setToolTipText(string2);
            }
            this.add(this.buttons[i]);
        }
    }

    public int[] getBits() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = this.buttons[i].getState();
        }
        return this.bits;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    protected void forwardActionEvent(ActionEvent actionEvent) {
        actionEvent.setSource(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ActionListener actionListener = (ActionListener)iterator.next();
            if (actionListener == null) continue;
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setContainerEnabled(this, bl);
    }

    public void setContainerEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
            if (!(componentArray[i] instanceof Container)) continue;
            this.setContainerEnabled((Container)componentArray[i], bl);
        }
    }

    public class BitButton
    extends JPanel {
        JButton button = new JButton();
        ImageIcon[] images;
        String[] text;
        int state = 0;
        int bitDepth = 0;

        private BitButton() {
            this.button.setFocusPainted(false);
            this.button.setOpaque(true);
            this.button.setBackground(Color.white);
            this.button.setMinimumSize(new Dimension(15, 15));
            this.button.setPreferredSize(new Dimension(15, 15));
            this.button.setBorder(BorderFactory.createRaisedBevelBorder());
            this.add(this.button);
        }

        public BitButton(String[] stringArray) {
            this();
            this.text = stringArray;
            this.bitDepth = this.text.length;
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ BitButton this$1;
                {
                    this.this$1 = bitButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.state = (this.this$1.state + 1) % this.this$1.text.length;
                    this.this$1.button.setText(this.this$1.text[this.this$1.state]);
                    BitButton.access$000(this.this$1).forwardActionEvent(actionEvent);
                }
            };
            this.button.addActionListener(actionListener);
            this.button.setText(this.text[this.state]);
        }

        public BitButton(ImageIcon[] imageIconArray) {
            this();
            this.images = imageIconArray;
            this.bitDepth = this.images.length;
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ BitButton this$1;
                {
                    this.this$1 = bitButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.state = (this.this$1.state + 1) % this.this$1.images.length;
                    this.this$1.button.setText(this.this$1.text[this.this$1.state]);
                    BitButton.access$000(this.this$1).forwardActionEvent(actionEvent);
                }
            };
            this.button.addActionListener(actionListener);
            this.button.setIcon(this.images[0]);
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            if (n < 0 || n >= this.bitDepth) {
                SystemLog.log((String)"GeneralException", (Serializable[])new Serializable[]{"BitButton.setState"}, (Throwable)new Exception("state out of range:" + n));
            } else {
                this.state = n;
                if (this.images != null) {
                    this.button.setIcon(this.images[n]);
                }
                if (this.text != null) {
                    this.button.setText(this.text[n]);
                }
            }
        }

        public void setToolTipText(String string) {
            this.button.setToolTipText(string);
        }

        static /* synthetic */ BitMaskPanel access$000(BitButton bitButton) {
            return bitButton.BitMaskPanel.this;
        }
    }
}

