{ --------------------------------------------- }
{  KIT-Builder  Program                         }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{
  Program slouzi pro zakladni seznameni se se
  strukturou programu v jazyku Kit-Basic
}

{ ---------------- Definice syst. konstant ----------------------------------- }
options
  PROGVER=1;                    {verze tohoto programu}
{ ---------------- Definice konstant ----------------------------------------- }
constant
  PRVNISMER=1;
  maxCITAC=2000;      {symbolicky nadefinovane konstanty}

{ ---------------- Definice HW-objektu TERM10 -------------------------------- }
configuration
  HWOBJ=TERM10, ADR=$2300, VAR=byte, LED=$0F;

{ ---------------- Definice symbolickych nazvu registru ---------------------- }
symbol
  CASOVAC =word;    {casovac pro synchronizaci citani}
  CITAC   =integer; {symbolick oznaen pro registr}
  SMER    =integer; {symbolick oznaen pro registr}
  PERIODA =WORD;    {perioda pro urcovani rychlosti pocitani}

{ ---------------- Definice jednotlivych obrazovek --------------------------- }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM10:0;
begin
  font 0;                                 {Nastavime font 0}
  position 10,10; print "Prvni program";  {Na pozici position vytiskneme text ...}
  font 1;                                 {Nastavime font 1}
  position 20,30; print "CITAC=",CITAC:6; {Vypis registru CITAC na obrazovku}
  position 20,40; print "SMER= ",SMER:6;  {Vypis registru SMER na obrazovku}
  position 20,50; print "PERIODA=",PERIODA:4," x10ms"; {Vypis registru PERIODA
                                                        na obrazovku}
  position 20,100; print "Napoveda-stisknete F1";

  onkey           {definujeme reakci na stisk klavesy}
    '+':SMER:=1;  {po stisku klavesy "+" resp. "-" zmena hodnoty registru SMER}
    '-':SMER:=-1;
    'P':TERM10_SCRNO:=1;
    '0':CITAC:=0;
  end;
  help  {obrazovka napovedy, objevi se po stisku F1}
    position 10 ,10; print "NPOVDA";
    position 10 ,40; print "Citac pocita podle nastaveni";
    position 10 ,50; print "klavesami +/- nahoru nebo dolu.";
    position 10 ,60; print "Editace periody klavesou P.";
    position 10 ,70; print "Vynulovani klavesou 0.";
    position 10, 90; print "Konec na PC - AltX";
end;

{ ------------------------------------ }
{ Popis obrazovky c.1 terminalu TERM10 }
terminal TERM10:1;
begin
  font 0;
  position 10,10; print "Prvni program";
  font 1;
  position 20,30; print "CITAC=",CITAC:6;{vypis registru CITAC na obrazovku}
  position 20,40; print "SMER= ",SMER:6; {vypis registru SMER na obrazovku}
  position 20,50; print "PERIODA=     x10ms";
  font 0;
  position 68,50; edit PERIODA:3,5,500; {editace hodnoty periody}
  font 1;
  position 20,100; print "Napoveda-stisknete F1";

  help  {obrazovka napovedy, objevi se po stisku F1}
    position 10 ,10; print "NPOVDA";
    position 10 ,40; print "Editace periody citani";
    position 10 ,50; print "Potvrdte klavesou ENTER";
    position 10, 90; print "Zruste klavesou ESC";
end;

{---------------- Definice procedury, kter se provede 1x po RESETu ---------}
procedure INIT;
begin
  SMER:=PRVNISMER;          {po RESETu ma SMER hodnotu +1}
  Perioda=100;              {nastaveni pocatecni hodnoty periody}
  TimerOn(Casovac,per10ms); {Spusteni casovace}
end;

{---------------- Definice hlavniho algoritmu, provadeneho cyklicky ----------}
procedure MAIN;
begin
  if CASOVAC>=Perioda then        {cekam az je napoctena hodnota periody a pak ...}
  begin
    Casovac:=Casovac-Perioda;     {snizeni casovace o periodu}
    TERM10_Led:=not TERM10_Led;   {inverze LED-diod na terminalu}
    CITAC:=CITAC+SMER;            {citani citace}
  end;
end;
{---------------- KONEC --------------}