      {-----------------------------------------}
      {                                         }
      {  Projekt  TecoSl.PRG  V1.00             }
      {                                         }
      {                              28.12.2001 }
      {                                         }
      {-----------------------------------------}

{ Program na testovani komunikacniho protokolu TECOM s automaty TECO.
  Fyzicky se zpravy prenaseji po seriove lince RS485 (2-drat),
  kde PLC Tecomat je Master a Term10 je Slave.
  Program provadi zachytavani zprav z nadrizene stanice a odpovidaji podle
  jejich pozadavku a nastavenych parametru.
  V PLC Tecomat je nahran program MAS_TECO.950, ktery obsluhuje 3 podrizene
  stanice s adresami 1,2,3 - cte a zapisuje registry dle vyplnene tabulky.

  V programu KB je nadefinovano pole 20-ti R registru (pole RegR), ktere
  jsou urceny pro zapis a spodnich 10 je navic i pro cteni.
  Program KB inicializuje spodnich 10 na hodnoty $11,$22...$AA a zbyle
  necha na $00.
  Komunikace v Tecomatu cyklicky cte spodnich 10 registru, kopiruje si je
  do sveho bufferu, ktery pote zapise do hornich 10 registru v KB (RegR[10..19]).
  To znamena ze pri uspesne komunikaci by mel byt stejny obsah spodnich
  i hornich 10-ti registru v KB (RegR[0..9] = RegR[10..19]).
}

options
  ProgVer = 1; { verze programu }

CONSTANT
  ProjectName="TecoSl.PRG";

{============== komunikace Tecomat-Slave =================}
constant
{ parametry komunikacni linky }
  {Term10 - realne prostredi pro KitV40 a Term10 }
   cTC_ParamStr   = "NOD=1 NAM=COM ADD=$2310 IRQ=3 BD=19200 BIT=8 STO=2 PAR=E LRB=2000 ";
  {PC     - simulace na PC }
{   cTC_ParamStr   = "NOD=1 NAM=COM COM=1 IRQ=4 BD=19200 BIT=8 STO=2 PAR=E LRB=1000";
   { vyznam jednotlivych parametru - viz komunikacni knihovny }

constant
{ konstanty stavu komunikacniho kanalu }
  cCh_None       = 0; { kanal zavren }
  cCh_Open       = 1; { kanal se otvira }
  cCh_Connect    = 2; { kanal se otvira }
  cCh_Rec        = 3; { kanal otevren - ceka se na prijem zpravy }
  cCh_SendReply  = 4; { posila se odpoved }
  cCh_DisConnect = 5; { kanal se zavira }
  cCh_Close      = 6; { kanal se zavira }

symbol
{ tabulka s informacemi o rozlozeni jednotlivych registru v pameti KB }
  TableReg = Word:96;       { definice tabulky v pameti - nasleduje struktura polozek tabulky }
    BgI_X_Rd = TableReg[ 0]; { index na pocatek v dat.oblasti KB pro cteni X registru }
    Poc_X_Rd = TableReg[ 2]; { delka dat.oblasti KB pro cteni X registru }
    BgI_Y_Rd = TableReg[ 4]; { index na pocatek v dat.oblasti KB pro cteni Y registru }
    Poc_Y_Rd = TableReg[ 6]; { delka dat.oblasti KB pro cteni Y registru }
    BgI_S_Rd = TableReg[ 8]; { index na pocatek v dat.oblasti KB pro cteni S registru }
    Poc_S_Rd = TableReg[10]; { delka dat.oblasti KB pro cteni S registru }
    BgI_R_Rd = TableReg[12]; { index na pocatek v dat.oblasti KB pro cteni R registru }
    Poc_R_Rd = TableReg[14]; { delka dat.oblasti KB pro cteni R registru }
    BgI_1_Rd = TableReg[16]; { index na pocatek v dat.oblasti KB pro cteni registru z 1.DataBoxu }
    Poc_1_Rd = TableReg[18]; { delka dat.oblasti KB pro cteni registru z 1.DataBoxu }
    BgI_2_Rd = TableReg[20]; { index na pocatek v dat.oblasti KB pro cteni registru z 2.DataBoxu }
    Poc_2_Rd = TableReg[22]; { delka dat.oblasti KB pro cteni registru z 2.DataBoxu }
    BgI_3_Rd = TableReg[24]; { index na pocatek v dat.oblasti KB pro cteni registru z 3.DataBoxu }
    Poc_3_Rd = TableReg[26]; { delka dat.oblasti KB pro cteni registru z 3.DataBoxu }
    BgI_4_Rd = TableReg[28]; { index na pocatek v dat.oblasti KB pro cteni registru z 4.DataBoxu }
    Poc_4_Rd = TableReg[30]; { delka dat.oblasti KB pro cteni registru z 4.DataBoxu }
    BgI_5_Rd = TableReg[32]; { index na pocatek v dat.oblasti KB pro cteni registru z 5.DataBoxu }
    Poc_5_Rd = TableReg[34]; { delka dat.oblasti KB pro cteni registru z 5.DataBoxu }
    BgI_6_Rd = TableReg[36]; { index na pocatek v dat.oblasti KB pro cteni registru z 6.DataBoxu }
    Poc_6_Rd = TableReg[38]; { delka dat.oblasti KB pro cteni registru z 6.DataBoxu }
    BgI_7_Rd = TableReg[40]; { index na pocatek v dat.oblasti KB pro cteni registru z 7.DataBoxu }
    Poc_7_Rd = TableReg[42]; { delka dat.oblasti KB pro cteni registru z 7.DataBoxu }
    BgI_8_Rd = TableReg[44]; { index na pocatek v dat.oblasti KB pro cteni registru z 8.DataBoxu }
    Poc_8_Rd = TableReg[46]; { delka dat.oblasti KB pro cteni registru z 8.DataBoxu }
    BgI_X_Wr = TableReg[48]; { index na pocatek v dat.oblasti KB pro zapis X registru }
    Poc_X_Wr = TableReg[50]; { delka dat.oblasti KB pro zapis X registru }
    BgI_Y_Wr = TableReg[52]; { index na pocatek v dat.oblasti KB pro zapis Y registru }
    Poc_Y_Wr = TableReg[54]; { delka dat.oblasti KB pro zapis Y registru }
    BgI_S_Wr = TableReg[56]; { index na pocatek v dat.oblasti KB pro zapis S registru }
    Poc_S_Wr = TableReg[58]; { delka dat.oblasti KB pro zapis S registru }
    BgI_R_Wr = TableReg[60]; { index na pocatek v dat.oblasti KB pro zapis R registru }
    Poc_R_Wr = TableReg[62]; { delka dat.oblasti KB pro zapis R registru }
    BgI_1_Wr = TableReg[64]; { index na pocatek v dat.oblasti KB pro zapis registru z 1.DataBoxu }
    Poc_1_Wr = TableReg[66]; { delka dat.oblasti KB pro zapis registru z 1.DataBoxu }
    BgI_2_Wr = TableReg[68]; { index na pocatek v dat.oblasti KB pro zapis registru z 2.DataBoxu }
    Poc_2_Wr = TableReg[70]; { delka dat.oblasti KB pro zapis registru z 2.DataBoxu }
    BgI_3_Wr = TableReg[72]; { index na pocatek v dat.oblasti KB pro zapis registru z 3.DataBoxu }
    Poc_3_Wr = TableReg[74]; { delka dat.oblasti KB pro zapis registru z 3.DataBoxu }
    BgI_4_Wr = TableReg[76]; { index na pocatek v dat.oblasti KB pro zapis registru z 4.DataBoxu }
    Poc_4_Wr = TableReg[78]; { delka dat.oblasti KB pro zapis registru z 4.DataBoxu }
    BgI_5_Wr = TableReg[80]; { index na pocatek v dat.oblasti KB pro zapis registru z 5.DataBoxu }
    Poc_5_Wr = TableReg[82]; { delka dat.oblasti KB pro zapis registru z 5.DataBoxu }
    BgI_6_Wr = TableReg[84]; { index na pocatek v dat.oblasti KB pro zapis registru z 6.DataBoxu }
    Poc_6_Wr = TableReg[86]; { delka dat.oblasti KB pro zapis registru z 6.DataBoxu }
    BgI_7_Wr = TableReg[88]; { index na pocatek v dat.oblasti KB pro zapis registru z 7.DataBoxu }
    Poc_7_Wr = TableReg[90]; { delka dat.oblasti KB pro zapis registru z 7.DataBoxu }
    BgI_8_Wr = TableReg[92]; { index na pocatek v dat.oblasti KB pro zapis registru z 8.DataBoxu }
    Poc_8_Wr = TableReg[94]; { delka dat.oblasti KB pro zapis registru z 8.DataBoxu }
  PocTableReg = Byte(TableReg)[0]; { pocatek tabulky Table Reg }

 { tabulka se statusy komunikace, poctem prijatych zprav }
  TabStsCom = Word:28{6};
    FlgsRead       = byte(TabStsCom)[0]; { priznaky prijeti zprav pro cteni }
      FlReadRegX   = FlgsRead.7;    { priznak prijeti zpravy na cteni X registru }
      FlReadRegY   = FlgsRead.6;    { priznak prijeti zpravy na cteni Y registru }
      FlReadRegS   = FlgsRead.5;    { priznak prijeti zpravy na cteni S registru }
      FlReadRegR   = FlgsRead.4;    { priznak prijeti zpravy na cteni R registru }
      FlReadDBox   = FlgsRead.3;    { priznak prijeti zpravy na cteni DataBoxu }
    FlgsWrite      = byte(TabStsCom)[1]; { priznaky prijeti zprav pro zapis }
      FlWriteRegX  = FlgsWrite.7;   { priznak prijeti zpravy pro zapis X registru }
      FlWriteRegY  = FlgsWrite.6;   { priznak prijeti zpravy pro zapis Y registru }
      FlWriteRegS  = FlgsWrite.5;   { priznak prijeti zpravy pro zapis S registru }
      FlWriteRegR  = FlgsWrite.4;   { priznak prijeti zpravy pro zapis R registru }
      FlWriteDBox  = FlgsWrite.3;   { priznak prijeti zpravy pro zapis DataBoxu }
    ChnState       = byte(TabStsCom)[2];  { stav komunikace }
    ChnResult      = word(TabStsCom)[4];  { status (chyby) komunikace }
    ChnCtConnect   = word(TabStsCom)[6];  { pocet prijatych zprav navazani spojeni }
    ChnCtReadX     = word(TabStsCom)[8];  { pocet prijatych zprav pro cteni X registru }
    ChnCtReadY     = word(TabStsCom)[10]; { pocet prijatych zprav pro cteni Y registru }
    ChnCtReadS     = word(TabStsCom)[12]; { pocet prijatych zprav pro cteni S registru }
    ChnCtReadR     = word(TabStsCom)[14]; { pocet prijatych zprav pro cteni R registru }
    ChnCtReadDBox  = word(TabStsCom)[16]; { pocet prijatych zprav pro cteni z DataBoxu }
    ChnCtWriteX    = word(TabStsCom)[18]; { pocet prijatych zprav pro zapis X registru }
    ChnCtWriteY    = word(TabStsCom)[20]; { pocet prijatych zprav pro zapis Y registru }
    ChnCtWriteS    = word(TabStsCom)[22]; { pocet prijatych zprav pro zapis S registru }
    ChnCtWriteR    = word(TabStsCom)[24]; { pocet prijatych zprav pro zapis R registru }
    ChnCtWriteDBox = word(TabStsCom)[26]; { pocet prijatych zprav pro zapis do DataBoxu }

  PocTabStsCom = Byte (TabStsCom)[0]; { pocatek tabulky TabStsCom }

symbol
 { pole registru pro komunikaci s nadrizenym Tecomatem }
  RegR = byte:200; { vlastni pole R registru }

{================== terminal Term10 =================}
{ konfigurace terminalu Term10 }
configuration
  HwObj  = TERM10, { nazev HW objektu }
    Name = TERM,   { uzivatelske jmeno pouzivane dale v programu }
    Adr  = $2300,  { adresa terminalu v IO prostoru }
    Var  = Byte;

{ konstanty fontu, bitmap a obrazovek terminalu }
constant
 { konstanty fontu }
  cFnt_8x8c   = 0; { font 8x8_cestina }
  cFnt_6x8c   = 1; { font 6x8_cestina }
  cFnt_16x32c = 2; { font 16x24_cestina }
 { konstanty bitmap }
  cBmp_Logo   = 0; { bitmapa s logem fy.SofCon }
  cBmp_Clear  = 1; { bitmapa prazdne stranky }
 { konstanty obrazovek terminalu }
  cTer_Uvod   = 0; { uvodni obrazovka s logem firmy SofCon }
  cTer_Main   = 1; { hlavni obrazovka }
  cTer_RegR   = 2; { obrazovka R registru } 

{ pomocne promenne }
symbol
  PomI     = byte;          { pomocna pro FOR cykly }
  PomS     = string:200;    { pomocny retezec }
  PocPomS  = Byte(PomS[0]); { pocatek pomocneho retezce PomS }

{ definice uzivatelskych procedur }
#define InitTecoSlave Proc3 { inicializace komunikace Tecomat-Slave }
#define DoneTecoSlave Proc4 { zruseni komunikace Tecomat-Slave
                              - v realnem programu asi malo vyuzitelna
                                procedura, leda ze by se menilo}

{ ------------------------------------ }
{ Nasledujici procedura se vykona vzdy po RESETu }
procedure INIT;
begin
 { inicializace a nastaveni Teco Automatu a jeho promennych
   a implicitni nastaveni zaznamu Tecomatu }
  PomS=cTC_ParamStr;

  {prvnich deset R registru bude pro cteni - nadrizeny Tecomat se na ne odkazuje jako na R0 az R9}
  BgI_R_Rd = Addr(RegR);
  Poc_R_Rd = 200;
  {dalsich deset R registru bude pro zapis - nadrizeny Tecomat se na ne odkazuje jako na R10 az R19}
  BgI_R_Wr = Addr(RegR);
  Poc_R_Wr = 200;

 {inicializace hodnot registru}
  for PomI:=0 to 9 do { R registry pro cteni naplnit hodnotami $11,$22..$AA }
    RegR[PomI]:=$11*PomI+$11;
  { R registry pro zapis jsou implicitne nastaveny na $00}

 {spusteni Slave komunikace}
  InitTecoSlave(PocPomS,PocTableReg,PocTabStsCom);
end;

{ ------------------------------------ }
{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
end;{********* KONEC pro Main ***********}
#include TecoSl.PRI { Obrazovky terminalu generovane programem KbdLCD }




{ ========================================================================== }
(*
terminal TERM : cTer_Uvod;
   { uvodni obrazovka s logem firmy SofCon }
begin
  BitMap cBmp_Logo;  { bitmapa c.0 - s logem SofCon }
  Wait 1,cTer_Main; { po jedne sekunde se automaticky prejde na obrazovku c.1 }
  OnKey              { nebo po stisku nektere z klaves se prejde na obrazovku c.1 }
    zESC,zCR,
    zUp, zDn : TERM_ScrNo:=cTer_Main;
  end;
end;

{ ------------------------------------ }
terminal TERM : cTer_Main;
   { obrazovka s grafickym zobrazenim namerenych hodnot }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 10,7; Print "Komunikace TECO - TERM10";

  Font cFnt_6x8c;
  Position 10,25; Print "Stav komunikace: ";
  case ChnState of
    cCh_None       : Print "Closed";
    cCh_Open       : Print "Openning";
    cCh_Connect    : Print "Connecting";
    cCh_Rec        : Print "Connect - Receive";
    cCh_SendReply  : Print "Sending Reply";
    cCh_DisConnect : Print "DisConnecting";
    cCh_Close      : Print "Closing";
  end;
  Position 10,37; Print "Chyba kanlu: $",hex ChnResult;

  Position 10,50; Print "Poet pijatch zprv:";
  Position 60,60; Print "ten   zpis";
  Position 10, 70; Print "reg X:",ChnCtReadX   :6," ",ChnCtWriteX   :6;
  Position 10, 80; Print "reg Y:",ChnCtReadY   :6," ",ChnCtWriteY   :6;
  Position 10, 90; Print "reg S:",ChnCtReadS   :6," ",ChnCtWriteS   :6;
  Position 10,100; Print "reg R:",ChnCtReadR   :6," ",ChnCtWriteR   :6;
  Position 10,110; Print "DBox :",ChnCtReadDBox:6," ",ChnCtWriteDBox:6;

  Position 150,37; Print "Msg Conn: ",ChnCtConnect;

  OnKey { pozadovane akce na stisk danych klaves }
    zESC:TERM_ScrNo:=cTer_Main;
    zUp,
    zDn :TERM_ScrNo:=cTer_RegR;
  end;

  Help { definice stranky napovedy }
   Font cFnt_8x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,30; Print "Ukazka komunikace mezi";
   Position 10,40; Print "automatem TECO a terminalem TERM10.";
   Position 10,60; Print "Automat   TECO  - master";
   Position 10,70; Print "Terminal TERM10 - slave ";

end;

{ ------------------------------------ }
terminal TERM : cTer_RegR;
   { obrazovka se zobrazenim hodnot R registru }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 35,7; Print "Hodnoty R registr";

  Font cFnt_6x8c;
  Position  5,25; Print "Poet pijatch zprv";
  Position 60,35; Print "ten   zpis";
  Position 10,45; Print "reg R:",ChnCtReadR:6," ",ChnCtWriteR:6;

  Position 5,60; Print "Rd";
  Position 20,60;
  Print "$",hex RegR[ 0]," $",hex RegR[ 1]," $",hex RegR[ 2]," $",hex RegR[ 3]," $",hex RegR[ 4];
  Position 20,70;
  Print "$",hex RegR[ 5]," $",hex RegR[ 6]," $",hex RegR[ 7]," $",hex RegR[ 8]," $",hex RegR[ 9];
  Position 5,80; Print "Wr";
  Position 20,80;
  Print "$",hex RegR[10]," $",hex RegR[11]," $",hex RegR[12]," $",hex RegR[13]," $",hex RegR[14];
  Position 20,90;
  Print "$",hex RegR[15]," $",hex RegR[16]," $",hex RegR[17]," $",hex RegR[18]," $",hex RegR[19];

  OnKey { pozadovane akce na stisk danych klaves }
    zESC:TERM_ScrNo:=cTer_Main;
    zUp,
    zDn :TERM_ScrNo:=cTer_Main;
  end;

  Help { definice stranky napovedy }
   Font cFnt_8x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
end;
*)
{ ------------------------------------ }
