{ --------------------------------------------- }
{  program DTECOIO                  08.03.1999  }
{  KIT-Builder                                  }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{ Program na testovani komunikacniho protokolu TECOM, pro komunikaci
  s PLC TC600. Fyzicky se zpravy prenaseji ze serioveho portu RS485 Term10
  do PLC Tecomat, kde Term10 je Master a PLC Tecomat je Slave.
  Program provadi cyklicke cteni a zapis hodnot do registru Tecomatu
  s naslednym zpracovanim a vizualizaci ctenych hodnot.
  V PLC Tecomat je nahran program TECO_DIO.950, ktery neustale kopiruje hodnotu
  v uzivatelskem registru R0 na digitalni vystupu a neustale cte digitalni
  vstupy, ktere pote kopiruje do uzivatelskeho registru R1.
}
{ V komentarich se vyskytuji zkracene symboly,
  napr: "/4" znamena "delitelno ctyrma",
        "[10ms]" znamena, ze udaj je v desitkach milisekund.
}
{ Tendo demostracni program byl napsan pro Kit-Builder V02.E3 24/12/1998
}

options
  ProgVer = 1; { verze programu }

{ nasledujici konstanty a definice je potrebne definovat pred prilinkovanim
  include soubor TECOM_1.PRI definici "#include TECOM_1.PRI" (viz nize) }
#define
  deklar symbol { misto klicoveho slova "symbol" se smi pouzivat tez slovo "deklar" }
    { tato definice je pro rozdeleni deklarace promennych a symbolicke
      pojmenovani jiz deklarovanych promennych : deklar = deklarace,
      symbol = symbolicke nazvy}
constant
 { konstanty nutne pro automat Tecomatu }
  cTC_MaxPLC     = 1;   { pocet obsluhovanych a maximalne pripojenych PLC stanic }
                        { Pozn: musi byt definovan stejny (nebo vetsi) pocet
                          zaznamu pro jednotlive Tecomaty }
  cTC_SndMaxTOut = 50;  { maximalni timeout pri vysilani [10ms] }
  cTC_RecMaxTOut = 100; { maximalni timeout pri prijmu odpovedi [10ms] }
  cTC_TryConnect = 10;  { perioda pro opakovani testu pripojenych PLC [s] zpravou Connect }
  cTC_SizeRead   = 4;   { velikost bufferu pro cteni registru z PLC
                          1. musi byt /4
                          2. musi byt v intervalu 0 az 244 }
  cTC_SizeWrite  = 4;   { velikost bufferu pro zapis registru do PLC
                          1. musi byt /4
                          2. musi byt v intervalu 0 az 244 }
 { retezcova konstanta s parametry pro komunikaci }
  { zvoli se jedna z nasledujicich variant podle pouzite cilove platformy }
  {Term10 - realne prostredi pro KitV40 a Term10 }
   cTC_ParamStr   = "NAM=TECOM MAS=MASTER NOD=100 LSB=250 NAM=COM ADD=$2310 IRQ=4 BD=19200 BIT=8 STO=2 PAR=E LRB=1000 REC=OFF2 ";
  {PC     - simulace na PC }
{   cTC_ParamStr   = "NAM=TECOM MAS=MASTER NOD=100 LSB=250 NAM=COM COM=3     IRQ=5 BD=19200 BIT=8 STO=2 PAR=E LRB=1000 REC=OFF2 ";
   { vyznam jednotlivych parametru - viz komunikacni knihovny }

#include TECOM_1.PRI; { prilinkovani obsluhy PLC Tecomatu }

{ symbolicke nazvy registru PLC Tecomatu }
symbol
 { symbolicke nazvy ctenych registru z Tecomatu }
  TC_ROutVal = byte(TC1_Addr)[cTC_Read_Data + 0];
     { aktualni hodnota IO vystupu prectena z Tecomatu }
  TC_RInVal  = byte(TC1_Addr)[cTC_Read_Data + 1];
     { aktualni hodnota IO vstupu prectena z Tecomatu }
 { symbolicke nazvy zapisovanych registru do Tecomatu }
  TC_WOutVal = byte(TC1_Addr)[cTC_Write_Data+ 0];
     { pozadovana hodnota IO vystupu zapisovana do Tecomatu }
deklar
  TC_WrCount = longint; { pocitadlo prijmutych zprav pro periodu vzorkovani simulace vystupu
                          (aby se vystupy aktualizovaly v zavislosti na rychlosti cteni registru z PLC) }

{ konfigurace terminalu Term10 }
configuration
  HwObj  = TERM10, { nazev HW objektu }
    Name = TERM,   { uzivatelske jmeno pouzivane dale v programu }
    Adr  = $2300,  { adresa terminalu v IO prostoru }
    Var  = Byte;

{ konstanty fontu, bitmap a obrazovek terminalu }
constant
 { konstanty fontu }
  cFnt_8x8c   = 0; { font 8x8_cestina }
  cFnt_6x8c   = 1; { font 6x8_cestina }
  cFnt_16x32c = 2; { font 16x24_cestina }
 { konstanty bitmap }
  cBmp_Logo   = 0; { bitmapa s logem fy.SofCon }
  cBmp_Clear  = 1; { bitmapa prazdne stranky }
 { konstanty obrazovek terminalu }
  cTer_Uvod   = 0; { uvodni obrazovka s logem firmy SofCon }
  cTer_Main   = 1; { obrazovka se zobrazenim namerenych hodnot z PLC }
  cTer_EditTC = 2; { obrazovka pro editaci pozadovane hodnoty vystupu }
  cTer_SysCom = 3; { systemova obrazovka s komunikaci }

{ pomocne promenne }
deklar
  Pom_SimPoz = word; { pro simulaci zmeny pozadovane hodnoty }
  Pom_EditB  = byte; { pro editaci bytoveho parametru }

{ ------------------------------------ }
{ Nasledujici procedura se vykona vzdy po RESETu }
procedure INIT;
begin
 { inicializace a nastaveni Teco Automatu a jeho promennych
   a implicitni nastaveni zaznamu Tecomatu }
  TecoInit;
 { pocatecni nastaveni pro cteni a zapis registru z/do PLC Tecomat }
  TC_DNode       [TC1_Offs] := 1;        { cislo stanice PLC v siti }
  TC_SWritePerm  [TC1_Offs] := 0;        { nastaveni vysilani zpravy pro zapis registru na priznak }
  TC_FlSWrite    [TC1_Offs] := 1;        { poprve vyslat zpravu pro zapis registru }
  TC_SRead_Typ   [TC1_Offs] := cTC_RegR; { typ ctenych registru }
  TC_SRead_Frst  [TC1_Offs] := 0;        { cislo prvniho cteneho registru }
  TC_SRead_Len   [TC1_Offs] := 2;        { pocet ctenych registru (bytu) z PLC }
  TC_SWrite_Typ  [TC1_Offs] := cTC_RegR; { typ zapisovanych registru }
  TC_SWrite_Frst [TC1_Offs] := 0;        { cislo prvniho zapisovaneho registru }
  TC_SWrite_Len  [TC1_Offs] := 1;        { pocet zapisovanych registru (bytu) do PLC
                                           Nesmi byt vetsi nez konstanta cTC_SizeWrite! }
  TC_ROutVal                := 0;        { pocatecni nastaveni aktualni hodnoty ctenych IO vystupu }
  TC_RInVal                 := 0;        { pocatecni nastaveni aktualni hodnoty ctenych IO vstupu }
  TC_WOutVal                := $44;      { pocatecni nastaveni hodnoty zapisovanych IO vystupu }
 { uprava nekterych polozek zaznamu Tecomatu podle uzivatelskeho nastaveni }
  TecoReInit;
end;

{ ------------------------------------ }
procedure SimOutVal;
  { simulace zmeny IO }
begin
  if (TERM_ScrNo<>cTer_EditTC            ) and  { nedituje-li se zrovna nektera konstanta ovlivnujici simulaci }
     (TC_WrCount<>TC_RWriteCt[TC_ViewAdr]) then
  begin
    TC_WrCount:=TC_RWriteCt[TC_ViewAdr];
    TC_WOutVal:=(TC_WOutVal shr 7) or (TC_WOutVal shl 1); { rol }
    TC_FlSWrite[TC_ViewAdr]:=1; { prikaz provedeni zapisu }
  end;
end;

{ ------------------------------------ }
{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  SimOutVal;   { simulace zmeny IO }
  TecoAutomat; { automat Tecomatu }
end;

{ ========================================================================== }
terminal TERM : cTer_Uvod;
   { uvodni obrazovka s logem firmy SofCon }
begin
  BitMap cBmp_Logo;  { bitmapa c.0 - s logem SofCon }
  Wait 1,cTer_Main;  { po jedne sekunde se automaticky prejde na obrazovku c.1 }
  OnKey              { nebo po stisku nektere z klaves se prejde na obrazovku c.1 }
    zESC,zCR,
    zUp, zDn : TERM_ScrNo:=cTer_Main;
  end;
end;

{ ------------------------------------ }
terminal TERM : cTer_Main;
   { obrazovka s grafickym zobrazenim namerenych hodnot }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 25,7;
   Print "Vizualizace meen TC600";

  Font cFnt_6x8c;
  { vypsani, zda je ci neni navazana komunikace s PLC Tecomat }
  Position 20,25; Print "Status komunikace: ";
   case TC_FlConnect[TC_ViewAdr] of
     0:   Print "Nekomunikuji";
     else Print "Komunikuji";
   end;

  { vypis hodnot ctenych dat }
   Position 10, 50; Print "Read Inputs";
   Position 15, 65; Print "Data: ",bin TC_RInVal;
  { vypis hodnot zapisovanych dat }
   Position 10, 80; Print "Write Outputs - <E>dit";
   Position 15, 95; Print "Data: ",bin TC_ROutVal;

  OnKey { pozadovane akce na stisk danych klaves }
    zESC:TERM_ScrNo:=cTer_Main;
    zUp,
    zDn :TERM_ScrNo:=cTer_Main;
    'S' :TERM_ScrNo:=cTer_SysCom;
    'E' :begin
           Pom_EditB :=TC_WOutVal;
           TERM_ScrNo:=cTer_EditTC;
         end;
  end;

  Help { definice stranky napovedy }
   Font cFnt_8x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,25; Print "Vizualizace dat PLC TC600 Tecomat";
   Position 10,35; Print "pomoc komunikanho protokolu Tecomat";
   Position 10,50; Print "<E> - editace rotujc hodnoty";
   Position 10,60; Print "<S> - systmov obrazovka komunikace";
end;

{ ------------------------------------ }
terminal TERM : cTer_EditTC;
   { obrazovka pro editaci simulovane hodnoty }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  { vypis hlavicky }
   Position 10,7;
    Print "Editace rotujici hodnoty Teco";
  { vypis vodiciho textu }
   Rect rel,85,46,68,28;
   Font cFnt_6x8c;
   Position 7,95;
    Print "Zadej hex.slo v rozsahu 1h a FEh";
  { nastaveni forntu a pozice pro editaci }
   Font cFnt_16x32c;
   Position 160,46; Print "h";
   Position 90,45;
  { vlastni editace }
   Edit hex Pom_EditB:2,$1,$FE;

  EditEnter { definice akci pro ukonceni editace klavesou <Enter> }
  begin
    TC_WOutVal :=Pom_EditB; { aktualizace zeditovane promenne }
    TC_FlSWrite:=1;         { aby se provedl zapis do PLC }
  end;

  Help
   Font cFnt_8x8c;
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,25; Print "Nastaveni rotujici hodnoty.";
   Position 10,37; Print "Tato hodnota se bude periodicky menit";
   Position 10,49; Print "bitovou rotaci vlevo a vysledna hodnota";
   Position 10,61; Print "se bude po seriove lince zapisovat do";
   Position 10,73; Print "vstupnich registru daneho PLC";
end;

{ ------------------------------------ }
terminal TERM : cTer_SysCom;
   { ladici obrazovka }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 20,7;
   Print "Komunikace s PLC Teco";

  Font cFnt_6x8c;
  Position 120,25;
   Print "AktPLC: ",TC_ComTeco; { vypis cisla Tecomatu se kterym se prave komunikuje }
  Position 10,25;
   case ComTECO_Ctrl of { vypise aktualni stav automatu komunikacniho kanalu }
     $00 : Print "Kanl Open/Close";
     $01 : Print "Kanl Off";
     $02 : Print "Kanl On";
     $04 : Print "Kanl Err";
     $10,
     $12 : Print "Kanl Send";
     $20,
     $22 : Print "Kanl SendErr";
     $40,
     $42 : Print "Kanl Rec";
     $80,
     $82 : Print "Kanl RecErr";
     else  Print "Kanl v jinm stavu ",ComTECO_Ctrl;
   end;
  Position 10,35;
   case TC_A of { vypise aktualni stav automatu Tecomatu }
     cTC_A_None,
     cTC_A_ReadBeg,
     cTC_A_WriteBeg   : Print "Automat  None";
     cTC_A_BegConn    : Print "Automat  Beg Connect";
     cTC_A_ContConn   : Print "Automat  Connecting";
     cTC_A_Read       : Print "Automat  Read  Reg";
     cTC_A_Write      : Print "Automat  Write Reg";
     cTC_A_WasRW      : Print "Automat  To Next PLC";
     else               Print "Automat  v jinm stavu";
   end;
  Position 10,45;
   case TC_RWA of { vypise aktualni stav RW automatu }
     cTC_RW_None      : Print "RW Autom None";
     cTC_RW_Rec       : Print "RW Autom Receiving";
     cTC_RW_WaitSend  : Print "RW Autom Sending";
     cTC_RW_SndConnect: Print "RW Autom Send_Connect";
     cTC_RW_SndReadN  : Print "RW Autom Send_ReadN";
     cTC_RW_SndWriteN : Print "RW Autom Send_WriteN";
     else               Print "RW Autom v jinm stavu";
   end;
  Position 10,55;
   case TC_Result of { vypise aktualni hodnotu vysledku RW automatu }
     cTC_Res_Ok       : Print "Result : Ok";
     cTC_Res_ErrInit  : Print "Result : Chyba pi ComOn";
     cTC_Res_SndTOut  : Print "Result : TimeOut pi vysln";
     cTC_Res_SndErr   : Print "Result : Chyba pi vysln";
     cTC_Res_RecTOut  : Print "Result : TimeOut pi pjmu";
     cTC_Res_RecErr   : Print "Result : Chyba pi pjmu";
     cTC_Res_BadAnsw  : Print "Result : Pila jin odpov";
     else               Print "Result : neznm";
   end;
  Position 10,65;
   Print "TOutCt : ",TC_TOutCt,"0ms"; { citac pro TimeOut pri cteni odpovedi z Teca }
  Position 10,75;
   Print "Ct_SndRead : ",TC_SReadCt[TC_ViewAdr];
  Position 10,85;
   Print "Ct_RecRead : ",TC_RReadCt[TC_ViewAdr];
  Position 130,75;
   Print "Ct_SndWrite : ",TC_SWriteCt[TC_ViewAdr];
  Position 130,85;
   Print "Ct_RecWrite : ",TC_RWriteCt[TC_ViewAdr];

  Position 10,95;
   case TC_FlConnect[TC_ViewAdr] of
     0 :  Print "PLC Not Connect";
     else Print "PLC Connect";
   end;

  Position 10,105;
   Print "Readed ",TC_SRead_Len[TC_ViewAdr];
   case TC_SRead_Typ[TC_ViewAdr] of
     cTC_RegR : Print " Reg R ";
     cTC_RegX : Print " Reg X ";
     cTC_RegY : Print " Reg Y ";
     cTC_RegS : Print " Reg S ";
   end;
   Print "from $",hex TC_SRead_RegH[TC_ViewAdr], hex TC_SRead_RegL[TC_ViewAdr];

  Position 10,115;
   Print "Writed ",TC_SWrite_Len[TC_ViewAdr];
   case TC_SWrite_Typ[TC_ViewAdr] of
     cTC_RegR : Print " Reg R ";
     cTC_RegX : Print " Reg X ";
     cTC_RegY : Print " Reg Y ";
     cTC_RegS : Print " Reg S ";
   end;
   Print "to $",hex TC_SWrite_RegH[TC_ViewAdr], hex TC_SWrite_RegL[TC_ViewAdr];

  OnKey
    zESC:TERM_ScrNo:=cTer_Main;
    zDn,
    zUp :TERM_ScrNo:=cTer_Main;
  end;

  Help
    Position 20,20; Print "Obr. se zkl. parametry";
    Position 20,35; Print "komunikace s PLC Tecomat";
end;

{ ------------------------------------ }
