{ --------------------------------------------- }
{  program DTECOIO2                 30.06.2000  }
{  KIT-Builder                                  }
{                                               }
{  (c) SofCon 2000                              }
{---------------------------------------------- }

{ Program na testovani komunikacniho protokolu TECOM, pro komunikaci
  s PLC TC600. Fyzicky se zpravy prenaseji ze serioveho portu RS485 Term10
  do PLC Tecomat, kde Term10 je Master a PLC Tecomat je Slave.
  Program provadi cyklicke cteni a zapis hodnot do registru Tecomatu
  s naslednym zpracovanim a vizualizaci ctenych hodnot.
  V PLC Tecomat je nahran program TECO_DIO.950, ktery neustale kopiruje hodnotu
  v uzivatelskem registru R0 na digitalni vystupu a neustale cte digitalni
  vstupy, ktere pote kopiruje do uzivatelskeho registru R1.
}
{ Je to v podstate upraveny demopriklad DTECOIO z adresare DTECO_IO tak,
  ze nepouziva komunikacniho automatu naimplementovanem v .PRI souboru, ale
  pouziva Master automat Tecom primo z KitBuilderu - uzivatelske procedury
  Proc5 a Proc6}
{ V komentarich se vyskytuji zkracene symboly,
  napr: "/4" znamena "delitelno ctyrma"
}
{ Tendo demostracni program byl napsan pro Kit-Builder V03.06 26/06/2000
}

options
  ProgVer = 1; { verze programu }

constant
 { retezcova konstanta s parametry pro komunikaci }
  { zvoli se jedna z nasledujicich variant podle pouzite cilove platformy }
  {Term10 - realne prostredi pro KitV40 a Term10 }
   cTC_ParamStr   = "NOD=100 NAM=COM ADD=$2310 IRQ=3 BD=19200 BIT=8 STO=2 PAR=E LRB=1000 REC=OFF2 ";
  {PC     - simulace na PC }
{   cTC_ParamStr   = "NOD=100 NAM=COM COM=3 IRQ=5 BD=19200 BIT=8 STO=2 PAR=E LRB=1000 REC=OFF2 ";
   { vyznam jednotlivych parametru - viz komunikacni knihovny }

(*========= konstnaty komunikace Master Tecom ===========*)
constant
{konstanty  stavu komunikacniho automatu}
  tCh_None       = 0; { zavreno - opustit proces }
  tCh_Open       = 1; { probiha open }
  tCh_Connect    = 2; { probiha connect }
  tCh_Send       = 3; { pocatek vysilani }
  tCh_MsgConnect = 4; { pocatek zpravy Connect }
  tCh_SendingConn= 5; { probiha vysilani zpravy Connect }
  tCh_RecConn    = 6; { probiha prijem odpovedi na zpravu Connect }
  tCh_Sending    = 7; { probiha vysilani }
  tCh_Rec        = 8; { probiha prijem odpovedi }
  tCh_DisConnect = 9; { probiha disconnect }
  tCh_Close      =10; { probiha close }

{chyby pri komunikaci}
  Res_SndTOut = $FF01; { TimeOut pri vysilani }
  Res_RecTOut = $FF02; { TimeOut pri prijmu odpovedi }
  Res_RecErr  = $FF03; { nespravna odpoved }

{konstanty typu zprav (vyhrazeno $0-$F)}
  cRead  = $01; {cteni registru}
  cWrite = $02; {zapis registru}
  cIdent = $03; {zprava Ident - identifikace zarizeni}

{konstanty typu registru}
  RegX   = $00; { registry X (vstupy) }
  RegY   = $01; { registry Y (vystupy) }
  RegS   = $02; { registry S (systemove) }
  RegR   = $03; { registry R (uzivatelske) }
  DBox0  = $80; { oblast pridavne pameti DataBox adresy $00000 - $0FFFF }
  DBox1  = $81; { oblast pridavne pameti DataBox adresy $10000 - $1FFFF }
  DBox2  = $82; { oblast pridavne pameti DataBox adresy $20000 - $2FFFF }
  DBox3  = $83; { oblast pridavne pameti DataBox adresy $30000 - $3FFFF }
  DBox4  = $84; { oblast pridavne pameti DataBox adresy $40000 - $4FFFF }
  DBox5  = $85; { oblast pridavne pameti DataBox adresy $50000 - $5FFFF }
  DBox6  = $86; { oblast pridavne pameti DataBox adresy $60000 - $6FFFF }
  DBox7  = $87; { oblast pridavne pameti DataBox adresy $70000 - $7FFFF }

{konstanty velikosti tabulek}
  SizeComGlbRec = 8+128;
  Size1MsgRec   = 14;
  SizeAllMsgRec = 3*Size1MsgRec;
(*=======================================================*)

symbol
{zaznam s globalnimi parametry komunikace}
  ComGlbRec = word:SizeComGlbRec;
    SndMaxTOut = word(ComGlbRec)[0]; {maximalni timeout v [ms] pro vysilani}
    RecMaxTOut = word(ComGlbRec)[2]; {maximalni timeout v [ms] pro prijem odpovedi}
    PerConnect = word(ComGlbRec)[4]; {perioda v [s] pro pokus o navazani spojeni nepripojene stanice zpravou Connect}
    PocMsg     = byte(ComGlbRec)[6]; {pocet obsluhovanych zprav v poli}
    ParamStr   = byte(ComGlbRec)[7]; {pocatek retezce parametru komunikace}
  PocComGlbRec = byte(ComGlbRec)[0]; {pocatek struktury ComGlbRec}

{struktura zaznamu zprav}
  MsgRec = word:SizeAllMsgRec; {deklarace pole pro 3 zpravy}
 {R}FlConnect  = byte(MsgRec)[0]; {priznak pripojeni dane PLC stanice}
    RW_Perm    = byte(MsgRec)[1]; {typ a zpusob vysilani teto zpravy}
 {W}  MsgType  = byte(MsgRec)[1]; {cteni(cRead),zapis(cWrite),identifikace(cIdent)}
 {W}  FlPermWr = RW_Perm.4;       {priznak cyklickeho vysilani teto zpravy, jinak vyslat jen je-li FlWrite=1}
 {RW} FlWrite  = RW_Perm.5;       {pokud FlPermWr=0, priznak jednorazoveho vyslani zpravy, po jejim vyslani se snuluje}
 {W}DNo        = word(MsgRec)[2]; {adresa cilove stanice}
 {W}AdrRW      = word(MsgRec)[4]; {adresa bufferu pro cteni/zapis dat - index v dat.oblasti KB}
 {W}BegI       = word(MsgRec)[6]; {pocatek ctenych/zapisovanych dat}
 {W}Poc        = byte(MsgRec)[8]; {pocet ctenych/zapisovanych bytu}
 {W}RegType    = byte(MsgRec)[9]; {typ ctenych ci zapisovanych dat - viz konstanty RegX,RegY...}
 {R}CountS     = word(MsgRec)[10];{pocitadlo poctu vyslanych zprav}
 {R}CountR     = word(MsgRec)[12];{pocitadlo poctu prijatych odpovedi}
 {R - nastavuje komunik.automat
  W - nastavuje uzivatel
  RW- nastavuje uzivatel i komunik.automat}
  PocMsgRec = byte(MsgRec)[0]; {pocatek pole MsgRec}

  TabStsCom = word:4;
    ChnState = byte(TabStsCom)[0]; { stav komunikace }
    ChnResult= word(TabStsCom)[2]; { status (chyby) komunikace }
    ChnResHi = byte(ChnResult)[0]; { horni byte chyby }
    ChnResLo = byte(ChnResult)[1]; { dolni byte chyby }
  PocTabStsCom = Byte (TabStsCom)[0]; { pocatek tabulky TabStsCom }

constant
{offsety na jednotlive zpravy}
  OfsMsg1 = 0*Size1MsgRec;
  OfsMsg2 = 1*Size1MsgRec;
  OfsMsg3 = 2*Size1MsgRec;
  OfsMsg1B= OfsMsg1*8;
  OfsMsg2B= OfsMsg2*8;
  OfsMsg3B= OfsMsg3*8;
  {napr.adresa cilove stanice pro 2.zpravu je DNo[OfsMsg2], ale priznak
        FlWrite pro 2.zpravu je FlWrite[OfsMsg2B], jelikoz se jedna o bit}

{ symbolicke nazvy registru PLC Tecomatu }
symbol
 { symbolicke nazvy ctenych registru z Tecomatu }
  TC_ROutVal = byte; { aktualni hodnota IO vystupu prectena z Tecomatu }
  TC_RInVal  = byte; { aktualni hodnota IO vstupu prectena z Tecomatu }
 { symbolicke nazvy zapisovanych registru do Tecomatu }
  TC_WOutVal = byte; { pozadovana hodnota IO vystupu zapisovana do Tecomatu }

 { symbolicke nazvy registru zpravy Ident }
  IdentStr = string:10; { identifikacni retezec }
  LenIdentStr = IdentStr[0];
  ProfiBus = byte;      { znak implementace profibusu }
  VerHW    = string:3;  { retezec s verzi hardwaru }
  VerSW    = string:3;  { retezec s verzi softwaru }

(*========= definice a konstanty terminalu ===========*)
{ konfigurace terminalu Term10 }
configuration
  HwObj  = TERM10, { nazev HW objektu }
    Name = TERM,   { uzivatelske jmeno pouzivane dale v programu }
    Adr  = $2300,  { adresa terminalu v IO prostoru }
    Var  = Byte;

{ konstanty fontu, bitmap a obrazovek terminalu }
constant
 { konstanty fontu }
  cFnt_8x8c   = 0; { font 8x8_cestina }
  cFnt_6x8c   = 1; { font 6x8_cestina }
  cFnt_16x32c = 2; { font 16x24_cestina }
 { konstanty bitmap }
  cBmp_Logo   = 0; { bitmapa s logem fy.SofCon }
  cBmp_Clear  = 1; { bitmapa prazdne stranky }
 { konstanty obrazovek terminalu }
  cTer_Uvod   = 0; { uvodni obrazovka s logem firmy SofCon }
  cTer_Main   = 1; { obrazovka se zobrazenim namerenych hodnot z PLC }
  cTer_EditTC = 2; { obrazovka pro editaci pozadovane hodnoty vystupu }
  cTer_SysCom = 3; { systemova obrazovka s komunikaci }

{ pomocne promenne }
symbol
  Pom_SimPoz = word; { pro simulaci zmeny pozadovane hodnoty }
  Pom_EditB  = byte; { pro editaci bytoveho parametru }
  TC_WrCount = word; { pro ulozeni pocitadla zapsanych zprav}
  PomS       = string:128;
(*====================================================*)

#define InitMasterTeco Proc5
#define DoneMasterTeco Proc6

{ ------------------------------------ }
{ Nasledujici procedura se vykona vzdy po RESETu }
procedure INIT;
begin
 { inicializace a nastaveni Teco Automatu a jeho promennych
   a implicitni nastaveni zaznamu Tecomatu }
  SndMaxTOut :=  200; {maximalni timeout v ms pro vysilani}
  RecMaxTOut := 1000; {maximalni timeout v ms pro prijem odpovedi}
  PerConnect := 10;   {perioda v s pro pokus o navazani spojeni nepripojene stanice zpravou Connect}
  PocMsg     := 2;    {pocet obsluhovanych zprav v poli}
  PomS       := cTC_ParamStr;
  Move(PomS,ParamStr,PomS[0]+1);

 {nadefinovani 1.zpravy - cteni registru}
  MsgType [OfsMsg1]  := cRead; {cteni(cRead),zapis(cWrite),identifikace(cIdent)}
  FlPermWr[OfsMsg1B] := 1;     {priznak cyklickeho vysilani teto zpravy, jinak vyslat jen je-li FlWrite=1}
  DNo     [OfsMsg1]  := 1;     {adresa cilove stanice}
  AdrRW   [OfsMsg1]  := Addr(TC_ROutVal); {adresa bufferu pro cteni/zapis dat - index v dat.oblasti KB}
  BegI    [OfsMsg1]  := 0;     {pocatek ctenych/zapisovanych dat}
  Poc     [OfsMsg1]  := 2;     {pocet ctenych/zapisovanych bytu}
  RegType [OfsMsg1]  := RegR;  {typ ctenych ci zapisovanych dat - viz konstnaty RegX,RegY...}
 {nadefinovani 2.zpravy - zapis registru}
  MsgType [OfsMsg2]  := cWrite;{cteni(cRead),zapis(cWrite),identifikace(cIdent)}
  FlPermWr[OfsMsg2B] := 0;     {priznak cyklickeho vysilani teto zpravy, jinak vyslat jen je-li FlWrite=1}
  FlWrite [OfsMsg2B] := 1;     {poprve vyslat zpravu pro zapis registru}
  DNo     [OfsMsg2]  := 1;     {adresa cilove stanice}
  AdrRW   [OfsMsg2]  := Addr(TC_WOutVal); {adresa bufferu pro cteni/zapis dat - index v dat.oblasti KB}
  BegI    [OfsMsg2]  := 0;     {pocatek ctenych/zapisovanych dat}
  Poc     [OfsMsg2]  := 1;     {pocet ctenych/zapisovanych bytu}
  RegType [OfsMsg2]  := RegR;  {typ ctenych ci zapisovanych dat - viz konstnaty RegX,RegY...}
 {nadefinovani 3.zpravy - identifikace zarizeni}
  MsgType [OfsMsg3]  := cIdent;{cteni(cRead),zapis(cWrite),identifikace(cIdent)}
  FlPermWr[OfsMsg3B] := 0;     {priznak cyklickeho vysilani teto zpravy, jinak vyslat jen je-li FlWrite=1}
  FlWrite [OfsMsg3B] := 1;     {poprve vyslat zpravu pro zapis registru}
  DNo     [OfsMsg3]  := 1;     {adresa cilove stanice}
  AdrRW   [OfsMsg3]  := Addr(LenIdentStr); {adresa bufferu pro cteni/zapis dat - index v dat.oblasti KB}

  TC_ROutVal := 0;   { pocatecni nastaveni aktualni hodnoty ctenych IO vystupu }
  TC_RInVal  := 0;   { pocatecni nastaveni aktualni hodnoty ctenych IO vstupu }
  TC_WOutVal := $44; { pocatecni nastaveni hodnoty zapisovanych IO vystupu }

  TC_WrCount := 0;

  InitMasterTeco(PocComGlbRec,PocMsgRec,PocTabStsCom);
end;

{ ------------------------------------ }
procedure SimOutVal;
  { simulace zmeny IO }
begin
  if (TERM_ScrNo<>cTer_EditTC    ) and  { needituje-li se zrovna nektera konstanta ovlivnujici simulaci }
     (TC_WrCount<>CountS[OfsMsg2]) then
  begin
    TC_WrCount:=CountS[OfsMsg2];
    TC_WOutVal:=(TC_WOutVal shr 7) or (TC_WOutVal shl 1); { rol }
    FlWrite[OfsMsg2]:=1; { prikaz provedeni zapisu }
  end;
end;

{ ------------------------------------ }
{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  SimOutVal;   { simulace zmeny IO }
end;

{ ========================================================================== }
terminal TERM : cTer_Uvod;
   { uvodni obrazovka s logem firmy SofCon }
begin
  BitMap cBmp_Logo;  { bitmapa c.0 - s logem SofCon }
  Wait 1,cTer_Main;  { po jedne sekunde se automaticky prejde na obrazovku c.1 }
  OnKey              { nebo po stisku nektere z klaves se prejde na obrazovku c.1 }
    zESC,zCR,
    zUp, zDn : TERM_ScrNo:=cTer_Main;
  end;
end;

{ ------------------------------------ }
terminal TERM : cTer_Main;
   { obrazovka s grafickym zobrazenim namerenych hodnot }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 25,7;
   Print "Vizualizace meen TC600";

  Font cFnt_6x8c;
  { vypsani, zda je ci neni navazana komunikace s PLC Tecomat }
  Position 20,25; Print "Status komunikace: ";
   case FlConnect[OfsMsg1] of
     0:   Print "Nekomunikuji";
     else Print "Komunikuji";
   end;

  { vypis hodnot ctenych dat }
   Position 10, 50; Print "Read Inputs";
   Position 15, 65; Print "Data: ",bin TC_RInVal;
  { vypis hodnot zapisovanych dat }
   Position 10, 80; Print "Write Outputs - <E>dit";
   Position 15, 95; Print "Data: ",bin TC_ROutVal;

  OnKey { pozadovane akce na stisk danych klaves }
    zESC:TERM_ScrNo:=cTer_Main;
    zUp,
    zDn :TERM_ScrNo:=cTer_Main;
    'S' :TERM_ScrNo:=cTer_SysCom;
    'E' :begin
           Pom_EditB :=TC_WOutVal;
           TERM_ScrNo:=cTer_EditTC;
         end;
  end;

  Help { definice stranky napovedy }
   Font cFnt_8x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,25; Print "Vizualizace dat PLC TC600 Tecomat";
   Position 10,35; Print "pomoc komunikanho protokolu Tecomat";
   Position 10,50; Print "<E> - editace rotujc hodnoty";
   Position 10,60; Print "<S> - systmov obrazovka komunikace";
end;

{ ------------------------------------ }
terminal TERM : cTer_EditTC;
   { obrazovka pro editaci simulovane hodnoty }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  { vypis hlavicky }
   Position 10,7;
    Print "Editace rotujici hodnoty Teco";
  { vypis vodiciho textu }
   Rect rel,85,46,68,28;
   Font cFnt_6x8c;
   Position 7,95;
    Print "Zadej hex.slo v rozsahu 1h a FEh";
  { nastaveni forntu a pozice pro editaci }
   Font cFnt_16x32c;
   Position 160,46; Print "h";
   Position 90,45;
  { vlastni editace }
   Edit hex Pom_EditB:2,$1,$FE;

  EditEnter { definice akci pro ukonceni editace klavesou <Enter> }
  begin
    TC_WOutVal :=Pom_EditB; { aktualizace zeditovane promenne }
    FlWrite[OfsMsg2]:=1;    { aby se provedl zapis do PLC }
  end;

  Help
   Font cFnt_8x8c;
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,25; Print "Nastaveni rotujici hodnoty.";
   Position 10,37; Print "Tato hodnota se bude periodicky menit";
   Position 10,49; Print "bitovou rotaci vlevo a vysledna hodnota";
   Position 10,61; Print "se bude po seriove lince zapisovat do";
   Position 10,73; Print "vstupnich registru daneho PLC";
end;

{ ------------------------------------ }
terminal TERM : cTer_SysCom;
   { ladici obrazovka }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 20,7;
   Print "Komunikace s PLC Teco";

  Font cFnt_6x8c;
  Position 10,25;
   case ChnState of { vypise aktualni stav automatu komunikacniho kanalu }
      tCh_None       : Print "Kanl: Off";
      tCh_Open       : Print "Kanl: Opening";
      tCh_Connect    : Print "Kanl: Connecting";
      tCh_MsgConnect : Print "Kanl: Next Message";
      tCh_SendingConn: Print "Kanl: Send Msg Connect";
      tCh_RecConn    : Print "Kanl: Recv Msg Connect";
      tCh_Send       : Print "Kanl: Send Message";
      tCh_Sending    : Print "Kanl: Send Message";
      tCh_Rec        : Print "Kanl: Recv Message";
      tCh_DisConnect : Print "Kanl: Disconnecting";
      tCh_Close      : Print "Kanl: Closing";
   end;

  Position 10,55;
   Print "Result : ",hex ChnResult;

  Position 10,75;
   Print "Ct_SndRead : ",CountS[OfsMsg1];
  Position 10,85;
   Print "Ct_RecRead : ",CountR[OfsMsg1];
  Position 130,75;
   Print "Ct_SndWrite : ",CountS[OfsMsg2];
  Position 130,85;
   Print "Ct_RecWrite : ",CountR[OfsMsg2];

  Position 10,95;
   case FlConnect[OfsMsg1] of
     0 :  Print "PLC Not Connect";
     else Print "PLC Connect";
   end;

  OnKey
    zESC:TERM_ScrNo:=cTer_Main;
    zDn,
    zUp :TERM_ScrNo:=cTer_Main;
  end;

  Help
    Position 20,20; Print "Obr. se zkl. parametry";
    Position 20,35; Print "komunikace s PLC Tecomat";
end;

{ ------------------------------------ }
