{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{
 Program demonstruje praci s deskou IOADDA - analogove I/O

  SU= singularni unipol. vstup 0..4095
  SB= singularni bipol. vstup -4095..4095
  DU= diferencialni unipol. vstup 0..4095
  DB= diferencialni bipol. vstup -4095..4095
}

#define pos position           {pomoci define muzeme misto "position" pouzivat jen "pos"}

CONFIGURATION
  HWOBJ=TERM10, NAME=TERM, ADR=$2300, VAR=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}
  HWOBJ=IOADDA01, NAME=IO, ADR=$2330, VAR=Integer, MAIN=[IN0=SU,IN1=SU,IN2=DU,IN4=SB,IN5=SB,IN6=DB,OUT0,OUT1];
          { vlastni definice ovladace HW portu typu IOADDA01}

procedure INIT; {procedura INIT se vola jednou po startu}
begin
  IO_OUT0=1023; {nastavime inicializacni hodnotu vystupnich kanalu}
  IO_OUT1=2047;
end;

procedure MAIN; { hlavn proces - procedura ktera se provadi cyklicky}
begin                            {po celou dobu behu automatu }
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                                              {Nastavime font 0}
  pos 20,15; print "Test vstup a vstup IOADDA01";   {Na pozici vytiskneme}
  pos 20,30; print "In0 SU",IO_IN0:6,"  Out0",IO_OUT0:6; {text a promenne}
  pos 20,40; print "In1 SU",IO_IN1:6,"  Out1",IO_OUT1:6;
  pos 20,50; print "In2 DU",IO_IN2:6;
  pos 20,60; print "In4 SB",IO_IN4:6;
  pos 20,70; print "In5 SB",IO_IN5:6;
  pos 20,80; print "In6 DB",IO_IN6:6;
  pos 20,110; print "Npovda - klvesa F1";

  onkey                                  {definujeme reakci na klavesy}
   '0': TERM_ScrNo:=1;                   {'0' - prejdeme na obrazovku 1}
   '1': TERM_ScrNo:=2;                   {'1' - prejdeme na obrazovku 2}
  end;
help                                     {definice obrazovky HELP - aktivni}
  font 1;                                {pri stisku F1, nastaveni fontu}
  pos 10, 10; print "Npovda:";         {Na pozici ... umisti text ...}
  pos 10, 30; print "Nastaven vstupu 0/1 - klvesa 0/1";
  pos 10, 50; print "IN0,IN1=SU IN2=DU IN4,IN5=SB IN6=DB";
  pos 10, 70; print "S-singulrn B-bipolrn -4095..4095";
  pos 10, 80; print "D-diferenciln U-unipolrn 0..4095";
  pos 20,110; print "Zpt klvesou ESC.";
end;

{ Popis obrazovky c.1 terminalu TERM10 }
terminal TERM:1;
begin
  font 1;                                              {Nastavime font 0}
  pos 20,30;print "Nastaven Out0 [0-4095]";              {Na pozici }
  pos 20,50;print "Out0=";pos 50,50;edit IO_Out0:4,0,$FFF;{Vytiskneme text
                                            a vyhradime misto pro editaci
                                            promenne IO_OUT0}
  pos 20,110; print "Npovda - klvesa F1";
help                                     {definice obrazovky HELP - aktivni}
  font 1;                                {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda Out0";     {Na pozici ... umisti text ...}
  pos 20 ,40; print "Potvrzen nastaven hodnoty";
  pos 20 ,50; print "klvesou ENTER,";
  pos 20 ,60; print "Zpt bez nastaven klvesou ESC.";
end;

{ Popis obrazovky c.2 terminalu TERM10 }
terminal TERM:2;
begin
  font 1;                                              {Nastavime font 0}
  pos 20,30;print "Nastaven Out1 [0-4095]";              {Na pozici}
  pos 20,50;print "Out1=";pos 50,50;edit IO_Out1:4,0,$FFF;{Vytiskneme text
                                            a vyhradime misto pro editaci
                                            promenne IO_OUT1}
  pos 20,110; print "Npovda - klvesa F1";
help                                     {definice obrazovky HELP - aktivni}
  font 1;                                {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda Out1";     {Na pozici ... umisti text ...}
  pos 20 ,40; print "Potvrzen nastaven hodnoty";
  pos 20 ,50; print "klvesou ENTER,";
  pos 20 ,60; print "Zpt bez nastaven klvesou ESC.";
end;
