{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{
 Program demonstruje jednoduchy vypocet CRC-kodu,
 pouzitim funkci CRC8 a CRC16.
}

configuration
  hwobj=TERM10, name=TERM, adr=$2300, var=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}
symbol
  Text  =String:31;                {Text nad kterym bydeme CRC pocitat}
  TextL =Text[30];                 {Posledni znak retezce}
  vCrc8 =Byte;                     {Promenna pro CRC8}
  vCrc16=Word;                     {Promenna pro CRC16}

procedure INIT;                    {procedura INIT se vykona vzdy po RESETu}
begin                              { - slouzi k pocatecnimu nastaveni promennych}
  Text:="Test vypoctu CRC kodu!";  {nastavime pocatecni text pro vypocet CRC}
end;

{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  {jelikoz se vse provadi jako reakce na stisk klaves,
   jsou jednotlive funkce implementovany v sekci
   definice obrazovek terminalu}
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                                          {Nastavime font 1}
  position 10,10; print "Ukazka vypoctu CRC-kodu"; {Na pozici position ...
                                                    Vytiskneme text ...}
                                                   {Na pozici position ...}
                                                   {Vytiskneme text a obsah
                                                          promennych}
  rect rel,8,47,224,12;                            {nakreslime ramecek do ktereho}
  position 10,50; print "Text : ",Text;            {na pozici position ...
                                                    Vytiskneme text ...}
  position 10,70; print "CRC8 : ",hex vCrc8;       {na pozici position ...
                                                    vytiskneme text a obsah
                                                    promennych v hex formatu}
  position 10,80; print "CRC16: ",hex vCrc16;      {na pozici position ...
                                                    vytiskneme text a obsah
                                                    promennych v hex formatu}
  onkey                                            {definujeme reakci na klavesy}
    'T':TERM_ScrNo:=1;                             {'T' - prejdeme na obrazovku 1}
    'C':begin                                      {'C' - provedeme vypocet CRC}
          vCrc8:=Crc8(Text,TextL);                 {Vypocet CRC8 pres pole TEXT}
          vCrc16:=Crc16(Text,TextL);               {Vypocet CRC16 pres pole TEXT}
        end;
  end;

  help                                             {definice obrazovky HELP - aktivni}
    font 1;                                        {pri stisku F1, nastaveni fontu}
    position 10,10; print "Npovda:";             {Na pozici ... umisti text ...}
    position 10,35; print "Stisk klavesy:";
    position 20,45; print "T - nastaveni TEXTU";
    position 20,55; print "C - vypocet CRC";
end;

{ Popis obrazovky c.1 terminalu TERM10 }

terminal TERM:1;
begin
  font 1;                                                {nastaveni fontu}
  position 10,10; print "Editace textu pro vypocet CRC"; {Na pozici ... umisti text ...}
  rect rel,8,47,224,12;                                  {nakreslime ramecek do ktereho}
  position 10,50; print "Text = ";                       {Na pozici ... umisti text ...}
  position 52,50; edit Text:30;                          {Na pozici ... umisti editacni
                                                          okno promenne TEXT}
  help                                                   {definice obrazovky HELP - aktivni}
   font 1;                                               {pri stisku F1, nastaveni fontu}
   position 10 ,10; print "Npovda";                    {Na pozici ... umisti text ...}
   position 10 ,30; print "Editace textu pro vypocet CRC";
end;

