{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{ --------------------------------------------- }
{
  Tento program slouzi k demonstraci prikazu BARGRAPH,
  V programu je provadeno generovani sinusoveho signalu,
  ktery je zobrazovan pomoci BarGraphu.
}

#define pos position         {pomoci define muzeme misto "position" pouzivat jen "pos"}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
SYMBOL
  Krok   = Byte;             {krok velikosti uhlu pro vypocet noveho prvku}
  PerS   = Byte;             {perioda vypoctu noveho prvku simulatoru}

  Fce    = Integer;          {simulovana sinusova funkce}

  TS     = Word;             {promenna pro casovac vypoctu simulatoru}

  Alfa   = Integer;          {uhel pri vypoctu simulatoru}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
CONFIGURATION
  HWOBJ=TERM10, LED=$AA, NAME=TERM, ADR=$2300, VAR=Byte; {deklarace terminalu}
  SWOBJ=SAVER, SAVE=[PerS,Krok];  {nektere promenne je vhodne pri
                                        vypadku napajeni zalohovat}
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure INIT;
begin
  {Osetreni zalohovanych promennych, zda jsou ve spravnych mezich}
  if PerS<2  then PerS:=10
             else PerS:=PerS;

  if Krok<1 then Krok:=5
            else Krok:=Krok;

  {Nastartovani casovacu}
  TimerOn(TS,per10ms);
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure MAIN;
begin
  {Generator sinusovky}
  while TS>=PerS do
  begin
    TS:=TS-PerS;
    if Alfa < 360 then
      Alfa:=(Alfa+Krok)
    else
      Alfa:=0;
    fce:=sin(Alfa);
  end;
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:0;
begin
  font 1;                                                  {Nastavime font 1}
  pos  20, 15; print "Ukzka pouit prikazu BAR";         {Na pozici position ... }
  pos  20, 35; print "genertor sinusovky:";               { Vytiskneme text ...}
  pos  20, 45; print "Krok hlu ",Krok:0,", Perioda ",PerS:0,"0ms"; { a promenne}
  pos  20,110; print "Npovda - klvesa F1";
  pos 208,  1; print Fce:5:2;                {vyuzivame moznosti tisknou cele
                                              cislo ve formatu s pevnou
                                              radovou carkou urcujici 2 mista}
  rect 227,10,237,125;                       {nakreslime ramecek do ktereho}
  bar bottom, Fce, -100,100, 227,10,237,125; {umistime bar graph }
  onkey                                      {definujeme reakci na klavesy}
   'K':TERM_scrno:=15;                       {'K' - prejdeme na obrazovku 15}
   'P':TERM_scrno:=16;                       {'P' - prejdeme na obrazovku 16}
  end;
help                                         {definice obrazovky HELP - aktivni}
  font 1;                                    {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";              {Na pozici ... umisti text ...}
  pos 20, 50; print "Zmnu hodnoty parametru";
  pos 20, 60; print "vyvolme stiskem velk ";
  pos 20, 70; print "klavesy v pslunm nzvu.";
  pos 20,110; print "Zpt klvesou ESC.";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:15;
begin
  font 1;                                              {Nastavime font 1}
  pos 20, 30; print "Genertor sinusovky - nastaven"; {Na pozici position ... }
  pos 20, 40; print "velikosti kroku hlu <1,90> ";   {Vytiskneme text ...}
  pos 20, 60; print "Alfa=  "; pos 50,60; edit Krok:2,1,90; {a vytvorime okno
                                                        okno pro editaci promenne}
  pos 20,110; print "Npovda - klvesa F1";
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 30; print "Nastaven velikosti kroku hlu.";
  pos 20, 40; print "Potvrzen nastaven hodnoty";
  pos 20, 50; print "klvesou ENTER,";
  pos 20, 60; print "Zpt bez nastaven klvesou ESC.";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:16;
begin
  font 1;                                              {Nastavime font 1}
  pos 20, 30; print "Genertor sinusovky - nastaven"; {Na pozici position ... }
  pos 20, 40; print "periody kroku <1,2000> ms";       {Vytiskneme text ...}
  pos 20, 60; print "Perioda=   0ms"; pos 68,60;edit PerS:3,1,200; { a vytvorime
                                                        okno pro editaci promenne}
  pos 20,110; print "Npovda - klvesa F1";
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 30; print "Nastaven periody kroku genertoru.";
  pos 20, 40; print "Potvrzen nastaven hodnoty";
  pos 20, 50; print "klvesou ENTER,";
  pos 20, 60; print "Zpt bez nastaven klvesou ESC.";
end;
