{ --------------------------------------------- }
{  KIT-Builder Program                          }
{  (c) SofCon 1998                              }
{ --------------------------------------------- }
{
  Demostracni program komunikace s terminalem Term01.

  Potrebny HW:  1. volny seriovy port, Terminal TERM01
}
{ ----------------------------------------------------------------- }
{ Konfigurace hw a sw objektu }

configuration

  { Nastaveni parametru hw-objektu Term01 }
  {   name = identifikator prirazeny tomuto terminalu
      adr  = adresa serioveho portu         (viz. manual)
      irq  = cislo preruseni od ser. portu  (viz. manual)
  }

  hwobj = Term01, name = Term, adr = $2320, irq = 3;


{ ----------------------------------------------------------------- }
{ Deklarace promennych }

symbol

  CounterW = word;   { Promenna casovace, inkrementovana kazdych 10 ms }
  Counter  = byte;   { }

  Value    = byte;   { Editovana hodnota }

{ ----------------------------------------------------------------- }
{ Inicializacni procedura INIT }

procedure Init;
begin
  Counter := 0;
  CounterW := 0;
  { Spusteni casovace s periodou 10ms na  prommenne CounterW }
  TimerOn (CounterW, Per10ms);
end;

{ ----------------------------------------------------------------- }
{ Hlavni procedura MAIN }

procedure Main;
begin

  { Kazdych 500 ms, zvysime pocitadlo Counter o 1 }

  if CounterW >= 50 then
  begin { Uplynulo 500 ms }
    Dec(CounterW, 50);

    if Counter = 255 then
    begin { pri pricteni 1 by doslo k preteceni, proto Counter vynulujeme }
      Counter := 0;
    end
    else
      Inc(Counter);

  end;

end;

{ ----------------------------------------------------------------- }
{ Definice uvodni obrazovky aplikace }

terminal Term:0;
begin
  position 2, 0;             { Presunuti ukazovatka na pozici 2, 0 }
  print "Term01 Demo";       { Vypis textu "Term01 Demo" na pozici 2,0 }
  position 4, 1;
  print time SysPackTime;    { Vypis systemoveho casu }
  position 0, 2;
  print "----------------";
  position 0, 3;
  print "Stisknete ENTER";

  onkey                      { definice reakce na klavesu }
    zCr: Term_ScrNo := 1;    { pri stisku Enter se prejde na obrazovku c. 1 }
  end;

help
{        0123456789012345 }
  print "   Ukazkova     ";  { definice help obrazovky }
  print "   aplikace     ";  { radka displeje ma presne 16 znaku }
  print "      pro       ";  { pokud vypiseme prave 16 znaku, ukazovatko }
  print "     TERM01     ";  { se presune na nasledujici radku }
end;

{ ----------------------------------------------------------------- }
{ Definice obrazovky vypisu ruznych formatu cisel }

terminal Term:1;
begin
  position 1, 0;             { presunuti ukazovatka na pozici 1, 0 }
  print "Dec:", dec Counter; { vypis prommene Counter v desitkove soustave }
  position 9, 0;
  print "Hex:", hex Counter; { vypis prommenne Counter v sestnactkove soustave }
  position 1, 1;
  print "Bin:", bin Counter; { vypis prommene Counter v binarni soustave }
  position 0, 3;
  print "Stisknete ENTER";

  onkey                      { denice odezvy na stisk klaves }
    zCr: Term_ScrNo := 2;    { po stisku Enter se presuneme na obrazovku c. 2 }
  end;

help                         { definice napovedy pro tuto obrazovku }
{        0123456789012345}
  print "Napoveda:       ",
        "   Vypis cisel  ",
        "   v ruznych    ",
        "   formatech.   ";

end;

{ ----------------------------------------------------------------- }
{ Definice obrazovky ukazky editace promenne }

terminal Term:2;
begin
  position 0, 0;
  print "Editace hodnoty";

  position 1, 1;
  print "v rozsahu 0-100";

  position 0, 2;
  print "hodnota=";
  edit  value:4,0,100;        { editace promenne Value, na 4 cifry, }

  position 0, 3;              {  minimalni a maximalni hodnota 0..100 }
  print "pak stisk. ENTER";

editenter                     { po stisku enter (tedy ukonceni editace) }
  Term_ScrNo := 3;            { se prejde na obrazovku cislo 3 }

help
{        0123456789012345 }
  print "Napoveda:       ",
        " Ukazka editace ",
        "promenne v dec. ",
        "   formatu.     ";
end;

{ ----------------------------------------------------------------- }
{ Definice obrazovky s pouzitim prikazu Wait }

terminal Term:3;
begin
{        0123456789012345 }
  print "Zadal jste cislo";
  position 8, 2;                
  print dec Value;              { Vypis editovane hodnoty }
  position 7, 3;
  print "$", hex Value;
  wait 2, 0;                    { Cekame 2 sekundy, pak se prejde na obr. c.0 }

help
{        0123456789012345 }
  print "Vyckejte nekolik";
  print "sekund nez obr. ";
  print "zmizi, nebo     ";
  print "stisknete ESC   ";
end;