{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }
{
  Tento program slouzi k demonstraci pouziti PID regulatoru,
  vedle toho se zde pracuje s prikazy BAR, ...
  Program simuluje soustavu prvniho radu a provadi
  jeji regulaci pomoci PIDI regulatoru
}

#define pos position         {pomoci define muzeme misto "position" pouzivat jen "pos"}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
SYMBOL                        {definujeme registry}
  Per=Byte;                   {periodu simulatoru}
  Simulator=LongInt;          {pamet simutlatoru}
  T=Word;                     {casovac simulatoru}
  RezimR=Byte;                {rezim regulatoru}
  OldU=Integer;               {stary vystup regulatoru}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
CONSTANT
  cMax=10000;          {konstanty limitujici rozsahy promennych - MAX}
  cMin=0;                                                      {a MIN}

  cY1=10;              {souradnice objektu na obrazovce:}
  cY2=125;
  cX1=203;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
CONFIGURATION
  HWOBJ=TERM10, LED=$AA, NAME=TERM, ADR=$2300, VAR=Byte; {deklarace terminalu}
  SWOBJ=PID, NAME=R, VAR=Integer, Ts=2;                  {objekt pidi regulatoru}
  SWOBJ=SAVER, SAVE=[R_Auto..R_DGap,Simulator,Per];      {kompletni zalohovani PID
                                                          regulatoru a simulatoru soustavy}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure INIT; {procedura INIT se provadi pouze pri startu systemu}
begin
  {Osetreni zalohovanych promennych, zda jsou ve spravnych mezich}
  if (R_W>cMax)or(R_W<cMin) then R_W:=(cMax-cMin)/2;
  if (R_KP>4000)or(R_KP<=0) then R_KP:= 100;
  if (R_KI>1000)or(R_KI<=0) then R_KI:= 100;
  if (R_KD>1000)or(R_KD<=0) then R_KD:=   1;
  R_MaxU:=cMax;
  R_MinU:=cMin;
  R_Auto:=1;
  R_RelK:=1;
  R_EGap:=0;
  R_IGap:=cMax;
  R_DGap:=cMax;
  if Simulator>cMax*100 then Simulator:=cMax*100
  else if Simulator<cMin*100 then Simulator:=cMin*100;
  if Per<10 then Per:=10;
  {Zapneme casovac simulatoru}
  TimerOn(T,per10ms);
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure MAIN;           {Cyklicky provadena hlavni procedura}
begin
  {Simulace soustavy}
  if T>Per then
  begin
    T:=T-Per;
    Simulator:=Simulator-R_Y+R_U;
    R_Y:=(Simulator+50)/100;
  end;
  if OldU<>R_U then TERM_LED:=not TERM_LED;
  OldU:=R_U;
  RezimR:=R_Auto;
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:0;
begin
  font 1;                                         {Nastavime font 1}
  pos 20,20; print "Ukzka pouit objektu PID";  {Na pozici position
                                                   Vytiskneme text ...}
  pos 20,35;  print "W=",R_W:5,"  minu=",R_MinU:5;{a promenne}
  pos 20,45;  print "Y=",R_Y:5,"  maxu=",R_MaxU:5;
  pos 20,55;  print "u=",R_U:5,"  Uman=",R_Uman:5;

  pos 20,70;  print "kP=",R_KP:0," kI=",R_KI:0," kD=",R_KD:0;
  pos 20,85;

  case RezimR of 0: print "rezim manual -> Auto"; {podmineny text v zavislosti}
                 1: print "rezim auto -> Manual"; {na obsahu promenne RezimR}
  end;

  pos 20,100;  print "per.Sim=",Per:0;

  pos cX1,1; print "W Y U";

  {nakreslime ramecky do kterych umistime bar graphy jednotlivych promennych:}
  rect cX1   ,cY1,cX1+10,cY2; bar bottom, R_W, R_MinU,R_MaxU, cX1+00,cY1,cX1+10,cY2;
  rect cX1+12,cY1,cX1+22,cY2; bar bottom, R_Y, R_MinU,R_MaxU, cX1+12,cY1,cX1+22,cY2;
  rect cX1+24,cY1,cX1+34,cY2; bar bottom, R_U, R_MinU,R_MaxU, cX1+24,cY1,cX1+34,cY2;

  onkey                           {definujeme reakci na klavesy}
   'W':TERM_scrno:=11;            {'W' - prejdeme na obrazovku 11}
   'U':TERM_scrno:=12;
   'P':TERM_scrno:=13;
   'I':TERM_scrno:=14;
   'D':TERM_scrno:=15;

   'M':R_Auto:=0;
   'A':R_Auto:=1;

   'S':TERM_scrno:=16;
  end;
help                              {definice obrazovky HELP - aktivni}
  font 1;                         {pri stisku F1, nastaveni fontu}
  pos 20, 20; print "Npovda";   {Na pozici ... umisti text ...}
                          {123456789012345678901234567890123}
  pos 20,50; print   "Editaci promenne spustime stiskem";
  pos 20,60; print   "velke klavesy v nazvu parametru";
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:11;
begin
  font 1;                                        {Nastavime font 1}
  position 20,30;print "Editace zadane hodnoty"; {Na pozici position vytiskneme text}
  pos 20,50; print "W="; pos 32,50; edit R_W:5,cMin,cMax; {a nastavime editaci}
help                                             {definice obrazovky HELP - aktivni}
  font 1;                                        {pri stisku F1, nastaveni fontu}
  pos 10, 20; print "Npovda";                  {Na pozici ... umisti text ...}
  pos 10 ,30; print "Editace W, ukonceni Enter";
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:12;  {komentar obdoba obr. 11}
begin
  font 1;
  position 20,30;print "Editace manualniho vystupu";
  pos 20,50; print "UMan="; pos 50,50; edit R_UMan:5,cMin,cMax;
  help
   pos 10 ,10; print "Npovda";
   pos 10 ,30; print "Editace UMan, ukonceni Enter";
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:13;  {komentar obdoba obr. 11}
begin
  font 1;
  position 20,30;print "Editace proporcionalni konst.";
  pos 20,50; print "Kp="; pos 38,50; edit R_Kp:5,0,10000;
  help
   pos 10 ,10; print "Npovda";
   pos 10 ,30; print "Editace Kp, ukonceni Enter";
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:14;  {komentar obdoba obr. 11}
begin
  font 1;
  position 20,30;print "Editace integracni konst.";
  pos 20,50; print "Ki="; pos 38,50; edit R_Ki:5,0,10000;
  help
   pos 10 ,10; print "Npovda";
   pos 10 ,30; print "Editace Ki, ukonceni Enter";
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:15;  {komentar obdoba obr. 11}
begin
  font 1;
  position 20,30;print "Editace derivacni konst.";
  pos 20,50; print "Kd="; pos 38,50; edit R_Kd:5,0,10000;
  help
   pos 10 ,10; print "Npovda";
   pos 10 ,30; print "Editace Kd, ukonceni Enter";
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:16;  {komentar obdoba obr. 11}
begin
  font 1;
  position 20,30;print "Editace periody";
  position 20,40;print "simulace <1,255>";
  position 20,60;print "Perioda=";position 68,60;edit Per:3,1,$FF;
  help
   pos 10 ,10; print "Npovda";
   pos 10 ,30; print "Editace periody simulace, ukonceni Enter";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

