{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{
 Program demonstruje pouziti systemovych hodin
 uchovavajicich realny cas.

 Hodiny jsou zobrazovany v graficke i digitalni podobe,
 vcetne datumu a dne v tydnu.

 Je mozno si zapnout funkci Budik a nechat se hodinami
 zbudit.
}

#define pos position     {pomoci define muzeme misto "position" pouzivat jen "pos"}

configuration
  hwobj=TERM10, name=TERM, adr=$2300, var=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}

{ Definujme si symbolicka jmena v programu pouzivanych registru }
symbol
  OLDSEC=Byte;
  MALARUC=Integer;
  VELKARUC=Byte;
  W_HOUR=Word;

  Budik_On=Byte;       {Promenne pro budik}
  Budik_Beep=Byte;
  Budik_HH=Byte;
  Budik_MM=Byte;
  Budik_T=Word;
  Budik_Zobr=Byte;
  Budik_Ed=Word;
  Budik_Pom=Word;

  ASec=Word;           {Promenne pro rucicku SEKUND}
  XSec=Byte;
  YSec=Byte;
  XSec1=Byte;
  YSec1=Byte;

  XMin=Byte;           {Promenne pro rucicku MINUT}
  YMin=Byte;
  AMin=Real;

  XHod=Byte;           {Promenne pro rucicku HODIN}
  YHod=Byte;
  AHod=Real;

  ResultSin=Integer;   {Pomocne promenne pro vypocet fci SIN a COS}
  ResultCos=Integer;

constant
  X=120; Y=64; R=64;   {Souradnice Stredu Hodin }
  RSec=0.54;           {Polemer rucicky SEKUND, zakladem je 100 bodu}
  RMin=0.60;           {Polemer rucicky MINUT, zakladem je 100 bodu}
  RHod=0.45;           {Polemer rucicky HODIN, zakladem je 100 bodu}

configuration
  swobj=SAVER, SAVE=[Budik_On,Budik_Beep,Budik_HH,Budik_MM]; { ulozeni
                 nastaveni budiku - pri vypadku napajeni je zalohovano}

procedure SetBudikZobr;      {Pro zobrazeni stavu budiku na displeji}
begin                        {je treba opakavane nastavovat promennou}
   if Budik_On=$FF then      {Budik_On, napsali jsme tedy pro ni proceduru}
     if Budik_MM<10 then     {Kterou muzeme volat z vice mist programu}
       Budik_Zobr:=1
     else
       Budik_Zobr:=2
   else
     Budik_Zobr:=0;
end;

procedure INIT;              {Nasledujici procedura, ktera se vykona vzdy}
begin                        {po RESETu, slouzi k inicializaci promennych}
  TERM_LED:=$aa;             {pocatecni hodnota  LED diod na TERMINALU}
  if Budik_Beep then         {pokud ma budik zvonit}
    TimerOn(Budik_T,per1s);  {tak zapnu casovac}
  SetBudikZobr;              {Nastav zobrazeni stavu Budiku}
end;

procedure MAIN;  { hlavn proces - procedura ktera se provadi cyklicky}
begin                             {po celou dobu behu automatu }
  if OLDSEC<>SYSSec then     {pokud dojde ke zmene sekundove rucicky,}
  begin                      {spocitej nove souradnice vcech rucicek}
    OLDSEC:=SYSSec;
    TERM_LED:=not TERM_LED;  {Blikni s LED diodami na TERMINALU}

    {vypocet souradnic XY pro jednotlive rucicky}
    {---------- sekundy ---------------}
    ASec:=SYSSEC; {SysSec typu Byte, pro nasobeni 6 je nutno presunout}
    ASec:=6*ASec; {do vyssiho typu}
    ResultSin:=Sin(ASec);
    ResultCos:=Cos(ASec);
    XSec:=X+RSec*ResultSin;
    YSec:=Y-RSec*ResultCos;
    XSec1:=X-RSec*ResultSin/5; { pretazeni sec. rucicky na druhou stranu }
    YSec1:=Y+RSec*ResultCos/5;

    {vypocet souradnic XY pro jednotlive rucicky}
    {---------- Minuty ----------------}

    AMin:=SysMin;
    AMin:=6*AMin+SysSec/10-90;
    XMin:=X+RMin*Cos(AMin);
    YMin:=Y+RMin*Sin(AMin);

    {vypocet souradnic XY pro jednotlive rucicky}
    {---------- Hodiny ----------------}

    W_HOUR:=SYSHOUR;
    if W_HOUR>=12 then W_HOUR:=W_HOUR-12;
    MALARUC:=(W_HOUR*60+SYSmin)/12; { aritmetika nad typem word! }

    AHod:=6*MalaRuc-90;
    XHod:=X+RHod*Cos(AHod);
    YHod:=Y+RHod*Sin(AHod);

   {Pokud je zapnuta funkce Budik, vyvolej alarm pri prekroceni casu}
   { zapnuti pipani budiku ve spravny cas }
   if (Budik_On=$FF) and (Budik_HH=SYSHOUR) and (Budik_MM=SYSMIN) then
   begin
     Budik_Beep:=1;
     TimerOn(Budik_T,per1s);
   end;
  end;
  if Budik_On then  {pokud je budik zapnut}
  begin
    if Term_Stop then  {Zastaveni budiku klavesou STOP}
    begin
      Term_Beep:=0;
      Budik_Beep:=0;
      Budik_ON:=0;
      TimerOff(Budik_T);
      Budik_T   :=0;
      Term_Stop :=0;
      SetBudikZobr;
    end;
    if Budik_Beep then             {Pokud budik zvoni, }
      Term_Beep:=(Budik_T and 1);  {prerusuj zvoneni kazdou SEKUNDU}
  end;
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                          {Nastavime font 0}
  pos 95,10;  print time SYSHOUR;  {Na pozici position vypiseme systemovy cas}

  Case Budik_Zobr of          {Za pouziti prikazu Case a jeho nastaveni v MAIN}
    1: begin                  {vypiseme text "BUDIK" a nastaveny cas buzeni}
         pos 88,26; print "Budk ", Budik_HH,":0",Budik_MM;
         pos 88,26; print "Budk ", Budik_HH,":0",Budik_MM;
       end;
    2: begin
         pos 88,26; print "Budk ", Budik_HH,":",Budik_MM;
         pos 88,26; print "Budk ", Budik_HH,":",Budik_MM;
       end;
  end;

  font 0;                           {Nastavime font 0}
  pos 100,90; case SYSDOW of        {a za pouziti funkce CASE}
		    0: print "nedle";  {vytiskneme nazev dne}
		    1: print "pondl";
		    2: print " ter";
		    3: print "steda";
		    4: print "tvrtek";
		    5: print " ptek";
		    6: print "sobota";
              end; {case}

  pos 86,100;  print date SYSYEAR;  {a vytiskneme systemovy datum }

  circle X,Y,R;                     {Kruznice kolem ciferniku}

  line XSec1,YSec1,XSec,YSec;       {Rucicka SEKUNDY}

  line X,Y,XMin,YMin;               {Rucicka MINUTY}
  line X-1,Y,XMin,YMin;
  line X+1,Y,XMin,YMin;
  line X,Y-1,XMin,YMin;
  line X,Y+1,XMin,YMin;

  line X,Y,XHod,YHod;               {Rucicka HODINY}
  line X-1,Y,XHod,YHod;
  line X+1,Y,XHod,YHod;
  line X,Y-1,XHod,YHod;
  line X,Y+1,XHod,YHod;

  onkey                                    {definujeme reakci na klavesy}
   'B':begin                               {'B' - vykoname napsany program}
           Term_Beep:=0;                   {Pri nastavovani vypneme budik}
           Budik_Beep:=0;
           TimerOff(Budik_T);
           Budik_T   :=0;
           Budik_Ed:=Budik_HH;             {Pripravime editovanou hodnotu }
           Budik_Ed:=100*Budik_Ed+Budik_MM;{casu buzeni}
           TERM_SCRNO:=1;                  {a prejdeme na obrazovku 1}
         end;
  end;
help                                       {definice obrazovky HELP - aktivni}
  font 1;                                  {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda:";           {Na pozici ... umisti text ...}
  pos 20, 30; print "Editace asu i datumu - klvesa F10";
  pos 20, 40; print "Zapnut budku";
  pos 20, 50; print "Editace asu buzen    - klvesa B";
  pos 20, 60; print "Vypnut budku         - klvesa STOP";
  pos 20,110; print "Zpt klvesou ESC.";
end;

{ Popis obrazovky c.1 terminalu TERM10 }
terminal TERM:1;
begin
  font 1;                                  {Nastavime font 1}
  pos 20, 20;  print "Soucasny cas: ",time SYSHOUR; {Na pozici position
                                           vypiseme systemovy cas,
                                           POZOR, tento cas se z duvodu
                                           zapnuti editacni obrazovky jiz
                                           dale na obrazovce neprepisuje.}

  pos 20, 40; print "Nastaven budku";    {Na pozici position vypiseme text}
  pos 20, 50; print "ve formatu HHMM:";font 0;pos 120,50;edit Budik_Ed:4,0,2400;
                                           {Vytiskneme text a vyhradime misto
                                            pro editaci promenne Budik_ED}
  font 1;                                  {Protoze editaci provadime jinym
                                            fontem, nastavime opet font 1}
  pos 20,110; print "Npovda - klvesa F1";

  EditEnter                           {Pokud editaci ukoncime klavesou ENTER}
  begin                               {dojde ke zpracovani nasledneho kodu:}
    Budik_Pom:=Budik_Ed/100;          {Rozdekodovani a kontrole casoveho udaje}
    Budik_HH:=Budik_Pom;
    Budik_MM:=Budik_Ed-Budik_Pom*100;
    if Budik_MM>59 then Budik_MM:=0;
    Budik_ON:=$FF;                    {Zapnuti budiku}
    SetBudikZobr;                     {Nastaveni zobrazovanych udaju na TERM}
  end;
help                                  {definice obrazovky HELP - aktivni}
  font 1;                             {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda:";      {Na pozici ... umisti text ...}
  pos 20, 30; print "Zapnut a nastaven asu budku.";
  pos 20, 40; print "nastavte as a potvrdte hodnotu";
  pos 20, 50; print "klvesou ENTER,";
  pos 20, 60; print "Zpt bez nastaven klvesou ESC.";
end;
