{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{
 Program demonstruje vypocet goniometrickych funkci
 sin, cos, ...
 Postupne je menen uhel z ktereho se pocitaji jednotlive
 funkcni hodnoty.
}
options gonio=dec;                 {argument fce sin a cos je ve stupnich}

configuration
  hwobj=TERM10, name=TERM, adr=$2300, var=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}
symbol
  Uhel = Integer;                  {promenna pro uchovani uhlu}
  vSin = Integer;                  {promenna pro vysledek funkce sin}
  vCos = Integer;                  {promenna pro vysledek funkce cos}
  T    = Word;                     {promenna casovace pro zmenu uhlu}

procedure INIT;                    {procedura INIT se vykona vzdy po RESETu}
begin                              { - slouzi k pocatecnimu nastaveni promennych}
  TimerOn(T,per10ms);              {Zapnuti casovace}
end;

{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  if T>20 then           {jakmile se casovac naplni na pozadovanou hodnotu}
  begin
    T:=0;                          {vynuluje se}
    if Uhel<360 then Uhel:=Uhel+5  {provede se generace noveho uhlu}
                else Uhel:=-359;
    vSin:=Sin(Uhel);               {a vypocitaji se nove funkcni hodnoty}
    vCos:=Cos(Uhel);
      {!Upozorneni funkce sin a cos pocita standartne ve stupnich a vysledek
                   vraci v intervalu <-100,100> coz odpovida hodnotam <-1,1>
                   s presnosti na dve desetinna mista. Pro presnejsi vypocet
                   je nutno pouzit format RAD, pak dochazi k presnosti dane
                   typem REAL, viz DGONIOR}
  end;
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                                          {Nastavime font 1}
  position 10,10; print "Ukazka pouziti goniometrickych funkci"; {Na pozici position ...
                                                     Vytiskneme text ...}
  position 10,50; print "Sin(",Uhel:0,")=",vSin:0:2;{na pozici position ...
                                                      vytiskneme text a obsah promennych
                                                      Zde vyuzivame moznosti tisknout celych
                                                      cisel ve formatu s pevnou radovou carkou,
                                                      pocet mist za carkou udava druhy
                                                      formatovaci parametr, ktery je nepovinny}
  position 10,70; print "Cos(",Uhel:0,")=",vCos:0:2;{na pozici position ...
                                                      vytiskneme text a obsah promennych }

  help                                             {definice obrazovky HELP - aktivni}
    font 1;                                        {pri stisku F1, nastaveni fontu}
    position 10,10; print "Npovda:";             {Na pozici ... umisti text ...}
    position 10,35; print "Ukazka pouziti";
    position 20,45; print "goniometrickych funkci";
end;
